"use strict";
/*!
 * handlebars-helpers <https://github.com/helpers/handlebars-helpers>
 *
 * Copyright (c) 2013-2017, Jon Schlinkert, Brian Woodward.
 * Released under the MIT License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.url = exports.string = exports.number = exports.math = exports.date = exports.comparison = exports.collection = exports.array = void 0;
const array_1 = __importDefault(require("./lib/array"));
const collection_1 = __importDefault(require("./lib/collection"));
const comparison_1 = __importDefault(require("./lib/comparison"));
const date_1 = __importDefault(require("./lib/date"));
const math_1 = __importDefault(require("./lib/math"));
const number_1 = __importDefault(require("./lib/number"));
const string_1 = __importDefault(require("./lib/string"));
const url_1 = __importDefault(require("./lib/url"));
// Individual helper collections
exports.array = array_1.default;
exports.collection = collection_1.default;
exports.comparison = comparison_1.default;
exports.date = date_1.default;
exports.math = math_1.default;
exports.number = number_1.default;
exports.string = string_1.default;
exports.url = url_1.default;
function handlebarsHelpers(names) {
    // If called without arguments, return all helpers
    if (!names) {
        return Object.assign({}, array_1.default, collection_1.default, comparison_1.default, date_1.default, math_1.default, number_1.default, string_1.default, url_1.default);
    }
    // If it's an options object with handlebars instance
    if (typeof names === 'object' && !Array.isArray(names) && names.handlebars) {
        const allHelpers = Object.assign({}, array_1.default, collection_1.default, comparison_1.default, date_1.default, math_1.default, number_1.default, string_1.default, url_1.default);
        // Register all helpers
        for (const name in allHelpers) {
            names.handlebars.registerHelper(name, allHelpers[name]);
        }
        return allHelpers;
    }
    // If array of specific helper collections
    if (Array.isArray(names)) {
        const result = {};
        for (const name of names) {
            switch (name) {
                case 'array':
                    Object.assign(result, array_1.default);
                    break;
                case 'collection':
                    Object.assign(result, collection_1.default);
                    break;
                case 'comparison':
                    Object.assign(result, comparison_1.default);
                    break;
                case 'date':
                    Object.assign(result, date_1.default);
                    break;
                case 'math':
                    Object.assign(result, math_1.default);
                    break;
                case 'number':
                    Object.assign(result, number_1.default);
                    break;
                case 'string':
                    Object.assign(result, string_1.default);
                    break;
                case 'url':
                    Object.assign(result, url_1.default);
                    break;
            }
        }
        return result;
    }
    return {};
}
// Add getters for individual collections
Object.defineProperty(handlebarsHelpers, 'array', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in array_1.default) {
                    options.handlebars.registerHelper(name, array_1.default[name]);
                }
            }
            return array_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'collection', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in collection_1.default) {
                    options.handlebars.registerHelper(name, collection_1.default[name]);
                }
            }
            return collection_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'comparison', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in comparison_1.default) {
                    options.handlebars.registerHelper(name, comparison_1.default[name]);
                }
            }
            return comparison_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'date', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in date_1.default) {
                    options.handlebars.registerHelper(name, date_1.default[name]);
                }
            }
            return date_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'math', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in math_1.default) {
                    options.handlebars.registerHelper(name, math_1.default[name]);
                }
            }
            return math_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'number', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in number_1.default) {
                    options.handlebars.registerHelper(name, number_1.default[name]);
                }
            }
            return number_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'string', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in string_1.default) {
                    options.handlebars.registerHelper(name, string_1.default[name]);
                }
            }
            return string_1.default;
        };
    }
});
Object.defineProperty(handlebarsHelpers, 'url', {
    get: function () {
        return function (options) {
            if (options && options.handlebars) {
                for (const name in url_1.default) {
                    options.handlebars.registerHelper(name, url_1.default[name]);
                }
            }
            return url_1.default;
        };
    }
});
exports.default = handlebarsHelpers;
//# sourceMappingURL=index.js.map