"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const url = __importStar(require("url"));
const util = __importStar(require("handlebars-utils"));
const querystring = __importStar(require("querystring"));
const helpers = {};
/**
 * Stringify an object to JSON.
 *
 * ```handlebars
 * {{JSONstringify obj}}
 * <!-- results in: '{"foo":"bar"}' -->
 * ```
 * @param {Object} `obj` Object to stringify
 * @return {String} JSON string
 * @api public
 */
helpers.JSONstringify = function (obj) {
    return JSON.stringify(obj);
};
/**
 * Encodes a Uniform Resource Identifier (URI) component
 * by replacing each instance of certain characters by
 * one, two, three, or four escape sequences representing
 * the UTF-8 encoding of the character.
 *
 * @param {String} `str` The un-encoded string
 * @return {String} The endcoded string
 * @api public
 */
helpers.encodeURI = function (str) {
    if (util.isString(str)) {
        return encodeURIComponent(str);
    }
};
/**
 * Escape the given string by replacing characters with escape sequences.
 * Useful for allowing the string to be used in a URL, etc.
 *
 * @param {String} `str`
 * @return {String} Escaped string.
 * @api public
 */
helpers.escape = function (str) {
    if (util.isString(str)) {
        return querystring.escape(str);
    }
};
/**
 * Decode a Uniform Resource Identifier (URI) component.
 *
 * @param {String} `str`
 * @return {String}
 * @api public
 */
helpers.decodeURI = function (str) {
    if (util.isString(str)) {
        return decodeURIComponent(str);
    }
};
/**
 * Alias for [encodeURI](#encodeuri).
 * @api public
 */
helpers.url_encode = function () {
    return helpers.encodeURI.apply(this, arguments);
};
/**
 * Alias for [decodeURI](#decodeuri).
 * @api public
 */
helpers.url_decode = function (val) {
    return helpers.decodeURI.apply(this, arguments);
};
/**
 * Take a base URL, and a href URL, and resolve them as a
 * browser would for an anchor tag.
 *
 * @param {String} `base`
 * @param {String} `href`
 * @return {String}
 * @api public
 */
helpers.urlResolve = function (base, href) {
    return url.resolve(base, href);
};
/**
 * Parses a `url` string into an object.
 *
 * @param {String} `str` URL string
 * @return {String} Returns stringified JSON
 * @api public
 */
helpers.urlParse = function (str) {
    return url.parse(str);
};
/**
 * Takes a parsed url object and returns a formatted url string.
 *
 * ```handlebars
 * <!-- url = {protocol: 'https:', host: 'github.com', pathname: '/helpers/handlebars-helpers'} -->
 * {{urlResolve url}}
 * <!-- results in: 'https://github.com/helpers/handlebars-helpers' -->
 * ```
 * @param {Object} `urlObject` URL object
 * @return {String}
 * @api public
 */
helpers.urlFormat = function (urlObject) {
    return url.format(urlObject);
};
/**
 * Strip the query string from the given `url`.
 *
 * @param {String} `url`
 * @return {String} the url without the queryString
 * @api public
 */
helpers.stripQuerystring = function (str) {
    if (util.isString(str)) {
        return str.split('?')[0];
    }
};
/**
 * Strip protocol from a `url`. Useful for displaying media that
 * may have an 'http' protocol on secure connections.
 *
 * ```handlebars
 * <!-- url = 'http://foo.bar' -->
 * {{stripProtocol url}}
 * <!-- results in: '//foo.bar' -->
 * ```
 * @param {String} `str`
 * @return {String} the url with http protocol stripped
 * @api public
 */
helpers.stripProtocol = function (str) {
    if (util.isString(str)) {
        var parsed = url.parse(str);
        parsed.protocol = '';
        return url.format(parsed);
    }
};
exports.default = helpers;
//# sourceMappingURL=url.js.map