"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.forIn = exports.sortBy = exports.createFrame = exports.get = void 0;
exports.isNumber = isNumber;
exports.isEven = isEven;
exports.falsey = falsey;
exports.contains = contains;
exports.chop = chop;
exports.changecase = changecase;
exports.identity = identity;
exports.random = random;
exports.forEach = forEach;
exports.forOwn = forOwn;
const get_value_1 = __importDefault(require("get-value"));
const create_frame_1 = __importDefault(require("create-frame"));
const array_sort_1 = __importDefault(require("array-sort"));
const for_in_1 = __importDefault(require("for-in"));
exports.get = get_value_1.default;
exports.createFrame = create_frame_1.default;
exports.sortBy = array_sort_1.default;
exports.forIn = for_in_1.default;
// Replace simple dependencies with native implementations
function isNumber(value) {
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}
function isEven(value) {
    return isNumber(value) && value % 2 === 0;
}
function falsey(value, keywords) {
    // Default falsey keywords from the original falsey library
    const defaultKeywords = ['false', 'null', 'undefined', 'nil', 'nope', 'no', 'nah', 'nay', ''];
    const allKeywords = keywords ? defaultKeywords.concat(keywords) : defaultKeywords;
    // Standard JavaScript falsey values
    if (!value || value === 0 || value === '' || value === null || value === undefined || value === false) {
        return true;
    }
    // Check against keyword strings (case insensitive)
    if (typeof value === 'string') {
        return allKeywords.includes(value.toLowerCase());
    }
    return false;
}
// Add some utility functions that may be needed
function contains(val, obj, start) {
    if (val == null || obj == null || !isNumber(val.length)) {
        return false;
    }
    return val.indexOf(obj, start) !== -1;
}
function chop(str) {
    if (typeof str !== 'string')
        return '';
    const re = /^[-_.\W\s]+|[-_.\W\s]+$/g;
    return str.trim().replace(re, '');
}
function changecase(str, fn) {
    if (typeof str !== 'string')
        return '';
    if (str.length === 1) {
        return str.toLowerCase();
    }
    str = chop(str).toLowerCase();
    if (typeof fn !== 'function') {
        fn = identity;
    }
    const re = /[-_.\W\s]+(\w|$)/g;
    return str.replace(re, function (_, ch) {
        return fn(ch);
    });
}
function identity(value) {
    return value;
}
function random(min, max) {
    return min + Math.floor(Math.random() * (max - min + 1));
}
function forEach(array, options) {
    var data = (0, exports.createFrame)(options, options.hash);
    var len = array.length;
    var buffer = '';
    var i = -1;
    while (++i < len) {
        var item = array[i];
        data.index = i;
        item.index = i + 1;
        item.total = len;
        item.isFirst = i === 0;
        item.isLast = i === (len - 1);
        buffer += options.fn(item, { data: data });
    }
    return buffer;
}
function forOwn(obj, options) {
    var data = (0, exports.createFrame)(options, options.hash);
    var buffer = '';
    for (var key in obj) {
        if (obj.hasOwnProperty(key)) {
            var item = obj[key];
            data.key = key;
            buffer += options.fn(item, { data: data });
        }
    }
    return buffer;
}
//# sourceMappingURL=utils.js.map