# handlebars-utils [![NPM version](https://img.shields.io/npm/v/handlebars-utils.svg?style=flat)](https://www.npmjs.com/package/handlebars-utils) [![NPM monthly downloads](https://img.shields.io/npm/dm/handlebars-utils.svg?style=flat)](https://npmjs.org/package/handlebars-utils) [![NPM total downloads](https://img.shields.io/npm/dt/handlebars-utils.svg?style=flat)](https://npmjs.org/package/handlebars-utils) [![Linux Build Status](https://img.shields.io/travis/helpers/handlebars-utils.svg?style=flat&label=Travis)](https://travis-ci.org/helpers/handlebars-utils)

> Utils for handlebars helpers. Externalized from handlebars, to allow helpers to use the utils without having to depend on handlebars itself.

Follow this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), for updates on this project and others.

- [Install](#install)
- [Usage](#usage)
- [API](#api)
  * [.isBlock](#isblock)
  * [.fn](#fn)
  * [.inverse](#inverse)
  * [.value](#value)
  * [.isOptions](#isoptions)
  * [.isUndefined](#isundefined)
  * [.isApp](#isapp)
  * [.options](#options)
  * [.context](#context)
  * [.isObject](#isobject)
  * [.isEmpty](#isempty)
  * [.result](#result)
  * [.identity](#identity)
  * [.isString](#isstring)
  * [.arrayify](#arrayify)
  * [.tryParse](#tryparse)
- [About](#about)
  * [Related projects](#related-projects)
  * [Contributing](#contributing)
  * [Building docs](#building-docs)
  * [Running tests](#running-tests)
  * [Author](#author)
  * [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save handlebars-utils
```

## Usage

```js
var utils = require('handlebars-utils');
```

## API

### [.isBlock](index.js#L156)

Returns true if a helper is a block helper.

**Params**

* `options` **{Object}**: Helper options object
* `returns` **{Boolean}**

**Example**

```js
Handlebars.registerHelper('example', function(options) {
  if (utils.isBlock(options)) {
    // do something if this is a block helper
  } else {
    // do something else if this is a not block helper
  }
});
```

### [.fn](index.js#L177)

Returns the given value or renders the block if it's a block helper.

**Params**

* `val` **{any}**
* `options` **{Object}**
* `context` **{Object}**
* `returns` **{String}**: Either returns the value, or renders the block.

**Example**

```js
Handlebars.registerHelper('example', function(val, locals, options) {
  return utils.fn(val, locals, options);
});
```

### [.inverse](index.js#L202)

Returns the given value or renders the inverse block if it's a block helper.

**Params**

* `val` **{any}**
* `options` **{Object}**
* `context` **{Object}**
* `returns` **{String}**: Either returns the value, or renders the inverse block.

**Example**

```js
Handlebars.registerHelper('example', function(val, locals, options) {
  return utils.inverse(val, locals, options);
});
```

### [.value](index.js#L229)

Gets the return value for a helper, by either rendering the block or inverse block if it's a block helper, or returning the given value (when truthy) or an empty string (when falsey) if it's a non-block expression.

**Params**

* `val` **{any}**
* `options` **{Object}**
* `context` **{Object}**
* `returns` **{String}**

**Example**

```js
Handlebars.registerHelper('example', function(val, locals, options) {
  return utils.value(val, locals, options);
});
```

### [.isOptions](index.js#L259)

Returns true if the given value is a handlebar `options` object.

**Params**

* `val` **{Object}**
* `returns` **{Boolean}**

**Example**

```js
Handlebars.registerHelper('example', function(val, locals, options) {
  if (utils.isOptions(locals)) {
    options = locals;
    locals = {};
  }
  // do stuff
});
```

### [.isUndefined](index.js#L280)

Returns true if the given value is `undefined` or is a handlebars options hash (which means that a value was not passed by the user).

**Params**

* `value` **{any}**
* `returns` **{Boolean}**

**Example**

```js
Handlebars.registerHelper('example', function(val, options) {
  if (utils.isUndefined(val)) {
    return '';
  }
  // do stuff
});
```

### [.isApp](index.js#L303)

Returns true if an `app` propery is on the context, which means the context was created by [assemble](https://github.com/assemble/assemble), [templates](https://github.com/jonschlinkert/templates), [verb](https://github.com/verbose/verb), or any other library that follows this convention.

**Params**

* `value` **{any}**
* `returns` **{Boolean}**

**Example**

```js
Handlebars.registerHelper('example', function(val, options) {
  var context = options.hash;
  if (utils.isApp(this)) {
    context = Object.assign({}, this.context, context);
  }
  // do stuff
});
```

### [.options](index.js#L322)

Creates an options object from the `context`, `locals` and `options.`
Handlebars' `options.hash` is merged onto the options, and if the context
is created by [templates](https://github.com/jonschlinkert/templates), `this.options` will be merged onto the
options as well.

**Params**

* `context` **{Object}**
* `locals` **{Object}**: Options or locals
* `options` **{Object}**
* `returns` **{Boolean}**

### [.context](index.js#L351)

Get the context to use for rendering.

**Params**

* `thisArg` **{Object}**: Optional invocation context `this`
* `returns` **{Object}**

### [.isObject](index.js#L398)

Returns true if the given value is an object.

**Params**

* `val` **{Object}**
* `returns` **{Boolean}**

**Example**

```js
console.log(utils.isObject(null));
//=> false
console.log(utils.isObject([]));
//=> false
console.log(utils.isObject(function() {}));
//=> false
console.log(utils.isObject({}));
//=> true
```

### [.isEmpty](index.js#L421)

Returns true if the given value is "empty".

**Params**

* `value` **{any}**
* `returns` **{Boolean}**

**Example**

```js
console.log(utils.isEmpty(0));
//=> false
console.log(utils.isEmpty(''));
//=> true
console.log(utils.isEmpty([]));
//=> true
console.log(utils.isEmpty({}));
//=> true
```

### [.result](index.js#L454)

Returns the given value. If the value is a function it will be called with the current context, otherwise the value is returned.

**Params**

* `val` **{any}**
* `returns` **{any}**

**Example**

```js
console.log(utils.result('foo'));
//=> 'foo'
console.log(utils.result(function() {
  return 'foo';
}));
//=> 'foo'
```

### [.identity](index.js#L477)

Returns the given value as-is, unchanged.

**Params**

* `val` **{any}**
* `returns` **{any}**

**Example**

```js
console.log(utils.result('foo'));
//=> 'foo'
console.log(utils.result(function() {
  return 'foo';
}));
//=> [function]
```

### [.isString](index.js#L489)

Return true if `val` is a non-empty string.

**Params**

* `val` **{any}**: The value to check
* `returns` **{Boolean}**

### [.arrayify](index.js#L509)

Cast the given `val` to an array.

**Params**

* `val` **{any}**
* `returns` **{Array}**

**Example**

```js
console.log(utils.arrayify(''));
//=> []
console.log(utils.arrayify('foo'));
//=> ['foo']
console.log(utils.arrayify(['foo']));
//=> ['foo']
```

### [.tryParse](index.js#L522)

Try to parse the given `string` as JSON. Fails
gracefully and always returns an object if the value cannot be parsed.

**Params**

* `string` **{String}**
* `returns` **{Object}**

## About

### Related projects

You might also be interested in these projects:

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [handlebars-helpers](https://www.npmjs.com/package/handlebars-helpers): More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate… [more](https://github.com/helpers/handlebars-helpers) | [homepage](https://github.com/helpers/handlebars-helpers "More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate, Verb, Ghost, gulp-handlebars, grunt-handlebars, consolidate, or any node.js/Handlebars project.")
* [template-helpers](https://www.npmjs.com/package/template-helpers): Generic JavaScript helpers that can be used with any template engine. Handlebars, Lo-Dash, Underscore, or… [more](https://github.com/jonschlinkert/template-helpers) | [homepage](https://github.com/jonschlinkert/template-helpers "Generic JavaScript helpers that can be used with any template engine. Handlebars, Lo-Dash, Underscore, or any engine that supports helper functions.")
* [templates](https://www.npmjs.com/package/templates): System for creating and managing template collections, and rendering templates with any node.js template engine… [more](https://github.com/jonschlinkert/templates) | [homepage](https://github.com/jonschlinkert/templates "System for creating and managing template collections, and rendering templates with any node.js template engine. Can be used as the basis for creating a static site generator or blog framework.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on September 04, 2017._