## Supported commands ![Commands Coverage: 66%](https://img.shields.io/badge/coverage-66%25-orange.svg)

> PRs welcome :heart:

| redis                  |      ioredis       |    ioredis-mock    |
| ---------------------- | :----------------: | :----------------: |
| [acl]                  | :white_check_mark: |        :x:         |
| [append]               | :white_check_mark: | :white_check_mark: |
| [asking]               | :white_check_mark: | :white_check_mark: |
| [auth]                 | :white_check_mark: | :white_check_mark: |
| [bgrewriteaof]         | :white_check_mark: | :white_check_mark: |
| [bgsave]               | :white_check_mark: | :white_check_mark: |
| [bitcount]             | :white_check_mark: |        :x:         |
| [bitfield]             | :white_check_mark: |        :x:         |
| [bitfield_ro]          | :white_check_mark: |        :x:         |
| [bitop]                | :white_check_mark: |        :x:         |
| [bitpos]               | :white_check_mark: |        :x:         |
| [blmove]               | :white_check_mark: |        :x:         |
| [blmpop]               | :white_check_mark: |        :x:         |
| [blpop]                | :white_check_mark: |        :x:         |
| [brpop]                | :white_check_mark: |        :x:         |
| [brpoplpush]           | :white_check_mark: | :white_check_mark: |
| [bzmpop]               | :white_check_mark: |        :x:         |
| [bzpopmax]             | :white_check_mark: |        :x:         |
| [bzpopmin]             | :white_check_mark: |        :x:         |
| [client]               | :white_check_mark: |        :x:         |
| [cluster]              | :white_check_mark: | :white_check_mark: |
| [command]              | :white_check_mark: | :white_check_mark: |
| [config]               | :white_check_mark: | :white_check_mark: |
| [copy]                 | :white_check_mark: |        :x:         |
| [dbsize]               | :white_check_mark: | :white_check_mark: |
| [decr]                 | :white_check_mark: | :white_check_mark: |
| [decrby]               | :white_check_mark: | :white_check_mark: |
| [del]                  | :white_check_mark: | :white_check_mark: |
| [discard]              | :white_check_mark: | :white_check_mark: |
| [echo]                 | :white_check_mark: | :white_check_mark: |
| [eval]                 | :white_check_mark: | :white_check_mark: |
| [eval_ro]              | :white_check_mark: |        :x:         |
| [evalsha]              | :white_check_mark: | :white_check_mark: |
| [evalsha_ro]           | :white_check_mark: |        :x:         |
| [exists]               | :white_check_mark: | :white_check_mark: |
| [expire]               | :white_check_mark: | :white_check_mark: |
| [expireat]             | :white_check_mark: | :white_check_mark: |
| [expiretime]           | :white_check_mark: | :white_check_mark: |
| [failover]             | :white_check_mark: | :white_check_mark: |
| [fcall]                | :white_check_mark: |        :x:         |
| [fcall_ro]             | :white_check_mark: |        :x:         |
| [flushall]             | :white_check_mark: | :white_check_mark: |
| [flushdb]              | :white_check_mark: | :white_check_mark: |
| [function]             | :white_check_mark: |        :x:         |
| [geoadd]               | :white_check_mark: |        :x:         |
| [geodist]              | :white_check_mark: |        :x:         |
| [geohash]              | :white_check_mark: |        :x:         |
| [geopos]               | :white_check_mark: |        :x:         |
| [georadius]            | :white_check_mark: |        :x:         |
| [georadius_ro]         | :white_check_mark: |        :x:         |
| [georadiusbymember]    | :white_check_mark: |        :x:         |
| [georadiusbymember_ro] | :white_check_mark: |        :x:         |
| [geosearch]            | :white_check_mark: |        :x:         |
| [geosearchstore]       | :white_check_mark: |        :x:         |
| [get]                  | :white_check_mark: | :white_check_mark: |
| [getbit]               | :white_check_mark: | :white_check_mark: |
| [getdel]               | :white_check_mark: | :white_check_mark: |
| [getex]                | :white_check_mark: | :white_check_mark: |
| [getrange]             | :white_check_mark: | :white_check_mark: |
| [getset]               | :white_check_mark: | :white_check_mark: |
| [hdel]                 | :white_check_mark: | :white_check_mark: |
| [hexists]              | :white_check_mark: | :white_check_mark: |
| [hget]                 | :white_check_mark: | :white_check_mark: |
| [hgetall]              | :white_check_mark: | :white_check_mark: |
| [hincrby]              | :white_check_mark: | :white_check_mark: |
| [hincrbyfloat]         | :white_check_mark: | :white_check_mark: |
| [hkeys]                | :white_check_mark: | :white_check_mark: |
| [hlen]                 | :white_check_mark: | :white_check_mark: |
| [hmget]                | :white_check_mark: | :white_check_mark: |
| [hmset]                | :white_check_mark: | :white_check_mark: |
| [hrandfield]           | :white_check_mark: | :white_check_mark: |
| [hscan]                | :white_check_mark: | :white_check_mark: |
| [hset]                 | :white_check_mark: | :white_check_mark: |
| [hsetnx]               | :white_check_mark: | :white_check_mark: |
| [hstrlen]              | :white_check_mark: | :white_check_mark: |
| [hvals]                | :white_check_mark: | :white_check_mark: |
| [incr]                 | :white_check_mark: | :white_check_mark: |
| [incrby]               | :white_check_mark: | :white_check_mark: |
| [incrbyfloat]          | :white_check_mark: | :white_check_mark: |
| [info]                 | :white_check_mark: | :white_check_mark: |
| [keys]                 | :white_check_mark: | :white_check_mark: |
| [lastsave]             | :white_check_mark: | :white_check_mark: |
| [lcs]                  | :white_check_mark: |        :x:         |
| [lindex]               | :white_check_mark: | :white_check_mark: |
| [linsert]              | :white_check_mark: | :white_check_mark: |
| [llen]                 | :white_check_mark: | :white_check_mark: |
| [lmove]                | :white_check_mark: | :white_check_mark: |
| [lmpop]                | :white_check_mark: |        :x:         |
| [lolwut]               | :white_check_mark: | :white_check_mark: |
| [lpop]                 | :white_check_mark: | :white_check_mark: |
| [lpos]                 | :white_check_mark: |        :x:         |
| [lpush]                | :white_check_mark: | :white_check_mark: |
| [lpushx]               | :white_check_mark: | :white_check_mark: |
| [lrange]               | :white_check_mark: | :white_check_mark: |
| [lrem]                 | :white_check_mark: | :white_check_mark: |
| [lset]                 | :white_check_mark: | :white_check_mark: |
| [ltrim]                | :white_check_mark: | :white_check_mark: |
| [mget]                 | :white_check_mark: | :white_check_mark: |
| [monitor]              | :white_check_mark: |        :x:         |
| [move]                 | :white_check_mark: |        :x:         |
| [mset]                 | :white_check_mark: | :white_check_mark: |
| [msetnx]               | :white_check_mark: | :white_check_mark: |
| [object]               | :white_check_mark: | :white_check_mark: |
| [persist]              | :white_check_mark: | :white_check_mark: |
| [pexpire]              | :white_check_mark: | :white_check_mark: |
| [pexpireat]            | :white_check_mark: | :white_check_mark: |
| [pexpiretime]          | :white_check_mark: | :white_check_mark: |
| [pfadd]                | :white_check_mark: |        :x:         |
| [pfcount]              | :white_check_mark: |        :x:         |
| [pfmerge]              | :white_check_mark: |        :x:         |
| [ping]                 | :white_check_mark: | :white_check_mark: |
| [psetex]               | :white_check_mark: | :white_check_mark: |
| [psubscribe]           | :white_check_mark: | :white_check_mark: |
| [psync]                | :white_check_mark: |        :x:         |
| [pttl]                 | :white_check_mark: | :white_check_mark: |
| [publish]              | :white_check_mark: | :white_check_mark: |
| [pubsub]               | :white_check_mark: | :white_check_mark: |
| [punsubscribe]         | :white_check_mark: | :white_check_mark: |
| [quit]                 | :white_check_mark: | :white_check_mark: |
| [randomkey]            | :white_check_mark: | :white_check_mark: |
| [readonly]             | :white_check_mark: | :white_check_mark: |
| [readwrite]            | :white_check_mark: | :white_check_mark: |
| [rename]               | :white_check_mark: | :white_check_mark: |
| [renamenx]             | :white_check_mark: | :white_check_mark: |
| [replconf]             | :white_check_mark: | :white_check_mark: |
| [replicaof]            | :white_check_mark: | :white_check_mark: |
| [reset]                | :white_check_mark: |        :x:         |
| [role]                 | :white_check_mark: | :white_check_mark: |
| [rpop]                 | :white_check_mark: | :white_check_mark: |
| [rpoplpush]            | :white_check_mark: | :white_check_mark: |
| [rpush]                | :white_check_mark: | :white_check_mark: |
| [rpushx]               | :white_check_mark: | :white_check_mark: |
| [sadd]                 | :white_check_mark: | :white_check_mark: |
| [save]                 | :white_check_mark: | :white_check_mark: |
| [scan]                 | :white_check_mark: | :white_check_mark: |
| [scard]                | :white_check_mark: | :white_check_mark: |
| [script]               | :white_check_mark: |        :x:         |
| [sdiff]                | :white_check_mark: | :white_check_mark: |
| [sdiffstore]           | :white_check_mark: | :white_check_mark: |
| [select]               | :white_check_mark: |        :x:         |
| [set]                  | :white_check_mark: | :white_check_mark: |
| [setbit]               | :white_check_mark: | :white_check_mark: |
| [setex]                | :white_check_mark: | :white_check_mark: |
| [setnx]                | :white_check_mark: | :white_check_mark: |
| [setrange]             | :white_check_mark: | :white_check_mark: |
| [shutdown]             | :white_check_mark: |        :x:         |
| [sinter]               | :white_check_mark: | :white_check_mark: |
| [sintercard]           | :white_check_mark: |        :x:         |
| [sinterstore]          | :white_check_mark: | :white_check_mark: |
| [sismember]            | :white_check_mark: | :white_check_mark: |
| [slaveof]              | :white_check_mark: | :white_check_mark: |
| [smembers]             | :white_check_mark: | :white_check_mark: |
| [smismember]           | :white_check_mark: | :white_check_mark: |
| [smove]                | :white_check_mark: | :white_check_mark: |
| [sort]                 | :white_check_mark: |        :x:         |
| [sort_ro]              | :white_check_mark: |        :x:         |
| [spop]                 | :white_check_mark: | :white_check_mark: |
| [spublish]             | :white_check_mark: |        :x:         |
| [srandmember]          | :white_check_mark: | :white_check_mark: |
| [srem]                 | :white_check_mark: | :white_check_mark: |
| [sscan]                | :white_check_mark: | :white_check_mark: |
| [ssubscribe]           | :white_check_mark: |        :x:         |
| [strlen]               | :white_check_mark: | :white_check_mark: |
| [subscribe]            | :white_check_mark: | :white_check_mark: |
| [substr]               | :white_check_mark: | :white_check_mark: |
| [sunion]               | :white_check_mark: | :white_check_mark: |
| [sunionstore]          | :white_check_mark: | :white_check_mark: |
| [sunsubscribe]         | :white_check_mark: |        :x:         |
| [swapdb]               | :white_check_mark: |        :x:         |
| [sync]                 | :white_check_mark: |        :x:         |
| [time]                 | :white_check_mark: | :white_check_mark: |
| [touch]                | :white_check_mark: |        :x:         |
| [ttl]                  | :white_check_mark: | :white_check_mark: |
| [type]                 | :white_check_mark: | :white_check_mark: |
| [unlink]               | :white_check_mark: | :white_check_mark: |
| [unsubscribe]          | :white_check_mark: | :white_check_mark: |
| [unwatch]              | :white_check_mark: |        :x:         |
| [wait]                 | :white_check_mark: |        :x:         |
| [waitaof]              |        :x:         |        :x:         |
| [watch]                | :white_check_mark: |        :x:         |
| [xack]                 | :white_check_mark: |        :x:         |
| [xadd]                 | :white_check_mark: | :white_check_mark: |
| [xautoclaim]           | :white_check_mark: |        :x:         |
| [xclaim]               | :white_check_mark: |        :x:         |
| [xdel]                 | :white_check_mark: |        :x:         |
| [xgroup]               | :white_check_mark: |        :x:         |
| [xinfo]                | :white_check_mark: |        :x:         |
| [xlen]                 | :white_check_mark: | :white_check_mark: |
| [xpending]             | :white_check_mark: |        :x:         |
| [xrange]               | :white_check_mark: | :white_check_mark: |
| [xread]                | :white_check_mark: | :white_check_mark: |
| [xreadgroup]           | :white_check_mark: |        :x:         |
| [xrevrange]            | :white_check_mark: | :white_check_mark: |
| [xsetid]               | :white_check_mark: |        :x:         |
| [xtrim]                | :white_check_mark: |        :x:         |
| [zadd]                 | :white_check_mark: | :white_check_mark: |
| [zcard]                | :white_check_mark: | :white_check_mark: |
| [zcount]               | :white_check_mark: | :white_check_mark: |
| [zdiff]                | :white_check_mark: | :white_check_mark: |
| [zdiffstore]           | :white_check_mark: |        :x:         |
| [zincrby]              | :white_check_mark: | :white_check_mark: |
| [zinter]               | :white_check_mark: |        :x:         |
| [zintercard]           | :white_check_mark: |        :x:         |
| [zinterstore]          | :white_check_mark: | :white_check_mark: |
| [zlexcount]            | :white_check_mark: |        :x:         |
| [zmpop]                | :white_check_mark: |        :x:         |
| [zmscore]              | :white_check_mark: |        :x:         |
| [zpopmax]              | :white_check_mark: | :white_check_mark: |
| [zpopmin]              | :white_check_mark: | :white_check_mark: |
| [zrandmember]          | :white_check_mark: |        :x:         |
| [zrange]               | :white_check_mark: | :white_check_mark: |
| [zrangebylex]          | :white_check_mark: | :white_check_mark: |
| [zrangebyscore]        | :white_check_mark: | :white_check_mark: |
| [zrangestore]          | :white_check_mark: |        :x:         |
| [zrank]                | :white_check_mark: | :white_check_mark: |
| [zrem]                 | :white_check_mark: | :white_check_mark: |
| [zremrangebylex]       | :white_check_mark: |        :x:         |
| [zremrangebyrank]      | :white_check_mark: | :white_check_mark: |
| [zremrangebyscore]     | :white_check_mark: | :white_check_mark: |
| [zrevrange]            | :white_check_mark: | :white_check_mark: |
| [zrevrangebylex]       | :white_check_mark: | :white_check_mark: |
| [zrevrangebyscore]     | :white_check_mark: | :white_check_mark: |
| [zrevrank]             | :white_check_mark: | :white_check_mark: |
| [zscan]                | :white_check_mark: | :white_check_mark: |
| [zscore]               | :white_check_mark: | :white_check_mark: |
| [zunion]               | :white_check_mark: |        :x:         |
| [zunionstore]          | :white_check_mark: |        :x:         |

## Commands that won't be implemented

> This is just the current status, and may change in the future. If you have ideas on how to implement any of them feel free to tell us about it.

| redis     | why it doesn't make sense to emulate                                                                                                                              |
| :-------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [debug]   | This command is intended to aid in debugging redis                                                                                                                |
| [dump]    | Doesn't make sense to implement the internal data format used by RDB                                                                                              |
| [hello]   | The protocols this command is switching between (RESP2, RESP3, Redis 6) aren't in use                                                                             |
| [latency] | ioredis-mock isn't operating over the network so there is no latency to monitor                                                                                   |
| [memory]  | It's unlikely this can be emulated in a JS environment                                                                                                            |
| [migrate] | This command actually executes a DUMP + DEL on the source instance, and a RESTORE in the target. Since DUMP and RESTORE won't be implemented it includes MIGRATE. |
| [module]  | It's unlikely that we'll be able to run Redis Modules in a JS VM                                                                                                  |
| [pfdebug] | This command is intended to aid in debugging redis                                                                                                                |
| [restore] | The RDB specific format used for restores would be a massive undertaking to implement with very little gain.                                                      |
| [slowlog] | Useful when you're on redis, not so much when on ioredis-mock                                                                                                     |

[1]: https://github.com/luin/ioredis#handle-binary-data
[acl]: http://redis.io/commands/ACL
[append]: http://redis.io/commands/APPEND
[asking]: http://redis.io/commands/ASKING
[auth]: http://redis.io/commands/AUTH
[bgrewriteaof]: http://redis.io/commands/BGREWRITEAOF
[bgsave]: http://redis.io/commands/BGSAVE
[bitcount]: http://redis.io/commands/BITCOUNT
[bitfield]: http://redis.io/commands/BITFIELD
[bitfield_ro]: http://redis.io/commands/BITFIELD_RO
[bitop]: http://redis.io/commands/BITOP
[bitpos]: http://redis.io/commands/BITPOS
[blmove]: http://redis.io/commands/BLMOVE
[blmpop]: http://redis.io/commands/BLMPOP
[blpop]: http://redis.io/commands/BLPOP
[brpop]: http://redis.io/commands/BRPOP
[brpoplpush]: http://redis.io/commands/BRPOPLPUSH
[bzmpop]: http://redis.io/commands/BZMPOP
[bzpopmax]: http://redis.io/commands/BZPOPMAX
[bzpopmin]: http://redis.io/commands/BZPOPMIN
[client]: http://redis.io/commands/CLIENT
[cluster]: http://redis.io/commands/CLUSTER
[command]: http://redis.io/commands/COMMAND
[config]: http://redis.io/commands/CONFIG
[copy]: http://redis.io/commands/COPY
[dbsize]: http://redis.io/commands/DBSIZE
[decr]: http://redis.io/commands/DECR
[decrby]: http://redis.io/commands/DECRBY
[del]: http://redis.io/commands/DEL
[discard]: http://redis.io/commands/DISCARD
[echo]: http://redis.io/commands/ECHO
[eval]: http://redis.io/commands/EVAL
[eval_ro]: http://redis.io/commands/EVAL_RO
[evalsha]: http://redis.io/commands/EVALSHA
[evalsha_ro]: http://redis.io/commands/EVALSHA_RO
[exists]: http://redis.io/commands/EXISTS
[expire]: http://redis.io/commands/EXPIRE
[expireat]: http://redis.io/commands/EXPIREAT
[expiretime]: http://redis.io/commands/EXPIRETIME
[failover]: http://redis.io/commands/FAILOVER
[fcall]: http://redis.io/commands/FCALL
[fcall_ro]: http://redis.io/commands/FCALL_RO
[flushall]: http://redis.io/commands/FLUSHALL
[flushdb]: http://redis.io/commands/FLUSHDB
[function]: http://redis.io/commands/FUNCTION
[geoadd]: http://redis.io/commands/GEOADD
[geodist]: http://redis.io/commands/GEODIST
[geohash]: http://redis.io/commands/GEOHASH
[geopos]: http://redis.io/commands/GEOPOS
[georadius]: http://redis.io/commands/GEORADIUS
[georadius_ro]: http://redis.io/commands/GEORADIUS_RO
[georadiusbymember]: http://redis.io/commands/GEORADIUSBYMEMBER
[georadiusbymember_ro]: http://redis.io/commands/GEORADIUSBYMEMBER_RO
[geosearch]: http://redis.io/commands/GEOSEARCH
[geosearchstore]: http://redis.io/commands/GEOSEARCHSTORE
[get]: http://redis.io/commands/GET
[getbit]: http://redis.io/commands/GETBIT
[getdel]: http://redis.io/commands/GETDEL
[getex]: http://redis.io/commands/GETEX
[getrange]: http://redis.io/commands/GETRANGE
[getset]: http://redis.io/commands/GETSET
[hdel]: http://redis.io/commands/HDEL
[hexists]: http://redis.io/commands/HEXISTS
[hget]: http://redis.io/commands/HGET
[hgetall]: http://redis.io/commands/HGETALL
[hincrby]: http://redis.io/commands/HINCRBY
[hincrbyfloat]: http://redis.io/commands/HINCRBYFLOAT
[hkeys]: http://redis.io/commands/HKEYS
[hlen]: http://redis.io/commands/HLEN
[hmget]: http://redis.io/commands/HMGET
[hmset]: http://redis.io/commands/HMSET
[hrandfield]: http://redis.io/commands/HRANDFIELD
[hscan]: http://redis.io/commands/HSCAN
[hset]: http://redis.io/commands/HSET
[hsetnx]: http://redis.io/commands/HSETNX
[hstrlen]: http://redis.io/commands/HSTRLEN
[hvals]: http://redis.io/commands/HVALS
[incr]: http://redis.io/commands/INCR
[incrby]: http://redis.io/commands/INCRBY
[incrbyfloat]: http://redis.io/commands/INCRBYFLOAT
[info]: http://redis.io/commands/INFO
[keys]: http://redis.io/commands/KEYS
[lastsave]: http://redis.io/commands/LASTSAVE
[lcs]: http://redis.io/commands/LCS
[lindex]: http://redis.io/commands/LINDEX
[linsert]: http://redis.io/commands/LINSERT
[llen]: http://redis.io/commands/LLEN
[lmove]: http://redis.io/commands/LMOVE
[lmpop]: http://redis.io/commands/LMPOP
[lolwut]: http://redis.io/commands/LOLWUT
[lpop]: http://redis.io/commands/LPOP
[lpos]: http://redis.io/commands/LPOS
[lpush]: http://redis.io/commands/LPUSH
[lpushx]: http://redis.io/commands/LPUSHX
[lrange]: http://redis.io/commands/LRANGE
[lrem]: http://redis.io/commands/LREM
[lset]: http://redis.io/commands/LSET
[ltrim]: http://redis.io/commands/LTRIM
[mget]: http://redis.io/commands/MGET
[monitor]: http://redis.io/commands/MONITOR
[move]: http://redis.io/commands/MOVE
[mset]: http://redis.io/commands/MSET
[msetnx]: http://redis.io/commands/MSETNX
[object]: http://redis.io/commands/OBJECT
[persist]: http://redis.io/commands/PERSIST
[pexpire]: http://redis.io/commands/PEXPIRE
[pexpireat]: http://redis.io/commands/PEXPIREAT
[pexpiretime]: http://redis.io/commands/PEXPIRETIME
[pfadd]: http://redis.io/commands/PFADD
[pfcount]: http://redis.io/commands/PFCOUNT
[pfmerge]: http://redis.io/commands/PFMERGE
[ping]: http://redis.io/commands/PING
[psetex]: http://redis.io/commands/PSETEX
[psubscribe]: http://redis.io/commands/PSUBSCRIBE
[psync]: http://redis.io/commands/PSYNC
[pttl]: http://redis.io/commands/PTTL
[publish]: http://redis.io/commands/PUBLISH
[pubsub]: http://redis.io/commands/PUBSUB
[punsubscribe]: http://redis.io/commands/PUNSUBSCRIBE
[quit]: http://redis.io/commands/QUIT
[randomkey]: http://redis.io/commands/RANDOMKEY
[readonly]: http://redis.io/commands/READONLY
[readwrite]: http://redis.io/commands/READWRITE
[rename]: http://redis.io/commands/RENAME
[renamenx]: http://redis.io/commands/RENAMENX
[replconf]: http://redis.io/commands/REPLCONF
[replicaof]: http://redis.io/commands/REPLICAOF
[reset]: http://redis.io/commands/RESET
[role]: http://redis.io/commands/ROLE
[rpop]: http://redis.io/commands/RPOP
[rpoplpush]: http://redis.io/commands/RPOPLPUSH
[rpush]: http://redis.io/commands/RPUSH
[rpushx]: http://redis.io/commands/RPUSHX
[sadd]: http://redis.io/commands/SADD
[save]: http://redis.io/commands/SAVE
[scan]: http://redis.io/commands/SCAN
[scard]: http://redis.io/commands/SCARD
[script]: http://redis.io/commands/SCRIPT
[sdiff]: http://redis.io/commands/SDIFF
[sdiffstore]: http://redis.io/commands/SDIFFSTORE
[select]: http://redis.io/commands/SELECT
[set]: http://redis.io/commands/SET
[setbit]: http://redis.io/commands/SETBIT
[setex]: http://redis.io/commands/SETEX
[setnx]: http://redis.io/commands/SETNX
[setrange]: http://redis.io/commands/SETRANGE
[shutdown]: http://redis.io/commands/SHUTDOWN
[sinter]: http://redis.io/commands/SINTER
[sintercard]: http://redis.io/commands/SINTERCARD
[sinterstore]: http://redis.io/commands/SINTERSTORE
[sismember]: http://redis.io/commands/SISMEMBER
[slaveof]: http://redis.io/commands/SLAVEOF
[smembers]: http://redis.io/commands/SMEMBERS
[smismember]: http://redis.io/commands/SMISMEMBER
[smove]: http://redis.io/commands/SMOVE
[sort]: http://redis.io/commands/SORT
[sort_ro]: http://redis.io/commands/SORT_RO
[spop]: http://redis.io/commands/SPOP
[spublish]: http://redis.io/commands/SPUBLISH
[srandmember]: http://redis.io/commands/SRANDMEMBER
[srem]: http://redis.io/commands/SREM
[sscan]: http://redis.io/commands/SSCAN
[ssubscribe]: http://redis.io/commands/SSUBSCRIBE
[strlen]: http://redis.io/commands/STRLEN
[subscribe]: http://redis.io/commands/SUBSCRIBE
[substr]: http://redis.io/commands/SUBSTR
[sunion]: http://redis.io/commands/SUNION
[sunionstore]: http://redis.io/commands/SUNIONSTORE
[sunsubscribe]: http://redis.io/commands/SUNSUBSCRIBE
[swapdb]: http://redis.io/commands/SWAPDB
[sync]: http://redis.io/commands/SYNC
[time]: http://redis.io/commands/TIME
[touch]: http://redis.io/commands/TOUCH
[ttl]: http://redis.io/commands/TTL
[type]: http://redis.io/commands/TYPE
[unlink]: http://redis.io/commands/UNLINK
[unsubscribe]: http://redis.io/commands/UNSUBSCRIBE
[unwatch]: http://redis.io/commands/UNWATCH
[wait]: http://redis.io/commands/WAIT
[waitaof]: http://redis.io/commands/WAITAOF
[watch]: http://redis.io/commands/WATCH
[xack]: http://redis.io/commands/XACK
[xadd]: http://redis.io/commands/XADD
[xautoclaim]: http://redis.io/commands/XAUTOCLAIM
[xclaim]: http://redis.io/commands/XCLAIM
[xdel]: http://redis.io/commands/XDEL
[xgroup]: http://redis.io/commands/XGROUP
[xinfo]: http://redis.io/commands/XINFO
[xlen]: http://redis.io/commands/XLEN
[xpending]: http://redis.io/commands/XPENDING
[xrange]: http://redis.io/commands/XRANGE
[xread]: http://redis.io/commands/XREAD
[xreadgroup]: http://redis.io/commands/XREADGROUP
[xrevrange]: http://redis.io/commands/XREVRANGE
[xsetid]: http://redis.io/commands/XSETID
[xtrim]: http://redis.io/commands/XTRIM
[zadd]: http://redis.io/commands/ZADD
[zcard]: http://redis.io/commands/ZCARD
[zcount]: http://redis.io/commands/ZCOUNT
[zdiff]: http://redis.io/commands/ZDIFF
[zdiffstore]: http://redis.io/commands/ZDIFFSTORE
[zincrby]: http://redis.io/commands/ZINCRBY
[zinter]: http://redis.io/commands/ZINTER
[zintercard]: http://redis.io/commands/ZINTERCARD
[zinterstore]: http://redis.io/commands/ZINTERSTORE
[zlexcount]: http://redis.io/commands/ZLEXCOUNT
[zmpop]: http://redis.io/commands/ZMPOP
[zmscore]: http://redis.io/commands/ZMSCORE
[zpopmax]: http://redis.io/commands/ZPOPMAX
[zpopmin]: http://redis.io/commands/ZPOPMIN
[zrandmember]: http://redis.io/commands/ZRANDMEMBER
[zrange]: http://redis.io/commands/ZRANGE
[zrangebylex]: http://redis.io/commands/ZRANGEBYLEX
[zrangebyscore]: http://redis.io/commands/ZRANGEBYSCORE
[zrangestore]: http://redis.io/commands/ZRANGESTORE
[zrank]: http://redis.io/commands/ZRANK
[zrem]: http://redis.io/commands/ZREM
[zremrangebylex]: http://redis.io/commands/ZREMRANGEBYLEX
[zremrangebyrank]: http://redis.io/commands/ZREMRANGEBYRANK
[zremrangebyscore]: http://redis.io/commands/ZREMRANGEBYSCORE
[zrevrange]: http://redis.io/commands/ZREVRANGE
[zrevrangebylex]: http://redis.io/commands/ZREVRANGEBYLEX
[zrevrangebyscore]: http://redis.io/commands/ZREVRANGEBYSCORE
[zrevrank]: http://redis.io/commands/ZREVRANK
[zscan]: http://redis.io/commands/ZSCAN
[zscore]: http://redis.io/commands/ZSCORE
[zunion]: http://redis.io/commands/ZUNION
[zunionstore]: http://redis.io/commands/ZUNIONSTORE
[debug]: http://redis.io/commands/DEBUG
[dump]: http://redis.io/commands/DUMP
[hello]: http://redis.io/commands/HELLO
[latency]: http://redis.io/commands/LATENCY
[memory]: http://redis.io/commands/MEMORY
[migrate]: http://redis.io/commands/MIGRATE
[module]: http://redis.io/commands/MODULE
[pfdebug]: http://redis.io/commands/PFDEBUG
[restore]: http://redis.io/commands/RESTORE
[slowlog]: http://redis.io/commands/SLOWLOG
