//#region src/index.ts
const CONDITIONAL_EXP = "ConditionalExpression";
const plugin = {
	name: "ternary",
	init(jsep) {
		jsep.hooks.add("after-expression", function gobbleTernary(env) {
			if (env.node && this.code === jsep.QUMARK_CODE) {
				this.index++;
				const test = env.node;
				const consequent = this.gobbleExpression();
				if (!consequent) this.throwError("Expected expression");
				this.gobbleSpaces();
				if (this.code === jsep.COLON_CODE) {
					this.index++;
					const alternate = this.gobbleExpression();
					if (!alternate) this.throwError("Expected expression");
					env.node = {
						type: CONDITIONAL_EXP,
						test,
						consequent,
						alternate
					};
					const testNode = test;
					if (testNode.operator && jsep.binary_ops[testNode.operator] <= .9) {
						let newTest = testNode;
						while (newTest.right?.operator && jsep.binary_ops[newTest.right.operator] <= .9) newTest = newTest.right;
						env.node.test = newTest.right;
						newTest.right = env.node;
						env.node = test;
					}
				} else this.throwError("Expected :");
			}
		});
	}
};
var src_default = plugin;

//#endregion
export { src_default as default };
//# sourceMappingURL=index.js.map