import type { IPlugin, JsepInstance, Expression, HookEnv } from 'nc-jsep/types';

const CONDITIONAL_EXP = 'ConditionalExpression';

interface TernaryHookEnv extends HookEnv {
  node?: Expression & { operator?: string; right?: Expression };
}

const plugin: IPlugin = {
  name: 'ternary',

  init(jsep: JsepInstance) {
    // Ternary expression: test ? consequent : alternate
    jsep.hooks.add('after-expression', function gobbleTernary(this: JsepInstance, env: TernaryHookEnv) {
      if (env.node && this.code === jsep.QUMARK_CODE) {
        this.index++;
        const test = env.node;
        const consequent = this.gobbleExpression();

        if (!consequent) {
          this.throwError('Expected expression');
        }

        this.gobbleSpaces();

        if (this.code === jsep.COLON_CODE) {
          this.index++;
          const alternate = this.gobbleExpression();

          if (!alternate) {
            this.throwError('Expected expression');
          }
          env.node = {
            type: CONDITIONAL_EXP,
            test,
            consequent,
            alternate,
          };

          // check for operators of higher priority than ternary (i.e. assignment)
          // jsep sets || at 1, and assignment at 0.9, and conditional should be between them
          const testNode = test as Expression & { operator?: string; right?: Expression };
          if (testNode.operator && jsep.binary_ops[testNode.operator] <= 0.9) {
            let newTest = testNode;
            while (newTest.right?.operator && jsep.binary_ops[newTest.right.operator] <= 0.9) {
              newTest = newTest.right as Expression & { operator?: string; right?: Expression };
            }
            (env.node as Expression & { test: Expression }).test = newTest.right!;
            newTest.right = env.node;
            env.node = test;
          }
        }
        else {
          this.throwError('Expected :');
        }
      }
    });
  },
};

export default plugin;
