// Add default plugins:
import jsep from './jsep.js';
import ternary from 'nc-jsep-plugin-ternary';

// NOTE: jsep has historically included ternary support, which was later moved into a plugin
// to include ternary in the "defaultConfig()" method, it needs to be specially added to Jsep
jsep.registerTernary(ternary);

export const Jsep = jsep;
export default jsep;

// Re-export types
export type {
  Expression,
  ArrayExpression,
  BinaryExpression,
  CallExpression,
  Compound,
  SequenceExpression,
  ConditionalExpression,
  Identifier,
  Literal,
  MemberExpression,
  ThisExpression,
  UnaryExpression,
  ExpressionType,
  CoreExpression,
  PossibleExpression,
  HookType,
  HookCallback,
  HookEnv,
  IHooks,
  IPlugin,
  IPlugins,
  JsepInstance,
} from './types.js';
