import type { IPlugin, IPlugins, JsepInstance } from './types.js';

export default class Plugins implements IPlugins {
  jsep: JsepInstance;
  registered: Record<string, IPlugin>;

  constructor(jsep: JsepInstance) {
    this.jsep = jsep;
    this.registered = {};
  }

  /**
   * Adds the given plugin(s) to the registry
   *
   * @param plugins The plugins to register
   */
  register(...plugins: IPlugin[]): void {
    plugins.forEach((plugin) => {
      if (typeof plugin !== 'object' || !plugin.name || !plugin.init) {
        throw new Error('Invalid JSEP plugin format');
      }
      if (this.registered[plugin.name]) {
        // already registered. Ignore.
        return;
      }
      plugin.init(this.jsep);
      this.registered[plugin.name] = plugin;
    });
  }
}
