(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "./column", "./expr", "./util", "./over"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("./column"), require("./expr"), require("./util"), require("./over"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.column, global.expr, global.util, global.over);
    global.func = mod.exports;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function (_exports, _column, _expr, _util, _over) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.anyValueFuncToSQL = anyValueFuncToSQL;
  _exports.arrayDimensionToSymbol = arrayDimensionToSymbol;
  _exports.castToSQL = castToSQL;
  _exports.extractFunToSQL = extractFunToSQL;
  _exports.flattenFunToSQL = flattenFunToSQL;
  _exports.funcArgToSQL = funcArgToSQL;
  _exports.funcToSQL = funcToSQL;
  _exports.jsonObjectArgToSQL = jsonObjectArgToSQL;
  _exports.lambdaToSQL = lambdaToSQL;
  _exports.tablefuncFunToSQL = tablefuncFunToSQL;
  function anyValueFuncToSQL(stmt) {
    const {
      args,
      type,
      over
    } = stmt;
    const {
      expr,
      having
    } = args;
    let sql = `${(0, _util.toUpper)(type)}(${(0, _expr.exprToSQL)(expr)}`;
    if (having) sql = `${sql} HAVING ${(0, _util.toUpper)(having.prefix)} ${(0, _expr.exprToSQL)(having.expr)}`;
    sql = `${sql})`;
    const overStr = (0, _over.overToSQL)(over);
    return [sql, overStr].filter(_util.hasVal).join(' ');
  }
  function arrayDimensionToSymbol(target) {
    if (!target || !target.array) return '';
    const {
      keyword
    } = target.array;
    if (keyword) return (0, _util.toUpper)(keyword);
    const {
      dimension,
      length
    } = target.array;
    const result = [];
    for (let i = 0; i < dimension; i++) {
      result.push('[');
      if (length && length[i]) result.push((0, _util.literalToSQL)(length[i]));
      result.push(']');
    }
    return result.join('');
  }
  function castToSQL(expr) {
    const {
      target: targets,
      expr: expression,
      keyword,
      symbol,
      as: alias,
      offset,
      parentheses: outParentheses
    } = expr;
    let prefix = (0, _column.columnOffsetToSQL)({
      expr: expression,
      offset
    });
    const result = [];
    for (let i = 0, len = targets.length; i < len; ++i) {
      const target = targets[i];
      const {
        angle_brackets: angleBrackets,
        length,
        dataType,
        parentheses,
        quoted,
        scale,
        suffix: dataTypeSuffix,
        expr: targetExpr
      } = target;
      let str = targetExpr ? (0, _expr.exprToSQL)(targetExpr) : '';
      if (length != null) str = scale ? `${length}, ${scale}` : length;
      if (parentheses) str = `(${str})`;
      if (angleBrackets) str = `<${str}>`;
      if (dataTypeSuffix && dataTypeSuffix.length) str += ` ${dataTypeSuffix.map(_util.literalToSQL).join(' ')}`;
      let symbolChar = '::';
      let suffix = '';
      const targetResult = [];
      if (symbol === 'as') {
        if (i === 0) prefix = `${(0, _util.toUpper)(keyword)}(${prefix}`;
        suffix = ')';
        symbolChar = ` ${symbol.toUpperCase()} `;
      }
      if (i === 0) targetResult.push(prefix);
      const arrayDimension = arrayDimensionToSymbol(target);
      targetResult.push(symbolChar, quoted, dataType, quoted, arrayDimension, str, suffix);
      result.push(targetResult.filter(_util.hasVal).join(''));
    }
    if (alias) result.push(` AS ${(0, _util.identifierToSql)(alias)}`);
    const sql = result.filter(_util.hasVal).join('');
    return outParentheses ? `(${sql})` : sql;
  }
  function extractFunToSQL(stmt) {
    const {
      args,
      type
    } = stmt;
    const {
      field,
      cast_type: castType,
      source
    } = args;
    const result = [`${(0, _util.toUpper)(type)}(${(0, _util.toUpper)(field)}`, 'FROM', (0, _util.toUpper)(castType), (0, _expr.exprToSQL)(source)];
    return `${result.filter(_util.hasVal).join(' ')})`;
  }
  function flattenArgToSQL(arg) {
    if (!arg) return '';
    const {
      type,
      symbol,
      value
    } = arg;
    const result = [(0, _util.toUpper)(type), symbol, (0, _expr.exprToSQL)(value)];
    return result.filter(_util.hasVal).join(' ');
  }
  function jsonObjectArgToSQL(argExpr) {
    const {
      expr
    } = argExpr;
    const {
      key,
      value,
      on
    } = expr;
    const result = [(0, _expr.exprToSQL)(key), 'VALUE', (0, _expr.exprToSQL)(value)];
    if (on) result.push('ON', 'NULL', (0, _expr.exprToSQL)(on));
    return result.filter(_util.hasVal).join(' ');
  }
  function flattenFunToSQL(stmt) {
    const {
      args,
      type
    } = stmt;
    const keys = ['input', 'path', 'outer', 'recursive', 'mode'];
    const argsStr = keys.map(key => flattenArgToSQL(args[key])).filter(_util.hasVal).join(', ');
    return `${(0, _util.toUpper)(type)}(${argsStr})`;
  }
  function funcArgToSQL(argExpr) {
    const {
      name,
      symbol,
      expr
    } = argExpr.value;
    return [name, symbol, (0, _expr.exprToSQL)(expr)].filter(_util.hasVal).join(' ');
  }
  function withinGroupToSQL(stmt) {
    if (!stmt) return '';
    const {
      type,
      keyword,
      orderby
    } = stmt;
    return [(0, _util.toUpper)(type), (0, _util.toUpper)(keyword), `(${(0, _expr.orderOrPartitionByToSQL)(orderby, 'order by')})`].filter(_util.hasVal).join(' ');
  }
  function funcToSQL(expr) {
    const {
      args,
      array_index,
      name,
      args_parentheses,
      parentheses,
      within_group: withinGroup,
      over,
      suffix
    } = expr;
    const overStr = (0, _over.overToSQL)(over);
    const withinGroupStr = withinGroupToSQL(withinGroup);
    const suffixStr = (0, _expr.exprToSQL)(suffix);
    const funcName = [(0, _util.literalToSQL)(name.schema), name.name.map(_util.literalToSQL).join('.')].filter(_util.hasVal).join('.');
    if (!args) return [funcName, withinGroupStr, overStr].filter(_util.hasVal).join(' ');
    let separator = expr.separator || ', ';
    if ((0, _util.toUpper)(funcName) === 'TRIM') separator = ' ';
    let str = [funcName];
    str.push(args_parentheses === false ? ' ' : '(');
    const argsList = (0, _expr.exprToSQL)(args);
    if (Array.isArray(separator)) {
      let argsSQL = argsList[0];
      for (let i = 1, len = argsList.length; i < len; ++i) {
        argsSQL = [argsSQL, argsList[i]].join(` ${(0, _expr.exprToSQL)(separator[i - 1])} `);
      }
      str.push(argsSQL);
    } else {
      str.push(argsList.join(separator));
    }
    if (args_parentheses !== false) str.push(')');
    str.push((0, _column.arrayIndexToSQL)(array_index));
    str = [str.join(''), suffixStr].filter(_util.hasVal).join(' ');
    return [parentheses ? `(${str})` : str, withinGroupStr, overStr].filter(_util.hasVal).join(' ');
  }
  function tablefuncFunToSQL(expr) {
    const {
      as,
      name,
      args
    } = expr;
    const funcName = [(0, _util.literalToSQL)(name.schema), name.name.map(_util.literalToSQL).join('.')].filter(_util.hasVal).join('.');
    const result = [`${funcName}(${(0, _expr.exprToSQL)(args).join(', ')})`, 'AS', funcToSQL(as)];
    return result.join(' ');
  }
  function lambdaToSQL(stmt) {
    const {
      args,
      expr
    } = stmt;
    const {
      value,
      parentheses
    } = args;
    const argsList = value.map(_expr.exprToSQL).join(', ');
    return [parentheses ? `(${argsList})` : argsList, '->', (0, _expr.exprToSQL)(expr)].join(' ');
  }
});