"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// pkg/dist-src/index.js
var index_exports = {};
__export(index_exports, {
  App: () => App,
  OAuthApp: () => OAuthApp,
  Octokit: () => Octokit,
  RequestError: () => import_request_error.RequestError,
  createNodeMiddleware: () => import_app2.createNodeMiddleware
});
module.exports = __toCommonJS(index_exports);

// pkg/dist-src/octokit.js
var import_core = require("@octokit/core");
var import_plugin_paginate_rest = require("@octokit/plugin-paginate-rest");
var import_plugin_paginate_graphql = require("@octokit/plugin-paginate-graphql");
var import_plugin_rest_endpoint_methods = require("@octokit/plugin-rest-endpoint-methods");
var import_plugin_retry = require("@octokit/plugin-retry");
var import_plugin_throttling = require("@octokit/plugin-throttling");

// pkg/dist-src/version.js
var VERSION = "3.2.2";

// pkg/dist-src/octokit.js
var import_request_error = require("@octokit/request-error");
var Octokit = import_core.Octokit.plugin(
  import_plugin_rest_endpoint_methods.restEndpointMethods,
  import_plugin_paginate_rest.paginateRest,
  import_plugin_paginate_graphql.paginateGraphql,
  import_plugin_retry.retry,
  import_plugin_throttling.throttling
).defaults({
  userAgent: `octokit.js/${VERSION}`,
  throttle: {
    // @ts-expect-error There are type errors due to updated dependencies
    onRateLimit,
    // @ts-expect-error There are type errors due to updated dependencies
    onSecondaryRateLimit
  }
});
function onRateLimit(retryAfter, options, octokit) {
  octokit.log.warn(
    `Request quota exhausted for request ${options.method} ${options.url}`
  );
  if (options.request.retryCount === 0) {
    octokit.log.info(`Retrying after ${retryAfter} seconds!`);
    return true;
  }
}
function onSecondaryRateLimit(retryAfter, options, octokit) {
  octokit.log.warn(
    `SecondaryRateLimit detected for request ${options.method} ${options.url}`
  );
  if (options.request.retryCount === 0) {
    octokit.log.info(`Retrying after ${retryAfter} seconds!`);
    return true;
  }
}

// pkg/dist-src/app.js
var import_app = require("@octokit/app");
var import_oauth_app = require("@octokit/oauth-app");
var import_app2 = require("@octokit/app");
var App = import_app.App.defaults({ Octokit });
var OAuthApp = import_oauth_app.OAuthApp.defaults({ Octokit });
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  App,
  OAuthApp,
  Octokit,
  RequestError,
  createNodeMiddleware
});
