import { App as DefaultApp } from "@octokit/app";
import { OAuthApp as DefaultOAuthApp } from "@octokit/oauth-app";
export declare const App: (new (...args: any[]) => {
    octokit: import("@octokit/core").Octokit & {
        paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
    } & {
        graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
            paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                    [Symbol.asyncIterator]: () => {
                        next(): Promise<{
                            done: boolean;
                            value: ResponseType_2;
                        }>;
                    };
                };
            };
        };
    } & import("@octokit/plugin-rest-endpoint-methods").Api & {
        retry: {
            retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
        };
    };
    webhooks: import("@octokit/webhooks").Webhooks<{
        octokit: import("@octokit/core").Octokit & {
            paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
        } & {
            graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
                paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                    iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                        [Symbol.asyncIterator]: () => {
                            next(): Promise<{
                                done: boolean;
                                value: ResponseType_2;
                            }>;
                        };
                    };
                };
            };
        } & import("@octokit/plugin-rest-endpoint-methods").Api & {
            retry: {
                retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
            };
        };
    }>;
    oauth: DefaultOAuthApp<{
        clientType: "github-app";
        Octokit: typeof import("@octokit/core").Octokit & import("@octokit/core/dist-types/types.d").Constructor<{
            paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
        } & {
            graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
                paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                    iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                        [Symbol.asyncIterator]: () => {
                            next(): Promise<{
                                done: boolean;
                                value: ResponseType_2;
                            }>;
                        };
                    };
                };
            };
        } & import("@octokit/plugin-rest-endpoint-methods").Api & {
            retry: {
                retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
            };
        }>;
    }>;
    getInstallationOctokit: import("@octokit/app/dist-types/types.js").GetInstallationOctokitInterface<import("@octokit/core").Octokit & {
        paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
    } & {
        graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
            paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                    [Symbol.asyncIterator]: () => {
                        next(): Promise<{
                            done: boolean;
                            value: ResponseType_2;
                        }>;
                    };
                };
            };
        };
    } & import("@octokit/plugin-rest-endpoint-methods").Api & {
        retry: {
            retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
        };
    }>;
    eachInstallation: import("@octokit/app/dist-types/types.js").EachInstallationInterface<import("@octokit/core").Octokit & {
        paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
    } & {
        graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
            paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                    [Symbol.asyncIterator]: () => {
                        next(): Promise<{
                            done: boolean;
                            value: ResponseType_2;
                        }>;
                    };
                };
            };
        };
    } & import("@octokit/plugin-rest-endpoint-methods").Api & {
        retry: {
            retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
        };
    }>;
    eachRepository: import("@octokit/app/dist-types/types.js").EachRepositoryInterface<import("@octokit/core").Octokit & {
        paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
    } & {
        graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
            paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                    [Symbol.asyncIterator]: () => {
                        next(): Promise<{
                            done: boolean;
                            value: ResponseType_2;
                        }>;
                    };
                };
            };
        };
    } & import("@octokit/plugin-rest-endpoint-methods").Api & {
        retry: {
            retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
        };
    }>;
    log: {
        [key: string]: unknown;
        debug: (message: string, additionalInfo?: object | undefined) => void;
        info: (message: string, additionalInfo?: object | undefined) => void;
        warn: (message: string, additionalInfo?: object | undefined) => void;
        error: (message: string, additionalInfo?: object | undefined) => void;
    };
}) & typeof DefaultApp;
export type App = InstanceType<typeof App>;
export declare const OAuthApp: (new (...args: any[]) => {
    type: "oauth-app";
    on: import("@octokit/oauth-app/dist-types/types.js").AddEventHandler<{
        Octokit: typeof import("@octokit/core").Octokit & import("@octokit/core/dist-types/types.d").Constructor<{
            paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
        } & {
            graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
                paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                    iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                        [Symbol.asyncIterator]: () => {
                            next(): Promise<{
                                done: boolean;
                                value: ResponseType_2;
                            }>;
                        };
                    };
                };
            };
        } & import("@octokit/plugin-rest-endpoint-methods").Api & {
            retry: {
                retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
            };
        }>;
    }>;
    octokit: import("@octokit/core").Octokit & {
        paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
    } & {
        graphql: import("@octokit/graphql/dist-types/types.js").graphql & {
            paginate: (<ResponseType_1 extends object = any>(query: string, initialParameters?: Record<string, any>) => Promise<ResponseType_1>) & {
                iterator: <ResponseType_2 = any>(query: string, initialParameters?: Record<string, any>) => {
                    [Symbol.asyncIterator]: () => {
                        next(): Promise<{
                            done: boolean;
                            value: ResponseType_2;
                        }>;
                    };
                };
            };
        };
    } & import("@octokit/plugin-rest-endpoint-methods").Api & {
        retry: {
            retryRequest: (error: import("@octokit/request-error").RequestError, retries: number, retryAfter: number) => import("@octokit/request-error").RequestError;
        };
    };
    getUserOctokit: import("@octokit/oauth-app/dist-types/methods/get-user-octokit.js").GetUserOctokitWithStateInterface<"oauth-app">;
    getWebFlowAuthorizationUrl: import("@octokit/oauth-app/dist-types/methods/get-web-flow-authorization-url.js").GetWebFlowAuthorizationUrlInterface<"oauth-app">;
    createToken: import("@octokit/oauth-app/dist-types/methods/create-token.js").CreateTokenInterface<"oauth-app">;
    checkToken: import("@octokit/oauth-app/dist-types/methods/check-token.js").CheckTokenInterface<"oauth-app">;
    resetToken: import("@octokit/oauth-app/dist-types/methods/reset-token.js").ResetTokenInterface<"oauth-app">;
    refreshToken: import("@octokit/oauth-app/dist-types/methods/refresh-token.js").RefreshTokenInterface;
    scopeToken: import("@octokit/oauth-app/dist-types/methods/scope-token.js").ScopeTokenInterface;
    deleteToken: import("@octokit/oauth-app/dist-types/methods/delete-token.js").DeleteTokenInterface;
    deleteAuthorization: import("@octokit/oauth-app/dist-types/methods/delete-authorization.js").DeleteAuthorizationInterface;
}) & typeof DefaultOAuthApp;
export type OAuthApp = InstanceType<typeof OAuthApp>;
export { createNodeMiddleware } from "@octokit/app";
