import type { TcpNetConnectOpts } from "node:net";
import * as http from "node:http";
import * as https from "node:https";
import type { Duplex } from "node:stream";
export interface RequestFilteringAgentOptions {
    allowPrivateIPAddress?: boolean;
    allowMetaIPAddress?: boolean;
    allowIPAddressList?: string[];
    denyIPAddressList?: string[];
}
export declare const DefaultRequestFilteringAgentOptions: Required<RequestFilteringAgentOptions>;
/**
 * A subclass of http.Agent with request filtering
 */
export declare class RequestFilteringHttpAgent extends http.Agent {
    private requestFilterOptions;
    constructor(options?: http.AgentOptions & RequestFilteringAgentOptions);
    createConnection(options: TcpNetConnectOpts, connectionListener?: (error: Error | null, socket: Duplex) => void): Duplex;
}
/**
 * A subclass of https.Agent with request filtering
 */
export declare class RequestFilteringHttpsAgent extends https.Agent {
    private requestFilterOptions;
    constructor(options?: https.AgentOptions & RequestFilteringAgentOptions);
    createConnection(options: TcpNetConnectOpts, connectionListener?: (error: Error | null, socket: Duplex) => void): Duplex;
}
export declare const globalHttpAgent: RequestFilteringHttpAgent;
export declare const globalHttpsAgent: RequestFilteringHttpsAgent;
/**
 * Get an agent for the url
 * return http or https agent
 * @param url
 * @param options
 */
export declare const useAgent: (url: string, options?: https.AgentOptions & RequestFilteringAgentOptions) => RequestFilteringHttpAgent | RequestFilteringHttpsAgent;
