"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createResumableStreamContext = exports.resumeStream = void 0;
const runtime_1 = require("./runtime");
__exportStar(require("./types"), exports);
var runtime_2 = require("./runtime");
Object.defineProperty(exports, "resumeStream", { enumerable: true, get: function () { return runtime_2.resumeStream; } });
/**
 * Creates a global context for resumable streams from which you can create resumable streams.
 *
 * This generic version requires you to provide your own Publisher and Subscriber implementations,
 * making it compatible with any Redis-like client (Upstash Redis, Valkey, etc.).
 *
 * @param options - The context options.
 * @param options.keyPrefix - The prefix for the keys used by the resumable streams. Defaults to `resumable-stream`.
 * @param options.waitUntil - A function that takes a promise and ensures that the current program stays alive until the promise is resolved.
 * @param options.subscriber - A pubsub subscriber implementing the Subscriber interface. **Required**.
 * @param options.publisher - A pubsub publisher implementing the Publisher interface. **Required**.
 * @returns A resumable stream context.
 */
exports.createResumableStreamContext = (0, runtime_1.createResumableStreamContextFactory)({
    publisher: () => {
        throw new Error("Generic mode requires a publisher to be provided. Please pass a publisher option to createResumableStreamContext.");
    },
    subscriber: () => {
        throw new Error("Generic mode requires a subscriber to be provided. Please pass a subscriber option to createResumableStreamContext.");
    },
});
//# sourceMappingURL=generic.js.map