export function buildCertId(cert: any): any;
export function decode(cert: any): {
    cert: any;
    issuer: any;
};
/**
 * Encode certID to a cache key
 * @param base64Key {Object}
 * @return cache key {string}
 */
export function encodeKey(base64Key: Object): string;
/**
 * Encode certID to a cache key
 * @param cacheKey {Object}
 */
export function decodeKey(cacheKey: Object): any;
/**
 * Checks the validity
 * @param currentTime current time
 * @param thisUpdate last update
 * @param nextUpdate next update
 * @return {boolean}
 */
export function isValidityRange(currentTime: any, thisUpdate: any, nextUpdate: any): boolean;
/**
 * Verify OCSP response. If issuer is not specified, the signature will not be
 * verified.
 * @param issuer issuer certificate
 * @param rawRes OCSP Response
 * @returns {{success, error, revoked}|{res, success, error}}
 */
export function verifyOCSPResponse(issuer: any, rawRes: any): {
    success: any;
    error: any;
    revoked: any;
} | {
    res: any;
    success: any;
    error: any;
};
