import ASN1 from 'asn1.js-rfc5280';
export declare const CRL_MEMORY_CACHE: Map<string, {
    expireAt: number;
    crl: ASN1.CertificateListDecoded;
}>;
export declare function getCrlFromMemory(url: string): ASN1.CertificateListDecoded | null;
export declare function setCrlInMemory(url: string, crl: ASN1.CertificateListDecoded): void;
export declare function clearExpiredCrlFromMemoryCache(): void;
export declare function clearExpiredCrlFromDiskCache(): Promise<void>;
export declare function getCrlFromDisk(url: string): Promise<ASN1.CertificateListDecoded | null>;
export declare function writeCrlToDisk(url: string, rawCrl: Buffer): Promise<void>;
