import { DetailedPeerCertificate } from 'tls';
import ASN1 from 'asn1.js-rfc5280';
export declare const CRL_SIGNATURE_OID_TO_CRYPTO_DIGEST_ALGORITHM: Record<string, string>;
export declare function getCertificateDebugName(certificate: DetailedPeerCertificate): string;
export declare const getCertificateCrlUrls: (certificateName: string, decodedCertificate: ASN1.CertificateDecoded) => [string, ...string[]] | null;
/**
 * See Short-lived Subscriber Certificate section\
 * https://cabforum.org/working-groups/server/baseline-requirements/requirements/
 */
export declare function isShortLivedCertificate(decodedCertificate: ASN1.CertificateDecoded): boolean;
export declare function isCrlSignatureValid(crl: ASN1.CertificateListDecoded, issuerPublicKey: string): boolean;
export declare function isCertificateRevoked(decodedCertificate: ASN1.CertificateDecoded, crl: ASN1.CertificateListDecoded): boolean;
export declare function isIssuingDistributionPointExtensionValid(crl: ASN1.CertificateListDecoded, expectedCrlUrl: string): boolean;
