import { DetailedPeerCertificate, TLSSocket } from 'tls';
export declare const CRL_VALIDATOR_INTERNAL: {
    validateCrl: (certChain: DetailedPeerCertificate, config: CRLValidatorConfig) => Promise<boolean>;
};
export type CRLValidatorConfig = {
    checkMode: 'DISABLED' | 'ENABLED' | 'ADVISORY';
    allowCertificatesWithoutCrlURL: boolean;
    inMemoryCache: boolean;
    onDiskCache: boolean;
};
export declare class CertificateRevokedError extends Error {
    constructor(message: string);
}
export declare function isCrlValidationEnabled(config: CRLValidatorConfig): boolean;
export declare function corkSocketAndValidateCrl(socket: TLSSocket, config: CRLValidatorConfig): void;
export declare function validateCrl(certChain: DetailedPeerCertificate, config: CRLValidatorConfig): Promise<boolean>;
