export function deleteCache(): void;
/**
 * Cache for storing OCSP responses. This covers both client and server caches.
 *
 * @constructor
 */
export function OcspResponseCache(): void;
export class OcspResponseCache {
    /**
     * set proxy agent for ocsp validation
     *
     * @param agent
     */
    setAgent: (agent: any) => void;
    /**
     * Initializes the cache
     *
     * @param cert
     * @param response
     */
    initCache: (cert: any, response: any) => void;
    /**
     * Is OCSP Cache initialized?
     * @returns {boolean}
     */
    isInitialized: () => boolean;
    /**
     * Is OCSP Cache download finished?
     * @returns {boolean}
     */
    isDownloadFinished: () => boolean;
    /**
     * Forces download status to finish
     */
    forceDownloadToFinish: () => void;
    /**
     * Is local OCSP Cache expired?
     * @returns {boolean}
     */
    IsCacheExpired: () => boolean;
    /**
     * Resets OCSP Cache status
     */
    resetCacheStatus: () => void;
    /**
     * Adds an entry to the cache.
     *
     * @param cert
     * @param response
     */
    set: (cert: any, response: any) => void;
    /**
     * Returns an entry from the cache.
     *
     * @param cert
     * @returns {*}
     */
    get: (cert: any) => any;
    /**
     * Downloads OCSP cache from the Snowflake OCSP cache server.
     * @param cb callback
     */
    downloadCache: (cb: any) => boolean;
}
