/**
 * Create server to retrieve SAML token.
 *
 * @param {Function} resolve
 * @param {Function} reject
 *
 * @returns {Server}
 */
export function createServer(resolve: Function, reject: Function): Server;
export function withBrowserActionTimeout(millis: any, promise: any): Promise<any>;
export function getTokenUrl(options: any): import("url").URL;
export function prepareScope(options: any): Promise<any>;
export function readCache(key: any): Promise<any>;
export function writeToCache(key: any, value: any): Promise<any>;
export function removeFromCache(key: any): Promise<any>;
export function buildOauthAccessTokenCacheKey(host: any, username: any, authenticationType: any): string | null;
export function buildOauthRefreshTokenCacheKey(host: any, username: any, authenticationType: any): string | null;
export function isSnowflakeHost(url: any): boolean;
