export const mapErrorCodeToSqlState: {
    405501: string;
    405502: string;
    405503: string;
    407001: string;
    407002: string;
};
export function assertInternal(expression: boolean, message?: string): void;
export function checkArgumentExists(expression: boolean, errorCode: number, ...args: any[]): void;
export function checkArgumentValid(expression: boolean, errorCode: number, ...args: any[]): void;
export function createInvalidParameterError(errorCode: number, ...messageArgs: any[]): Error;
export function createNetworkError(errorCode: number, cause: Error): Error;
export function createRequestFailedError(errorCode: number, response: Object): Error;
export function createUnexpectedContentError(errorCode: number, responseBody: string): Error;
export function createOperationFailedError(errorCode: number, data: Object, message: string, sqlState: string): Error;
export function createLargeResultSetError(errorCode: number, response: Object): Error;
export function createClientError(errorCode: number, isFatal?: Object, ...args: any[]): Error;
export function createOCSPError(errorCode: number, ...args: any[]): Error;
export function createCrlError(originalError: Error): Error;
export function VariantParseError(jsonParseError: Object, xmlParseError: Object): Error;
export function isInternalAssertError(error: Error): boolean;
export function isMissingParameterError(error: Error): boolean;
export function isInvalidParameterError(error: Error): boolean;
export function isNetworkError(error: Error): boolean;
export function isRequestFailedError(error: Error): boolean;
export function isUnexpectedContentError(error: Error): boolean;
export function isOperationFailedError(error: Error): boolean;
export function isLargeResultSetError(error: Error): boolean;
export function externalize(error: Error): Error;
import ErrorCode_1 = require("./error_code");
import ErrorCode = ErrorCode_1.default;
export { ErrorCode as codes, ErrorCode };
