export interface GlobalConfigOptionsTyped {
    /**
     * HTTP request timeout for CRL download.
     *
     * @default 10000 (ms)
     */
    crlDownloadTimeout: number;
    /**
     * Time after which cached CRL entries are invalidated.
     *
     * @default 86400000 (24 hours in ms)
     */
    crlCacheValidityTime: number;
    /**
     * Directory path to store CRL cache when crlOnDiskCache is true.
     *
     * @default
     * Reads from process.env.SNOWFLAKE_CRL_ON_DISK_CACHE_DIR if available.
     * Otherwise, defaults to:
     * - Windows: %USERPROFILE%/AppData/Local/Snowflake/Caches/crls
     * - Linux: $HOME/.cache/snowflake/crls
     * - macOS: $HOME/Library/Caches/Snowflake/crls
     */
    crlCacheDir: string;
}
export declare const GLOBAL_CONFIG_DEFAULTS: GlobalConfigOptionsTyped;
export declare const globalConfigCustomValues: Partial<GlobalConfigOptionsTyped>;
declare const _default: {
    setValues: (options: Partial<GlobalConfigOptionsTyped>) => void;
    getValue: <K extends keyof GlobalConfigOptionsTyped>(key: K) => GlobalConfigOptionsTyped[K];
};
export default _default;
