export = HttpClient;
/**
 * Creates a new HTTP client.
 *
 * @param connectionConfig
 * @constructor
 */
declare function HttpClient(connectionConfig: any): void;
declare class HttpClient {
    /**
     * Creates a new HTTP client.
     *
     * @param connectionConfig
     * @constructor
     */
    constructor(connectionConfig: any);
    _connectionConfig: any;
    /**
     * Issues an HTTP request.
     *
     * @param {Object} options
     *
     * @returns {Object} an object representing the request that was issued.
     */
    request(options: Object): Object;
    /**
     * Issues an HTTP request.
     *
     * @param {Object} options
     *
     * @returns {Object} an object representing the request that was issued.
     */
    requestAsync(options: Object): Object;
    /**
     * Issues an HTTP POST request.
     *
     * @param {String} url
     * @param {String} body
     * @param {Object} options
     *
     * @returns {Object} an object representing the request that was issued.
     */
    post(url: string, body: string, options: Object): Object;
    /**
     * Issues an HTTP GET request.
     *
     * @param {String} url
     * @param {Object} params
     *
     * @returns {Object} an object representing the request that was issued.
     */
    get(url: string, params: Object): Object;
    /**
     * Issues an HTTP HEAD request.
     *
     * @param {String} url
     * @param {Object} config
     *
     * @returns {Object} an object representing the request that was issued.
     */
    head(url: string, config: Object): Object;
    /**
     * Issues an HTTP PUT request.
     *
     * @param {String} url
     * @param {Object} data
     * @param {Object} config
     *
     * @returns {Object} an object representing the request that was issued.
     */
    put(url: string, data: Object, config: Object): Object;
    /**
     * @abstract
     * Returns the module to use when making HTTP requests. Subclasses must override
     * and provide their own implementations.
     *
     * @returns {*}
     */
    getRequestModule(): any;
    /**
     * Returns the agent and proxy options.
     *
     * @returns {*}
     */
    getAgent(): any;
}
