/**
 * Creates a client that can be used to make requests in Node.js.
 *
 * @param {ConnectionConfig} connectionConfig
 * @constructor
 */
export function NodeHttpClient(connectionConfig: ConnectionConfig): void;
export class NodeHttpClient {
    /**
     * Creates a client that can be used to make requests in Node.js.
     *
     * @param {ConnectionConfig} connectionConfig
     * @constructor
     */
    constructor(connectionConfig: ConnectionConfig);
    /**
     * Returns the delay time calculated by exponential backoff with
     * decorrelated jitter. For more details, check out:
     * http://www.awsarchitectureblog.com/2015/03/backoff.html
     * @return  {Number} number of milliseconds to wait before retrying again the request.
     */
    constructExponentialBackoffStrategy(): number;
    /**
     * @inheritDoc
     */
    getAgent(parsedUrl: any, proxy: any, mock: any): any;
}
export function getProxyAgent(proxyOptions: any, parsedUrl: any, destination: any, mock: any, connectionConfig: any): any;
export function isBypassProxy(proxy: any, destination: any, agentId: any): boolean;
export const httpsAgentCache: Map<any, any>;
