export const DEFAULT_ATTRIBUTES_DESCRIBING_REQUEST_WITH_VALUES: string[];
export const DEFAULT_ATTRIBUTES_DESCRIBING_REQUEST_WITHOUT_VALUES: "token"[];
/**
 * Describes a request based on its options.
 * Should work with not-yet-parsed options as well (before calling prepareRequestOptions method).
 *
 * @param {Object} requestOptions - Object representing the request data with top-level keys.
 * @param {Object} [options] - Options for describing attributes.
 * @param {Array<string>} [options.overrideAttributesDescribedWithValues]
 * @param {Array<string>} [options.overrideAttributesDescribedWithoutValues]
 * @returns {string} A string representation of the request data.
 */
export function describeRequestFromOptions(requestOptions: Object, { overrideAttributesDescribedWithValues, overrideAttributesDescribedWithoutValues }?: {
    overrideAttributesDescribedWithValues?: string[] | undefined;
    overrideAttributesDescribedWithoutValues?: string[] | undefined;
}): string;
/**
 * Creates a string that represents request data from a response.
 * Helps to identify the request that was the source of the response.
 *
 * @param {Object} response - Axios response object.
 * @param {Object} [options] - Options for describing attributes.
 * @param {Array<string>} [options.overrideAttributesDescribedWithValues]
 * @param {Array<string>} [options.overrideAttributesDescribedWithoutValues]
 * @returns {string} A string representation of the request data.
 */
export function describeRequestFromResponse(response: Object, { overrideAttributesDescribedWithValues, overrideAttributesDescribedWithoutValues }?: {
    overrideAttributesDescribedWithValues?: string[] | undefined;
    overrideAttributesDescribedWithoutValues?: string[] | undefined;
}): string;
/**
 * @param {string} url - The URL to describe.
 * @param {Object} [options] - Options for describing attributes.
 * @param {Array<string>} [options.overrideAttributesDescribedWithValues]
 * @param {Array<string>} [options.overrideAttributesDescribedWithoutValues]
 * @returns {string} A string describing the URL.
 */
export function describeURL(url: string, { overrideAttributesDescribedWithValues, overrideAttributesDescribedWithoutValues }?: {
    overrideAttributesDescribedWithValues?: string[] | undefined;
    overrideAttributesDescribedWithoutValues?: string[] | undefined;
}): string;
