export = Logger;
/**
 * Creates a new Logger instance for when we're running in the browser.
 *
 * @param {Object} [options]
 *
 * @constructor
 */
declare function Logger(options?: Object): void;
declare class Logger {
    /**
     * Creates a new Logger instance for when we're running in the browser.
     *
     * @param {Object} [options]
     *
     * @constructor
     */
    constructor(options?: Object);
    /**
     * Configures this logger.
     *
     * @param {Object} options
     */
    configure: (options: Object) => void;
    /**
     * Returns the current log level.
     *
     * @returns {Number}
     */
    getLevel: () => number;
    /**
     * Logs a given message at the error level.
     *
     * @param {String} message
     * @param params
     */
    error: (message: string, ...params: any[]) => void;
    /**
     * Logs a given message at the warning level.
     *
     * @param {String} message
     * @param params
     */
    warn: (message: string, ...params: any[]) => void;
    /**
     * Logs a given message at the info level.
     *
     * @param {String} message
     * @param params
     */
    info: (message: string, ...params: any[]) => void;
    /**
     * Logs a given message at the debug level.
     *
     * @param {String} message
     * @param params
     */
    debug: (message: string, ...params: any[]) => void;
    /**
     * Logs a given message at the trace level.
     *
     * @param {String} message
     * @param params
     */
    trace: (message: string, ...params: any[]) => void;
    /**
     * Returns the log buffer.
     *
     * @returns {String[]}
     */
    getLogBuffer: () => string[];
}
