"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isMusl = isMusl;
const node_fs_1 = require("node:fs");
const node_child_process_1 = require("node:child_process");
// NOTE:
// Musl detection is copy-pasted from napi-rs binding file generator
function isMusl() {
    let musl = false;
    if (process.platform === 'linux') {
        let fsResult = isMuslFromFilesystem();
        if (fsResult === null) {
            fsResult = isMuslFromReport();
        }
        if (fsResult === null) {
            musl = isMuslFromChildProcess();
        }
        else {
            musl = fsResult;
        }
    }
    return musl;
}
function isFileMusl(filePath) {
    return filePath.includes('libc.musl-') || filePath.includes('ld-musl-');
}
function isMuslFromFilesystem() {
    try {
        return (0, node_fs_1.readFileSync)('/usr/bin/ldd', 'utf-8').includes('musl');
    }
    catch {
        return null;
    }
}
function isMuslFromReport() {
    let report = null;
    const processReport = process.report;
    if (typeof processReport?.getReport === 'function') {
        // Avoid collecting network info while generating report
        processReport.excludeNetwork = true;
        report = processReport.getReport();
    }
    if (!report) {
        return null;
    }
    if (report.header && report.header.glibcVersionRuntime) {
        return false;
    }
    if (Array.isArray(report.sharedObjects)) {
        if (report.sharedObjects.some(isFileMusl)) {
            return true;
        }
    }
    return false;
}
function isMuslFromChildProcess() {
    try {
        return (0, node_child_process_1.execSync)('ldd --version', { encoding: 'utf8' }).includes('musl');
    }
    catch {
        // Unknown if the system is musl; default to false
        return false;
    }
}
//# sourceMappingURL=is_musl.js.map