"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.minicoreStatus = void 0;
exports.getBinaryName = getBinaryName;
exports.getMinicoreStatus = getMinicoreStatus;
const logger_1 = __importDefault(require("../logger"));
const is_musl_1 = require("./is_musl");
exports.minicoreStatus = {
    version: null,
    binaryName: null,
    error: null,
};
let logDebugMinicoreError = null;
if (process.env.SNOWFLAKE_DISABLE_MINICORE) {
    exports.minicoreStatus.error = 'Minicore is disabled with SNOWFLAKE_DISABLE_MINICORE env variable';
}
else {
    try {
        exports.minicoreStatus.binaryName = getBinaryName();
        const minicoreModule = require(`./binaries/${exports.minicoreStatus.binaryName}`);
        exports.minicoreStatus.version = minicoreModule.sfCoreFullVersion();
    }
    catch (error) {
        // NOTE:
        // minicoreStatus is pushed to telemetry, so we don't want the original error there as it might
        // contain sensitive information
        logDebugMinicoreError = error;
        exports.minicoreStatus.error = 'Failed to load binary';
    }
}
// NOTE:
// Custom loader instead of napi-rs autogenerated binding file because:
// - napi-rs tries to require(process.env.NAPI_RS_NATIVE_LIBRARY_PATH) which might be a security risk
// - napi-rs tries to require('packageName-platform-arch') which we don't publish yet
function getBinaryName() {
    const { platform, arch } = process;
    const suffix = [platform, arch];
    if (platform === 'linux') {
        suffix.push((0, is_musl_1.isMusl)() ? 'musl' : 'gnu');
    }
    else if (platform === 'win32') {
        suffix.push('msvc');
    }
    return `sf_mini_core_0.0.1.${suffix.join('-')}.node`;
}
function getMinicoreStatus() {
    // NOTE:
    // At the time of minicore loading, the logger isn't initialized, so we hold the error until
    // the first getMinicoreStatus() call
    if (logDebugMinicoreError) {
        (0, logger_1.default)().debug('Error loading minicore: %s', logDebugMinicoreError);
        logDebugMinicoreError = null;
    }
    return exports.minicoreStatus;
}
//# sourceMappingURL=minicore.js.map