export function removeScheme(input: any): string;
export function getCompareAndLogEnvAndAgentProxies(agentOptions: Proxy): {
    messages: string;
    warnings: string;
};
export function validateProxy(proxy: Proxy): Proxy;
export function getProxyFromEnv(isHttps?: boolean): Proxy;
export function getNoProxyEnv(): string | undefined;
export function getHostFromURL(destination: string): string;
export function getProxy(proxy: Proxy, moduleName: string, isHttps: any): Proxy;
export function getAzureProxy(proxy: Proxy): {
    host: string;
    port: number;
    user?: string;
    password?: string;
};
export function hideEnvironmentProxy(): void;
export function restoreEnvironmentProxy(): void;
export function isByPassProxy(proxy: any, destination: string | Regex): any;
export function describeProxy(proxy: any): string;
export function stringifyProxy(proxy: any): string;
export type Proxy = {
    /**
     * - The host address of the proxy.
     */
    host: string;
    /**
     * - The protocol used by the proxy (e.g., "http" or "https")
     */
    protocol: string;
    /**
     * - The username for the proxy
     */
    user: string;
    /**
     * - The port number.
     */
    port: number;
    /**
     * - The password for the proxy
     */
    password: string;
    /**
     * -  Optional list of domains that should bypass the prox
     */
    noProxy: string;
};
