export = SecretDetector;
/**
 * The secret detector detects sensitive information.
 * It masks secrets that might be leaked from two potential avenues
 *  1. Out of Band Telemetry
 *  2. Logging
 *
 * @param {Object} customPatterns contains 'regex' and 'mask' for customized masking
 * @param {Object} mock
 *
 * @returns {Object}
 * @constructor
 */
declare function SecretDetector(customPatterns: Object, mock: Object): Object;
declare class SecretDetector {
    /**
     * The secret detector detects sensitive information.
     * It masks secrets that might be leaked from two potential avenues
     *  1. Out of Band Telemetry
     *  2. Logging
     *
     * @param {Object} customPatterns contains 'regex' and 'mask' for customized masking
     * @param {Object} mock
     *
     * @returns {Object}
     * @constructor
     */
    constructor(customPatterns: Object, mock: Object);
    /**
     * Masks any secrets.
     *
     * @param {String} text may contain a secret.
     *
     * @returns {Object} the masked string.
     */
    maskSecrets: (text: string) => Object;
}
