import { name as driverName, version as driverVersion } from '../package.json';
export { driverName, driverVersion };
export declare const userAgent: string;
/**
 * Note: A simple wrapper around util.inherits() for now, but this might change
 * in the future.
 *
 * Inherits the prototype methods from one constructor into another. The
 * prototype of constructor will be set to a new object created from
 * superConstructor.
 *
 * @param constructor
 * @param superConstructor
 *
 * @returns {Object}
 */
export declare function inherits(constructor: any, superConstructor: any): void;
/**
 * Note: A simple wrapper around util.format() for now, but this will likely
 * change in the future.
 *
 * Returns a formatted string using the first argument as a printf-like format.
 *
 * The first argument is a string that contains zero or more placeholders.
 * Each placeholder is replaced with the converted value from its corresponding
 * argument. Supported placeholders are:
 *   %s - String.
 *   %d - Number (both integer and float).
 *   %j - JSON. Replaced with the string '[Circular]' if the argument contains
 *        circular references.
 *   %% - single percent sign ('%'). This does not consume an argument.
 *
 * If the placeholder does not have a corresponding argument, the placeholder is
 * not replaced.
 *
 * If there are more arguments than placeholders, the extra arguments are
 * coerced to strings (for objects and symbols, util.inspect() is used) and then
 * concatenated, delimited by a space.
 *
 * If the first argument is not a format string then util.format() returns a
 * string that is the concatenation of all its arguments separated by spaces.
 * Each argument is converted to a string with util.inspect().
 */
export declare function format(format: string, ...params: any[]): string;
/**
 * Determines if a given value is a function.
 */
export declare function isFunction(value: any): boolean;
/**
 * Determines if a given value is an object.
 */
export declare function isObject(value: any): boolean;
/**
 * Determines if a given value is a Date.
 */
export declare function isDate(value: any): boolean;
/**
 * Determines if a given value is an array.
 */
export declare function isArray(value: any): boolean;
/**
 * Determines if a given value is a string.
 */
export declare function isString(value: any): value is string;
/**
 * Determines if a given value is a boolean.
 */
export declare function isBoolean(value: any): value is boolean;
/**
 * Determines if a given value is a number.
 */
export declare function isNumber(value: any): boolean;
/**
 * Determines if a given value is a private key string in pem format of type pkcs8.
 */
export declare function isPrivateKey(value: string): boolean;
/**
 * A collection of number-related utility functions.
 */
export declare const number: {
    /**
     * Determines if a given value is a positive number.
     */
    isPositive: (value: any) => boolean;
    /**
     * Determines if a given value is a non-negative number.
     */
    isNonNegative: (value: any) => boolean;
    /**
     * Determines if a given value is an integer.
     */
    isInteger: (value: any) => boolean;
    /**
     * Determines if a given value is a positive integer.
     */
    isPositiveInteger: (value: any) => boolean;
    /**
     * Determines if a given value is a non-negative integer.
     */
    isNonNegativeInteger: (value: any) => boolean;
};
/**
 * A collection of string-related utility functions.
 */
export declare const string: {
    /**
     * Determines if a given string is not null or empty.
     */
    isNotNullOrEmpty: (value: any) => string | false;
    /**
     * Compares two version numbers of the form 'a.b.c' where a, b and c are
     * numbers (e.g. '1.0.12'). If one or both inputs are invalid versions, the
     * function will return NaN, otherwise, it will return -1 if the first
     * version is smaller, 1 if the first version is bigger, and 0 if the two
     * versions are equal.
     */
    compareVersions: (version1: string, version2: string) => number;
};
/**
 * Determines if a given value is not null or undefined.
 *
 * @deprecated Just use if (!value) instead
 */
export declare function exists(value: any): boolean;
/**
 * A collection of url-related utility functions.
 */
export declare const url: {
    /**
     * Appends a query parameter to a url. If an invalid url is specified, an
     * exception is thrown.
     *
     * @param url
     * @param paramName the name of the query parameter.
     * @param paramValue the value of the query parameter.
     */
    appendParam: (url: string, paramName: string, paramValue: any) => string;
    appendRetryParam: (option: {
        url: string;
        retryCount: number;
        includeRetryReason: boolean;
        retryReason: string;
    }) => string;
};
/**
 * Shallow-copies everything from a source object into a destination object.
 *
 * @param {Object} dst the object to copy properties to.
 * @param {Object} src the object to copy properties from.
 */
export declare function apply(dst: any, src: any): any;
/**
 * Returns true if the code is currently being run in the browser, false
 * otherwise.
 */
export declare function isBrowser(): boolean;
/**
 * Returns true if the code is currently being run in node, false otherwise.
 */
export declare function isNode(): boolean;
/**
 * Returns the next sleep time calculated by exponential backoff with
 * decorrelated jitter.
 * sleep = min(cap, random_between(base, sleep * 3))
 * for more details, check out:
 * http://www.awsarchitectureblog.com/2015/03/backoff.html
 * @param base minimum seconds
 * @param cap maximum seconds
 * @param previousSleep previous sleep time
 */
export declare function nextSleepTime(base: number, cap: number, previousSleep: number): number;
/**
 * Return next sleep time calculated by the jitter rule.
 */
export declare function getJitteredSleepTime(numofRetries: number, currentSleepTime: number, totalElapsedTime: number, maxRetryTimeout: number): {
    sleep: number;
    totalElapsedTime: number;
};
/**
 * Choose one of the number between two numbers.
 */
export declare function chooseRandom(firstNumber: number, secondNumber: number): number;
/**
 * return the next sleep Time.
 */
export declare function getNextSleepTime(numofRetries: number, currentSleepTime: number): number;
/**
 * return the jitter value.
 */
export declare function getJitter(currentSleepTime: number): number;
/**
 * Check whether the request is the login-request or not.
 */
export declare function isLoginRequest(loginUrl: string): boolean;
/**
 * Checks if the HTTP response code is retryable
 *
 * @param response HTTP response object
 * @param retry403 will retry HTTP 403?
 */
export declare function isRetryableHttpError(response: any, retry403: boolean): any;
export declare function validateClientSessionKeepAliveHeartbeatFrequency(input: number, masterValidity: number): number;
/**
 * Constructs host name using region and account
 *
 * @param region where the account is located
 * @param account which account to connect to
 */
export declare function constructHostname(region: string, account: string): string;
/**
 * Returns true if host indicates private link
 */
export declare function isPrivateLink(host: string): boolean;
export declare function createOcspResponseCacheServerUrl(host: string): string;
/**
 * Returns if command is a PUT command
 */
export declare function isPutCommand(sqlText: string): boolean;
/**
 * Returns if command is a GET command
 */
export declare function isGetCommand(sqlText: string): boolean;
/**
 * Add double quotes to smkId's value to parse it as a string instead of integer
 * to preserve precision of numbers exceeding JavaScript's max safe integer
 * e.g (inputting 32621973126123526	outputs 32621973126123530)
 *
 * @param body the data in JSON
 */
export declare function convertSmkIdToString(body: string): string;
/**
 * Under some circumstances the object passed to JSON.stringify in exception handling
 * can contain circular reference, on which JSON.stringify bails out
 * MDN way of handling such error
 */
export declare function getCircularReplacer(): (key: string, value: any) => string;
/**
 * Returns if the provided string is a valid subdomain.
 */
export declare function isCorrectSubdomain(value: string): boolean;
export declare function buildCredentialCacheKey(host: string, username: string, credType: string): string | null;
export declare function checkValidCustomCredentialManager(customCredentialManager: any): boolean;
export declare function checkParametersDefined(...parameters: any[]): boolean;
/**
 * Checks if the provided file or directory permissions are correct.
 * @param filePath
 * @param expectedMode
 * @param fsPromises
 * @returns {Promise<boolean>} resolves always to true for Windows
 */
export declare function isFileModeCorrect(filePath: string, expectedMode: number, fsPromises: any): Promise<any>;
/**
 * Checks if the provided file or directory is writable only by the user.
 * @returns {Promise<boolean>} resolves always to true for Windows
 */
export declare function isFileNotWritableByGroupOrOthers(configFilePath: string, fsPromises: any): Promise<boolean>;
export declare function shouldRetryOktaAuth({ maxRetryTimeout, maxRetryCount, numRetries, startTime, remainingTimeout, }: {
    maxRetryTimeout: number;
    maxRetryCount: number;
    numRetries: number;
    startTime: number;
    remainingTimeout: number;
}): boolean;
export declare function getDriverDirectory(): string;
export declare function validatePath(dir: string): boolean;
export declare function getEnvVar(variable: string): string | undefined;
export declare function validateEmptyString(value: string): string | undefined;
export declare function isNotEmptyAsString(variable: string): string | boolean;
export declare function isNotEmptyString(variable: string): boolean;
/**
 * Checks Whether the object is empty (can be null or undefined) or not.
 */
export declare function isEmptyObject(object: object): boolean;
export declare function isWindows(): boolean;
export declare function getFreePort(): Promise<unknown>;
export declare function isPortOpen(port: number): Promise<unknown>;
/**
 * Left strip the specified character from a string.
 */
export declare function lstrip(str: string, remove: string): string;
/**
 * This method transforms HTML special characters into their corresponding entity representations.
 */
export declare function escapeHTML(value: string): string;
/**
 * Typescript with "module": "commonjs" will transform every import() to a require() statement.
 *
 * This will break ESM dynamic imports resulting in a runtime error:
 * -require() of ES Module... from ... not supported.
 *
 * A hacky solution - https://github.com/microsoft/TypeScript/issues/43329
 *
 * This could be removed once we drop node 18 support as Node 20+ support esm in require()
 */
export declare function dynamicImportESMInTypescriptWithCommonJS(moduleName: string): Promise<any>;
