# typeof-article [![NPM version](https://img.shields.io/npm/v/typeof-article.svg?style=flat)](https://www.npmjs.com/package/typeof-article) [![NPM monthly downloads](https://img.shields.io/npm/dm/typeof-article.svg?style=flat)](https://npmjs.org/package/typeof-article)  [![NPM total downloads](https://img.shields.io/npm/dt/typeof-article.svg?style=flat)](https://npmjs.org/package/typeof-article) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/typeof-article.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/typeof-article)

> Get the native JavaScript type of a value, preceded by the appropriate indefinite article (either `a` or `an`), for use in error messages.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save typeof-article
```

## Usage

_(A few of the types have some extra formatting where it makes sense. For example, instead of `a regexp`, it returns `a regular expression`, which IMHO is more readable to users. You can [customize mappings](#customize) if you want)_

```js
var type = require('typeof-article');

console.log(type({}));
//=> 'an object'

console.log(type([]));
//=> 'an array'

console.log(type(9));
//=> 'a number'

console.log(type(/abc/));
//=> 'a regular expression'

console.log(type(new WeakMap()));
//=> 'a WeakMap'
```

Get the object of types-to-articles mappings:

```js
var types = require('typeof-article').types;
```

Also exposes a `typeOf` property, for getting the native type only:

```js
var type = require('typeof-article');
type.types.weapmap = 'a WeakMap()';

console.log(type.typeOf(new WeakMap()));
//=> 'weakmap'
```

## Customize

Customize any of the mappings:

```js
var type = require('typeof-article');
type.types.weapmap = 'a WeakMap()';

console.log(type(new WeakMap()));
//=> 'a WeakMap()'
```

## About

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
MIT

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.2, on January 30, 2017._