"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generalPartition = void 0;
const encodings_js_1 = require("../lib/encodings.js");
const files_js_1 = require("../lib/files.js");
const m$ = __importStar(require("../lib/matchers.js"));
const schemas$ = __importStar(require("../lib/schemas.js"));
const security_js_1 = require("../lib/security.js");
const url_js_1 = require("../lib/url.js");
const errors = __importStar(require("../sdk/models/errors/index.js"));
const operations = __importStar(require("../sdk/models/operations/index.js"));
const blobs_js_1 = require("../sdk/types/blobs.js");
const streams_js_1 = require("../sdk/types/streams.js");
/**
 * Summary
 *
 * @remarks
 * Description
 */
async function generalPartition(client$, request, options) {
    var _a;
    const input$ = request;
    const parsed$ = schemas$.safeParse(input$, (value$) => operations.PartitionRequest$outboundSchema.parse(value$), "Input validation failed");
    if (!parsed$.ok) {
        return parsed$;
    }
    const payload$ = parsed$.value;
    const body$ = new FormData();
    if ((0, blobs_js_1.isBlobLike)(payload$.partition_parameters.files)) {
        body$.append("files", payload$.partition_parameters.files);
    }
    else if ((0, streams_js_1.isReadableStream)(payload$.partition_parameters.files.content)) {
        const buffer = await (0, files_js_1.readableStreamToArrayBuffer)(payload$.partition_parameters.files.content);
        const blob = new Blob([buffer], { type: "application/octet-stream" });
        body$.append("files", blob);
    }
    else {
        body$.append("files", new Blob([payload$.partition_parameters.files.content], {
            type: "application/octet-stream",
        }), payload$.partition_parameters.files.fileName);
    }
    if (payload$.partition_parameters.chunking_strategy !== undefined) {
        body$.append("chunking_strategy", String(payload$.partition_parameters.chunking_strategy));
    }
    if (payload$.partition_parameters.combine_under_n_chars !== undefined) {
        body$.append("combine_under_n_chars", String(payload$.partition_parameters.combine_under_n_chars));
    }
    if (payload$.partition_parameters.content_type !== undefined) {
        body$.append("content_type", String(payload$.partition_parameters.content_type));
    }
    if (payload$.partition_parameters.coordinates !== undefined) {
        body$.append("coordinates", String(payload$.partition_parameters.coordinates));
    }
    if (payload$.partition_parameters.encoding !== undefined) {
        body$.append("encoding", String(payload$.partition_parameters.encoding));
    }
    if (payload$.partition_parameters.extract_image_block_types !== undefined) {
        body$.append("extract_image_block_types", String(payload$.partition_parameters.extract_image_block_types));
    }
    if (payload$.partition_parameters.gz_uncompressed_content_type !== undefined) {
        body$.append("gz_uncompressed_content_type", String(payload$.partition_parameters.gz_uncompressed_content_type));
    }
    if (payload$.partition_parameters.hi_res_model_name !== undefined) {
        body$.append("hi_res_model_name", String(payload$.partition_parameters.hi_res_model_name));
    }
    if (payload$.partition_parameters.include_orig_elements !== undefined) {
        body$.append("include_orig_elements", String(payload$.partition_parameters.include_orig_elements));
    }
    if (payload$.partition_parameters.include_page_breaks !== undefined) {
        body$.append("include_page_breaks", String(payload$.partition_parameters.include_page_breaks));
    }
    if (payload$.partition_parameters.include_slide_notes !== undefined) {
        body$.append("include_slide_notes", String(payload$.partition_parameters.include_slide_notes));
    }
    if (payload$.partition_parameters.languages !== undefined) {
        body$.append("languages", String(payload$.partition_parameters.languages));
    }
    if (payload$.partition_parameters.max_characters !== undefined) {
        body$.append("max_characters", String(payload$.partition_parameters.max_characters));
    }
    if (payload$.partition_parameters.multipage_sections !== undefined) {
        body$.append("multipage_sections", String(payload$.partition_parameters.multipage_sections));
    }
    if (payload$.partition_parameters.new_after_n_chars !== undefined) {
        body$.append("new_after_n_chars", String(payload$.partition_parameters.new_after_n_chars));
    }
    if (payload$.partition_parameters.ocr_languages !== undefined) {
        body$.append("ocr_languages", String(payload$.partition_parameters.ocr_languages));
    }
    if (payload$.partition_parameters.output_format !== undefined) {
        body$.append("output_format", payload$.partition_parameters.output_format);
    }
    if (payload$.partition_parameters.overlap !== undefined) {
        body$.append("overlap", String(payload$.partition_parameters.overlap));
    }
    if (payload$.partition_parameters.overlap_all !== undefined) {
        body$.append("overlap_all", String(payload$.partition_parameters.overlap_all));
    }
    if (payload$.partition_parameters.pdf_infer_table_structure !== undefined) {
        body$.append("pdf_infer_table_structure", String(payload$.partition_parameters.pdf_infer_table_structure));
    }
    if (payload$.partition_parameters.similarity_threshold !== undefined) {
        body$.append("similarity_threshold", String(payload$.partition_parameters.similarity_threshold));
    }
    if (payload$.partition_parameters.skip_infer_table_types !== undefined) {
        body$.append("skip_infer_table_types", String(payload$.partition_parameters.skip_infer_table_types));
    }
    if (payload$.partition_parameters.split_pdf_allow_failed !== undefined) {
        body$.append("split_pdf_allow_failed", String(payload$.partition_parameters.split_pdf_allow_failed));
    }
    if (payload$.partition_parameters.split_pdf_concurrency_level !== undefined) {
        body$.append("split_pdf_concurrency_level", String(payload$.partition_parameters.split_pdf_concurrency_level));
    }
    if (payload$.partition_parameters.split_pdf_page !== undefined) {
        body$.append("split_pdf_page", String(payload$.partition_parameters.split_pdf_page));
    }
    if (payload$.partition_parameters.split_pdf_page_range !== undefined) {
        body$.append("split_pdf_page_range", String(payload$.partition_parameters.split_pdf_page_range));
    }
    if (payload$.partition_parameters.starting_page_number !== undefined) {
        body$.append("starting_page_number", String(payload$.partition_parameters.starting_page_number));
    }
    if (payload$.partition_parameters.strategy !== undefined) {
        body$.append("strategy", payload$.partition_parameters.strategy);
    }
    if (payload$.partition_parameters.unique_element_ids !== undefined) {
        body$.append("unique_element_ids", String(payload$.partition_parameters.unique_element_ids));
    }
    if (payload$.partition_parameters.xml_keep_tags !== undefined) {
        body$.append("xml_keep_tags", String(payload$.partition_parameters.xml_keep_tags));
    }
    const path$ = (0, url_js_1.pathToFunc)("/general/v0/general")();
    const headers$ = new Headers({
        Accept: "application/json",
        "unstructured-api-key": (0, encodings_js_1.encodeSimple)("unstructured-api-key", payload$["unstructured-api-key"], { explode: false, charEncoding: "none" }),
    });
    const security$ = await (0, security_js_1.extractSecurity)(client$.options$.security);
    const context = {
        operationID: "partition",
        oAuth2Scopes: [],
        securitySource: client$.options$.security,
    };
    const securitySettings$ = (0, security_js_1.resolveGlobalSecurity)(security$);
    const requestRes = client$.createRequest$(context, {
        security: securitySettings$,
        method: "POST",
        path: path$,
        headers: headers$,
        body: body$,
        timeoutMs: (options === null || options === void 0 ? void 0 : options.timeoutMs) || client$.options$.timeoutMs || -1,
    }, options);
    if (!requestRes.ok) {
        return requestRes;
    }
    const request$ = requestRes.value;
    const doResult = await client$.do$(request$, {
        context,
        errorCodes: ["422", "4XX", "5XX"],
        retryConfig: (options === null || options === void 0 ? void 0 : options.retries) ||
            client$.options$.retryConfig || {
            strategy: "backoff",
            backoff: {
                initialInterval: 3000,
                maxInterval: 720000,
                exponent: 1.88,
                maxElapsedTime: 1800000,
            },
            retryConnectionErrors: true,
        },
        retryCodes: (options === null || options === void 0 ? void 0 : options.retryCodes) || ["502", "503", "504"],
    });
    if (!doResult.ok) {
        return doResult;
    }
    const response = doResult.value;
    const responseFields$ = {
        ContentType: (_a = response.headers.get("content-type")) !== null && _a !== void 0 ? _a : "application/octet-stream",
        StatusCode: response.status,
        RawResponse: response,
        Headers: {},
    };
    const [result$] = await m$.match(m$.json(200, operations.PartitionResponse$inboundSchema, { key: "Elements" }), m$.jsonErr(422, errors.HTTPValidationError$inboundSchema), m$.fail("4XX"), m$.jsonErr("5XX", errors.ServerError$inboundSchema))(response, { extraFields: responseFields$ });
    if (!result$.ok) {
        return result$;
    }
    return result$;
}
exports.generalPartition = generalPartition;
//# sourceMappingURL=generalPartition.js.map