"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.encodeDeepObjectQuery = exports.encodePipeDelimitedQuery = exports.encodeSpaceDelimitedQuery = exports.encodeFormQuery = exports.encodeJSONQuery = exports.queryEncoder = exports.queryJoin = exports.encodeSimple = exports.encodeJSON = exports.encodeDeepObjectObject = exports.encodeDeepObject = exports.encodeBodyForm = exports.encodePipeDelimited = exports.encodeSpaceDelimited = exports.encodeForm = exports.encodeLabel = exports.encodeMatrix = exports.EncodingError = void 0;
const base64_js_1 = require("./base64.js");
const is_plain_object_js_1 = require("./is-plain-object.js");
class EncodingError extends Error {
    constructor(message) {
        super(message);
        this.name = "EncodingError";
    }
}
exports.EncodingError = EncodingError;
function encodeMatrix(key, value, options) {
    let out = "";
    const pairs = (options === null || options === void 0 ? void 0 : options.explode)
        ? explode(key, value)
        : [[key, value]];
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    const encodeValue = (v) => encodeString(serializeValue(v));
    pairs.forEach(([pk, pv]) => {
        let tmp = "";
        let encValue = "";
        if (pv === undefined) {
            return;
        }
        else if (Array.isArray(pv)) {
            encValue = mapDefined(pv, (v) => `${encodeValue(v)}`).join(",");
        }
        else if ((0, is_plain_object_js_1.isPlainObject)(pv)) {
            encValue = mapDefinedEntries(Object.entries(pv), ([k, v]) => {
                return `,${encodeString(k)},${encodeValue(v)}`;
            }).join("");
            encValue = encValue.slice(1);
        }
        else {
            encValue = `${encodeValue(pv)}`;
        }
        const keyPrefix = encodeString(pk);
        tmp = `${keyPrefix}=${encValue}`;
        // trim trailing '=' if value was empty
        if (tmp === `${keyPrefix}=`) {
            tmp = tmp.slice(0, -1);
        }
        // If we end up with the nothing then skip forward
        if (!tmp) {
            return;
        }
        out += `;${tmp}`;
    });
    return out;
}
exports.encodeMatrix = encodeMatrix;
function encodeLabel(key, value, options) {
    let out = "";
    const pairs = (options === null || options === void 0 ? void 0 : options.explode)
        ? explode(key, value)
        : [[key, value]];
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    const encodeValue = (v) => encodeString(serializeValue(v));
    pairs.forEach(([pk, pv]) => {
        let encValue = "";
        if (pv === undefined) {
            return;
        }
        else if (Array.isArray(pv)) {
            encValue = mapDefined(pv, (v) => `${encodeValue(v)}`).join(".");
        }
        else if ((0, is_plain_object_js_1.isPlainObject)(pv)) {
            encValue = mapDefinedEntries(Object.entries(pv), ([k, v]) => {
                return `.${encodeString(k)}.${encodeValue(v)}`;
            }).join("");
            encValue = encValue.slice(1);
        }
        else {
            const k = (options === null || options === void 0 ? void 0 : options.explode) && (0, is_plain_object_js_1.isPlainObject)(value) ? `${encodeString(pk)}=` : "";
            encValue = `${k}${encodeValue(pv)}`;
        }
        out += `.${encValue}`;
    });
    return out;
}
exports.encodeLabel = encodeLabel;
function formEncoder(sep) {
    return (key, value, options) => {
        let out = "";
        const pairs = (options === null || options === void 0 ? void 0 : options.explode)
            ? explode(key, value)
            : [[key, value]];
        const encodeString = (v) => {
            return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
        };
        const encodeValue = (v) => encodeString(serializeValue(v));
        const encodedSep = encodeString(sep);
        pairs.forEach(([pk, pv]) => {
            let tmp = "";
            let encValue = "";
            if (pv === undefined) {
                return;
            }
            else if (Array.isArray(pv)) {
                encValue = mapDefined(pv, (v) => `${encodeValue(v)}`).join(encodedSep);
            }
            else if ((0, is_plain_object_js_1.isPlainObject)(pv)) {
                encValue = mapDefinedEntries(Object.entries(pv), ([k, v]) => {
                    return `${encodeString(k)}${encodedSep}${encodeValue(v)}`;
                }).join(encodedSep);
            }
            else {
                encValue = `${encodeValue(pv)}`;
            }
            tmp = `${encodeString(pk)}=${encValue}`;
            // If we end up with the nothing then skip forward
            if (!tmp || tmp === "=") {
                return;
            }
            out += `&${tmp}`;
        });
        return out.slice(1);
    };
}
exports.encodeForm = formEncoder(",");
exports.encodeSpaceDelimited = formEncoder(" ");
exports.encodePipeDelimited = formEncoder("|");
function encodeBodyForm(key, value, options) {
    let out = "";
    const pairs = (options === null || options === void 0 ? void 0 : options.explode)
        ? explode(key, value)
        : [[key, value]];
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    const encodeValue = (v) => encodeString(serializeValue(v));
    pairs.forEach(([pk, pv]) => {
        let tmp = "";
        let encValue = "";
        if (pv === undefined) {
            return;
        }
        else if (Array.isArray(pv)) {
            encValue = JSON.stringify(pv, jsonReplacer);
        }
        else if ((0, is_plain_object_js_1.isPlainObject)(pv)) {
            encValue = JSON.stringify(pv, jsonReplacer);
        }
        else {
            encValue = `${encodeValue(pv)}`;
        }
        tmp = `${encodeString(pk)}=${encValue}`;
        // If we end up with the nothing then skip forward
        if (!tmp || tmp === "=") {
            return;
        }
        out += `&${tmp}`;
    });
    return out.slice(1);
}
exports.encodeBodyForm = encodeBodyForm;
function encodeDeepObject(key, value, options) {
    if (value == null) {
        return "";
    }
    if (!(0, is_plain_object_js_1.isPlainObject)(value)) {
        throw new EncodingError(`Value of parameter '${key}' which uses deepObject encoding must be an object`);
    }
    return encodeDeepObjectObject(key, value, options);
}
exports.encodeDeepObject = encodeDeepObject;
function encodeDeepObjectObject(key, value, options) {
    if (value == null) {
        return "";
    }
    let out = "";
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    if (!(0, is_plain_object_js_1.isPlainObject)(value)) {
        throw new EncodingError(`Expected parameter '${key}' to be an object.`);
    }
    Object.entries(value).forEach(([ck, cv]) => {
        if (cv === undefined) {
            return;
        }
        const pk = `${key}[${ck}]`;
        if ((0, is_plain_object_js_1.isPlainObject)(cv)) {
            const objOut = encodeDeepObjectObject(pk, cv, options);
            out += `&${objOut}`;
            return;
        }
        const pairs = Array.isArray(cv) ? cv : [cv];
        let encoded = "";
        encoded = mapDefined(pairs, (v) => {
            return `${encodeString(pk)}=${encodeString(serializeValue(v))}`;
        }).join("&");
        out += `&${encoded}`;
    });
    return out.slice(1);
}
exports.encodeDeepObjectObject = encodeDeepObjectObject;
function encodeJSON(key, value, options) {
    if (typeof value === "undefined") {
        return "";
    }
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    const encVal = encodeString(JSON.stringify(value, jsonReplacer));
    return (options === null || options === void 0 ? void 0 : options.explode) ? encVal : `${encodeString(key)}=${encVal}`;
}
exports.encodeJSON = encodeJSON;
const encodeSimple = (key, value, options) => {
    let out = "";
    const pairs = (options === null || options === void 0 ? void 0 : options.explode)
        ? explode(key, value)
        : [[key, value]];
    const encodeString = (v) => {
        return (options === null || options === void 0 ? void 0 : options.charEncoding) === "percent" ? encodeURIComponent(v) : v;
    };
    const encodeValue = (v) => encodeString(serializeValue(v));
    pairs.forEach(([pk, pv]) => {
        let tmp = "";
        if (pv === undefined) {
            return;
        }
        else if (Array.isArray(pv)) {
            tmp = mapDefined(pv, (v) => `${encodeValue(v)}`).join(",");
        }
        else if ((0, is_plain_object_js_1.isPlainObject)(pv)) {
            tmp = mapDefinedEntries(Object.entries(pv), ([k, v]) => {
                return `,${encodeString(k)},${encodeValue(v)}`;
            }).join("");
            tmp = tmp.slice(1);
        }
        else {
            const k = (options === null || options === void 0 ? void 0 : options.explode) && (0, is_plain_object_js_1.isPlainObject)(value) ? `${pk}=` : "";
            tmp = `${k}${encodeValue(pv)}`;
        }
        // If we end up with the nothing then skip forward
        if (!tmp) {
            return;
        }
        out += `,${tmp}`;
    });
    return out.slice(1);
};
exports.encodeSimple = encodeSimple;
function explode(key, value) {
    if (Array.isArray(value)) {
        return value.map((v) => [key, v]);
    }
    else if ((0, is_plain_object_js_1.isPlainObject)(value)) {
        const o = value !== null && value !== void 0 ? value : {};
        return Object.entries(o).map(([k, v]) => [k, v]);
    }
    else {
        return [[key, value]];
    }
}
function serializeValue(value) {
    if (value === null) {
        return "null";
    }
    else if (typeof value === "undefined") {
        return "";
    }
    else if (value instanceof Date) {
        return value.toISOString();
    }
    else if (value instanceof Uint8Array) {
        return (0, base64_js_1.bytesToBase64)(value);
    }
    else if (typeof value === "object") {
        return JSON.stringify(value, jsonReplacer);
    }
    return `${value}`;
}
function jsonReplacer(_, value) {
    if (value instanceof Uint8Array) {
        return (0, base64_js_1.bytesToBase64)(value);
    }
    else {
        return value;
    }
}
function mapDefined(inp, mapper) {
    return inp.reduce((acc, v) => {
        if (v === undefined) {
            return acc;
        }
        const m = mapper(v);
        if (m === undefined) {
            return acc;
        }
        acc.push(m);
        return acc;
    }, []);
}
function mapDefinedEntries(inp, mapper) {
    const acc = [];
    for (const [k, v] of inp) {
        if (v === undefined) {
            continue;
        }
        const m = mapper([k, v]);
        if (m === undefined) {
            continue;
        }
        acc.push(m);
    }
    return acc;
}
function queryJoin(...args) {
    return args.filter(Boolean).join("&");
}
exports.queryJoin = queryJoin;
function queryEncoder(f) {
    const bulkEncode = function (values, options) {
        var _a, _b;
        const opts = {
            ...options,
            explode: (_a = options === null || options === void 0 ? void 0 : options.explode) !== null && _a !== void 0 ? _a : true,
            charEncoding: (_b = options === null || options === void 0 ? void 0 : options.charEncoding) !== null && _b !== void 0 ? _b : "percent",
        };
        const encoded = Object.entries(values).map(([key, value]) => {
            return f(key, value, opts);
        });
        return queryJoin(...encoded);
    };
    return bulkEncode;
}
exports.queryEncoder = queryEncoder;
exports.encodeJSONQuery = queryEncoder(encodeJSON);
exports.encodeFormQuery = queryEncoder(exports.encodeForm);
exports.encodeSpaceDelimitedQuery = queryEncoder(exports.encodeSpaceDelimited);
exports.encodePipeDelimitedQuery = queryEncoder(exports.encodePipeDelimited);
exports.encodeDeepObjectQuery = queryEncoder(encodeDeepObject);
//# sourceMappingURL=encodings.js.map