"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.discardResponseBody = exports.unpackHeaders = exports.match = exports.fail = exports.nil = exports.nilErr = exports.sse = exports.sseErr = exports.stream = exports.streamErr = exports.bytes = exports.bytesErr = exports.text = exports.textErr = exports.json = exports.jsonErr = void 0;
const schemas_js_1 = require("./schemas.js");
const http_js_1 = require("./http.js");
const is_plain_object_js_1 = require("./is-plain-object.js");
const sdkerror_js_1 = require("../sdk/models/errors/sdkerror.js");
const DEFAULT_CONTENT_TYPES = {
    json: "application/json",
    text: "text/plain",
    bytes: "application/octet-stream",
    stream: "application/octet-stream",
    sse: "text/event-stream",
    nil: "*",
    fail: "*",
};
function jsonErr(codes, schema, options) {
    return { ...options, err: true, enc: "json", codes, schema };
}
exports.jsonErr = jsonErr;
function json(codes, schema, options) {
    return { ...options, enc: "json", codes, schema };
}
exports.json = json;
function textErr(codes, schema, options) {
    return { ...options, err: true, enc: "text", codes, schema };
}
exports.textErr = textErr;
function text(codes, schema, options) {
    return { ...options, enc: "text", codes, schema };
}
exports.text = text;
function bytesErr(codes, schema, options) {
    return { ...options, err: true, enc: "bytes", codes, schema };
}
exports.bytesErr = bytesErr;
function bytes(codes, schema, options) {
    return { ...options, enc: "bytes", codes, schema };
}
exports.bytes = bytes;
function streamErr(codes, schema, options) {
    return { ...options, err: true, enc: "stream", codes, schema };
}
exports.streamErr = streamErr;
function stream(codes, schema, options) {
    return { ...options, enc: "stream", codes, schema };
}
exports.stream = stream;
function sseErr(codes, schema, options) {
    return { ...options, err: true, enc: "sse", codes, schema };
}
exports.sseErr = sseErr;
function sse(codes, schema, options) {
    return { ...options, enc: "sse", codes, schema };
}
exports.sse = sse;
function nilErr(codes, schema, options) {
    return { ...options, err: true, enc: "nil", codes, schema };
}
exports.nilErr = nilErr;
function nil(codes, schema, options) {
    return { ...options, enc: "nil", codes, schema };
}
exports.nil = nil;
function fail(codes) {
    return { enc: "fail", codes };
}
exports.fail = fail;
function match(...matchers) {
    return async function matchFunc(response, options) {
        let raw;
        let matcher;
        for (const match of matchers) {
            const { codes } = match;
            const ctpattern = "ctype" in match ? match.ctype : DEFAULT_CONTENT_TYPES[match.enc];
            if (ctpattern && (0, http_js_1.matchResponse)(response, codes, ctpattern)) {
                matcher = match;
                break;
            }
            else if (!ctpattern && (0, http_js_1.matchStatusCode)(response, codes)) {
                matcher = match;
                break;
            }
        }
        if (!matcher) {
            const responseBody = await response.text();
            return [
                {
                    ok: false,
                    error: new sdkerror_js_1.SDKError("Unexpected API response status or content-type", response, responseBody),
                },
                responseBody,
            ];
        }
        const encoding = matcher.enc;
        switch (encoding) {
            case "json":
                raw = await response.json();
                break;
            case "bytes":
                raw = await response.arrayBuffer();
                break;
            case "stream":
                raw = response.body;
                break;
            case "text":
                raw = await response.text();
                break;
            case "sse":
                raw = response.body;
                break;
            case "nil":
                raw = await discardResponseBody(response);
                break;
            case "fail":
                raw = await response.text();
                break;
            default:
                encoding;
                throw new Error(`Unsupported response type: ${encoding}`);
        }
        if (matcher.enc === "fail") {
            return [
                {
                    ok: false,
                    error: new sdkerror_js_1.SDKError("API error occurred", response, typeof raw === "string" ? raw : ""),
                },
                raw,
            ];
        }
        const resultKey = matcher.key || (options === null || options === void 0 ? void 0 : options.resultKey);
        let data;
        if ("err" in matcher) {
            data = {
                ...options === null || options === void 0 ? void 0 : options.extraFields,
                ...(matcher.hdrs ? { Headers: unpackHeaders(response.headers) } : null),
                ...((0, is_plain_object_js_1.isPlainObject)(raw) ? raw : null),
            };
        }
        else if (resultKey) {
            data = {
                ...options === null || options === void 0 ? void 0 : options.extraFields,
                ...(matcher.hdrs ? { Headers: unpackHeaders(response.headers) } : null),
                [resultKey]: raw,
            };
        }
        else {
            data = {
                ...options === null || options === void 0 ? void 0 : options.extraFields,
                ...(matcher.hdrs ? { Headers: unpackHeaders(response.headers) } : null),
            };
        }
        if ("err" in matcher) {
            const result = (0, schemas_js_1.safeParse)(data, (v) => matcher.schema.parse(v), "Response validation failed");
            return [result.ok ? { ok: false, error: result.value } : result, raw];
        }
        else {
            return [
                (0, schemas_js_1.safeParse)(data, (v) => matcher.schema.parse(v), "Response validation failed"),
                raw,
            ];
        }
    };
}
exports.match = match;
const headerValRE = /, */;
/**
 * Iterates over a Headers object and returns an object with all the header
 * entries. Values are represented as an array to account for repeated headers.
 */
function unpackHeaders(headers) {
    const out = {};
    for (const [k, v] of headers.entries()) {
        out[k] = v.split(headerValRE);
    }
    return out;
}
exports.unpackHeaders = unpackHeaders;
/**
 * Discards the response body to free up resources.
 *
 * To learn why this is need, see the undici docs:
 * https://undici.nodejs.org/#/?id=garbage-collection
 */
async function discardResponseBody(res) {
    var _a;
    const reader = (_a = res.body) === null || _a === void 0 ? void 0 : _a.getReader();
    if (reader == null) {
        return;
    }
    try {
        let done = false;
        while (!done) {
            const res = await reader.read();
            done = res.done;
        }
    }
    finally {
        reader.releaseLock();
    }
}
exports.discardResponseBody = discardResponseBody;
//# sourceMappingURL=matchers.js.map