"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.remap = void 0;
/**
 * Converts or omits an object's keys according to a mapping.
 *
 * @param inp An object whose keys will be remapped
 * @param mappings A mapping of original keys to new keys. If a key is not present in the mapping, it will be left as is. If a key is mapped to `null`, it will be removed in the resulting object.
 * @returns A new object with keys remapped or omitted according to the mappings
 */
function remap(inp, mappings) {
    let out = {};
    if (!Object.keys(mappings).length) {
        out = inp;
        return out;
    }
    for (const [k, v] of Object.entries(inp)) {
        const j = mappings[k];
        if (j === null) {
            continue;
        }
        out[j !== null && j !== void 0 ? j : k] = v;
    }
    return out;
}
exports.remap = remap;
//# sourceMappingURL=primitives.js.map