"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectExtraKeys = exports.safeParse = exports.parse = void 0;
const zod_1 = require("zod");
const sdkvalidationerror_js_1 = require("../sdk/models/errors/sdkvalidationerror.js");
const fp_js_1 = require("../sdk/types/fp.js");
/**
 * Utility function that executes some code which may throw a ZodError. It
 * intercepts this error and converts it to an SDKValidationError so as to not
 * leak Zod implementation details to user code.
 */
function parse(rawValue, fn, errorMessage) {
    try {
        return fn(rawValue);
    }
    catch (err) {
        if (err instanceof zod_1.ZodError) {
            throw new sdkvalidationerror_js_1.SDKValidationError(errorMessage, err, rawValue);
        }
        throw err;
    }
}
exports.parse = parse;
/**
 * Utility function that executes some code which may result in a ZodError. It
 * intercepts this error and converts it to an SDKValidationError so as to not
 * leak Zod implementation details to user code.
 */
function safeParse(rawValue, fn, errorMessage) {
    try {
        return (0, fp_js_1.OK)(fn(rawValue));
    }
    catch (err) {
        return (0, fp_js_1.ERR)(new sdkvalidationerror_js_1.SDKValidationError(errorMessage, err, rawValue));
    }
}
exports.safeParse = safeParse;
function collectExtraKeys(obj, extrasKey) {
    return obj.transform((val) => {
        const extras = {};
        const { shape } = obj;
        for (const [key] of Object.entries(val)) {
            if (key in shape) {
                continue;
            }
            const v = val[key];
            if (typeof v === "undefined") {
                continue;
            }
            extras[key] = v;
            delete val[key];
        }
        return { ...val, [extrasKey]: extras };
    });
}
exports.collectExtraKeys = collectExtraKeys;
//# sourceMappingURL=schemas.js.map