"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientSDK = void 0;
const http_js_1 = require("./http.js");
const retries_js_1 = require("./retries.js");
const encodings_js_1 = require("./encodings.js");
const base64_js_1 = require("./base64.js");
const config_js_1 = require("./config.js");
const hooks_js_1 = require("../hooks/hooks.js");
const httpclienterrors_js_1 = require("../sdk/models/errors/httpclienterrors.js");
const fp_js_1 = require("../sdk/types/fp.js");
const gt = typeof globalThis === "undefined" ? null : globalThis;
const webWorkerLike = typeof gt === "object" &&
    gt != null &&
    "importScripts" in gt &&
    typeof gt["importScripts"] === "function";
const isBrowserLike = webWorkerLike ||
    (typeof navigator !== "undefined" && "serviceWorker" in navigator) ||
    (typeof window === "object" && typeof window.document !== "undefined");
class ClientSDK {
    constructor(options = {}) {
        const opt = options;
        if (typeof opt === "object" &&
            opt != null &&
            "hooks" in opt &&
            opt.hooks instanceof hooks_js_1.SDKHooks) {
            this.hooks$ = opt.hooks;
        }
        else {
            this.hooks$ = new hooks_js_1.SDKHooks();
        }
        this.options$ = { ...options, hooks: this.hooks$ };
        const url = (0, config_js_1.serverURLFromOptions)(options);
        if (url) {
            url.pathname = url.pathname.replace(/\/+$/, "") + "/";
        }
        const { baseURL, client } = this.hooks$.sdkInit({
            baseURL: url,
            client: options.httpClient || new http_js_1.HTTPClient(),
        });
        this.baseURL = baseURL;
        this.httpClient = client;
        this.logger = options.debugLogger;
    }
    createRequest$(context, conf, options) {
        var _a, _b, _c, _d;
        const { method, path, query, headers: opHeaders, security } = conf;
        const base = (_a = conf.baseURL) !== null && _a !== void 0 ? _a : this.baseURL;
        if (!base) {
            return (0, fp_js_1.ERR)(new httpclienterrors_js_1.InvalidRequestError("No base URL provided for operation"));
        }
        const reqURL = new URL(base);
        const inputURL = new URL(path, reqURL);
        if (path) {
            reqURL.pathname += inputURL.pathname.replace(/^\/+/, "");
        }
        let finalQuery = query || "";
        const secQuery = [];
        for (const [k, v] of Object.entries((security === null || security === void 0 ? void 0 : security.queryParams) || {})) {
            secQuery.push((0, encodings_js_1.encodeForm)(k, v, { charEncoding: "percent" }));
        }
        if (secQuery.length) {
            finalQuery += `&${secQuery.join("&")}`;
        }
        if (finalQuery) {
            const q = finalQuery.startsWith("&") ? finalQuery.slice(1) : finalQuery;
            reqURL.search = `?${q}`;
        }
        const headers = new Headers(opHeaders);
        const username = security === null || security === void 0 ? void 0 : security.basic.username;
        const password = security === null || security === void 0 ? void 0 : security.basic.password;
        if (username != null || password != null) {
            const encoded = (0, base64_js_1.stringToBase64)([username || "", password || ""].join(":"));
            headers.set("Authorization", `Basic ${encoded}`);
        }
        const securityHeaders = new Headers((security === null || security === void 0 ? void 0 : security.headers) || {});
        for (const [k, v] of securityHeaders) {
            headers.set(k, v);
        }
        let cookie = headers.get("cookie") || "";
        for (const [k, v] of Object.entries((security === null || security === void 0 ? void 0 : security.cookies) || {})) {
            cookie += `; ${k}=${v}`;
        }
        cookie = cookie.startsWith("; ") ? cookie.slice(2) : cookie;
        headers.set("cookie", cookie);
        const userHeaders = new Headers((_b = options === null || options === void 0 ? void 0 : options.fetchOptions) === null || _b === void 0 ? void 0 : _b.headers);
        for (const [k, v] of userHeaders) {
            headers.set(k, v);
        }
        // Only set user agent header in non-browser-like environments since CORS
        // policy disallows setting it in browsers e.g. Chrome throws an error.
        if (!isBrowserLike) {
            headers.set((_c = conf.uaHeader) !== null && _c !== void 0 ? _c : "user-agent", config_js_1.SDK_METADATA.userAgent);
        }
        let fetchOptions = options === null || options === void 0 ? void 0 : options.fetchOptions;
        if (!(fetchOptions === null || fetchOptions === void 0 ? void 0 : fetchOptions.signal) && conf.timeoutMs && conf.timeoutMs > 0) {
            const timeoutSignal = AbortSignal.timeout(conf.timeoutMs);
            if (!fetchOptions) {
                fetchOptions = { signal: timeoutSignal };
            }
            else {
                fetchOptions.signal = timeoutSignal;
            }
        }
        if (conf.body instanceof ReadableStream) {
            if (!fetchOptions) {
                fetchOptions = {
                    // @ts-expect-error see https://github.com/node-fetch/node-fetch/issues/1769
                    duplex: "half",
                };
            }
            else {
                // @ts-expect-error see https://github.com/node-fetch/node-fetch/issues/1769
                fetchOptions.duplex = "half";
            }
        }
        let input;
        try {
            input = this.hooks$.beforeCreateRequest(context, {
                url: reqURL,
                options: {
                    ...fetchOptions,
                    body: (_d = conf.body) !== null && _d !== void 0 ? _d : null,
                    headers,
                    method,
                },
            });
        }
        catch (err) {
            return (0, fp_js_1.ERR)(new httpclienterrors_js_1.UnexpectedClientError("Create request hook failed to execute", { cause: err }));
        }
        return (0, fp_js_1.OK)(new Request(input.url, input.options));
    }
    async do$(request, options) {
        const { context, errorCodes } = options;
        const retryConfig = options.retryConfig || { strategy: "none" };
        const retryCodes = options.retryCodes || [];
        return (0, retries_js_1.retry)(async () => {
            const req = await this.hooks$.beforeRequest(context, request.clone());
            await logRequest(this.logger, req).catch((e) => { var _a; return (_a = this.logger) === null || _a === void 0 ? void 0 : _a.log("Failed to log request:", e); });
            let response = await this.httpClient.request(req);
            if ((0, http_js_1.matchStatusCode)(response, errorCodes)) {
                const result = await this.hooks$.afterError(context, response, null);
                if (result.error) {
                    throw result.error;
                }
                response = result.response || response;
            }
            else {
                response = await this.hooks$.afterSuccess(context, response);
            }
            await logResponse(this.logger, response, req).catch((e) => { var _a; return (_a = this.logger) === null || _a === void 0 ? void 0 : _a.log("Failed to log response:", e); });
            return response;
        }, { config: retryConfig, statusCodes: retryCodes }).then((r) => (0, fp_js_1.OK)(r), (err) => {
            switch (true) {
                case (0, http_js_1.isAbortError)(err):
                    return (0, fp_js_1.ERR)(new httpclienterrors_js_1.RequestAbortedError("Request aborted by client", { cause: err }));
                case (0, http_js_1.isTimeoutError)(err):
                    return (0, fp_js_1.ERR)(new httpclienterrors_js_1.RequestTimeoutError("Request timed out", { cause: err }));
                case (0, http_js_1.isConnectionError)(err):
                    return (0, fp_js_1.ERR)(new httpclienterrors_js_1.ConnectionError("Unable to make request", { cause: err }));
                default:
                    return (0, fp_js_1.ERR)(new httpclienterrors_js_1.UnexpectedClientError("Unexpected HTTP client error", {
                        cause: err,
                    }));
            }
        });
    }
}
exports.ClientSDK = ClientSDK;
const jsonLikeContentTypeRE = /^application\/(?:.{0,100}\+)?json/;
async function logRequest(logger, req) {
    if (!logger) {
        return;
    }
    const contentType = req.headers.get("content-type");
    const ct = (contentType === null || contentType === void 0 ? void 0 : contentType.split(";")[0]) || "";
    logger.group(`> Request: ${req.method} ${req.url}`);
    logger.group("Headers:");
    for (const [k, v] of req.headers.entries()) {
        logger.log(`${k}: ${v}`);
    }
    logger.groupEnd();
    logger.group("Body:");
    switch (true) {
        case jsonLikeContentTypeRE.test(ct):
            logger.log(await req.clone().json());
            break;
        case ct.startsWith("text/"):
            logger.log(await req.clone().text());
            break;
        case ct === "multipart/form-data": {
            const body = await req.clone().formData();
            for (const [k, v] of body) {
                const vlabel = v instanceof Blob ? "<Blob>" : v;
                logger.log(`${k}: ${vlabel}`);
            }
            break;
        }
        default:
            logger.log(`<${contentType}>`);
            break;
    }
    logger.groupEnd();
    logger.groupEnd();
}
async function logResponse(logger, res, req) {
    if (!logger) {
        return;
    }
    const contentType = res.headers.get("content-type");
    const ct = (contentType === null || contentType === void 0 ? void 0 : contentType.split(";")[0]) || "";
    logger.group(`< Response: ${req.method} ${req.url}`);
    logger.log("Status Code:", res.status, res.statusText);
    logger.group("Headers:");
    for (const [k, v] of res.headers.entries()) {
        logger.log(`${k}: ${v}`);
    }
    logger.groupEnd();
    logger.group("Body:");
    switch (true) {
        case (0, http_js_1.matchContentType)(res, "application/json") || jsonLikeContentTypeRE.test(ct):
            logger.log(await res.clone().json());
            break;
        case (0, http_js_1.matchContentType)(res, "text/event-stream"):
            logger.log(`<${contentType}>`);
            break;
        case (0, http_js_1.matchContentType)(res, "text/*"):
            logger.log(await res.clone().text());
            break;
        case (0, http_js_1.matchContentType)(res, "multipart/form-data"): {
            const body = await res.clone().formData();
            for (const [k, v] of body) {
                const vlabel = v instanceof Blob ? "<Blob>" : v;
                logger.log(`${k}: ${vlabel}`);
            }
            break;
        }
        default:
            logger.log(`<${contentType}>`);
            break;
    }
    logger.groupEnd();
    logger.groupEnd();
}
//# sourceMappingURL=sdks.js.map