"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractSecurity = exports.resolveGlobalSecurity = exports.resolveSecurity = exports.SecurityError = exports.SecurityErrorCode = void 0;
var SecurityErrorCode;
(function (SecurityErrorCode) {
    SecurityErrorCode["Incomplete"] = "incomplete";
    SecurityErrorCode["UnrecognisedSecurityType"] = "unrecognized_security_type";
})(SecurityErrorCode || (exports.SecurityErrorCode = SecurityErrorCode = {}));
class SecurityError extends Error {
    constructor(code, message) {
        super(message);
        this.code = code;
        this.name = "SecurityError";
    }
    static incomplete() {
        return new SecurityError(SecurityErrorCode.Incomplete, "Security requirements not met in order to perform the operation");
    }
    static unrecognizedType(type) {
        return new SecurityError(SecurityErrorCode.UnrecognisedSecurityType, `Unrecognised security type: ${type}`);
    }
}
exports.SecurityError = SecurityError;
function resolveSecurity(...options) {
    const state = {
        basic: { username: "", password: "" },
        headers: {},
        queryParams: {},
        cookies: {},
    };
    const option = options.find((opts) => {
        return opts.every((o) => {
            if (o.value == null) {
                return false;
            }
            else if (o.type === "http:basic") {
                return o.value.username != null || o.value.password != null;
            }
            else if (o.type === "http:custom") {
                return null;
            }
            else if (typeof o.value === "string") {
                return !!o.value;
            }
            else {
                throw new Error(`Unrecognized security type: ${o.type} (value type: ${typeof o.value})`);
            }
        });
    });
    if (option == null) {
        return null;
    }
    option.forEach((spec) => {
        if (spec.value == null) {
            return;
        }
        const { type } = spec;
        switch (type) {
            case "apiKey:header":
                state.headers[spec.fieldName] = spec.value;
                break;
            case "apiKey:query":
                state.queryParams[spec.fieldName] = spec.value;
                break;
            case "apiKey:cookie":
                state.cookies[spec.fieldName] = spec.value;
                break;
            case "http:basic":
                applyBasic(state, spec);
                break;
            case "http:custom":
                break;
            case "http:bearer":
                applyBearer(state, spec);
                break;
            case "oauth2":
                applyBearer(state, spec);
                break;
            case "oauth2:client_credentials":
                break;
            case "openIdConnect":
                applyBearer(state, spec);
                break;
            default:
                spec;
                throw SecurityError.unrecognizedType(type);
        }
    });
    return state;
}
exports.resolveSecurity = resolveSecurity;
function applyBasic(state, spec) {
    if (spec.value == null) {
        return;
    }
    state.basic = spec.value;
}
function applyBearer(state, spec) {
    if (spec.value == null) {
        return;
    }
    let value = spec.value;
    if (value.slice(0, 7).toLowerCase() !== "bearer ") {
        value = `Bearer ${value}`;
    }
    state.headers[spec.fieldName] = value;
}
function resolveGlobalSecurity(security) {
    return resolveSecurity([
        {
            fieldName: "unstructured-api-key",
            type: "apiKey:header",
            value: security === null || security === void 0 ? void 0 : security.apiKeyAuth,
        },
    ]);
}
exports.resolveGlobalSecurity = resolveGlobalSecurity;
async function extractSecurity(sec) {
    if (sec == null) {
        return;
    }
    return typeof sec === "function" ? sec() : sec;
}
exports.extractSecurity = extractSecurity;
//# sourceMappingURL=security.js.map