"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartitionParameters$ = exports.PartitionParameters$outboundSchema = exports.PartitionParameters$inboundSchema = exports.Strategy$ = exports.Strategy$outboundSchema = exports.Strategy$inboundSchema = exports.OutputFormat$ = exports.OutputFormat$outboundSchema = exports.OutputFormat$inboundSchema = exports.Files$ = exports.Files$outboundSchema = exports.Files$inboundSchema = exports.ChunkingStrategy$ = exports.ChunkingStrategy$outboundSchema = exports.ChunkingStrategy$inboundSchema = exports.Strategy = exports.OutputFormat = exports.ChunkingStrategy = void 0;
const primitives_js_1 = require("../../../lib/primitives.js");
const blobs_js_1 = require("../../types/blobs.js");
const enums_js_1 = require("../../types/enums.js");
const z = __importStar(require("zod"));
var ChunkingStrategy;
(function (ChunkingStrategy) {
    ChunkingStrategy["Basic"] = "basic";
    ChunkingStrategy["ByPage"] = "by_page";
    ChunkingStrategy["BySimilarity"] = "by_similarity";
    ChunkingStrategy["ByTitle"] = "by_title";
})(ChunkingStrategy || (exports.ChunkingStrategy = ChunkingStrategy = {}));
/**
 * The format of the response. Supported formats are application/json and text/csv. Default: application/json.
 */
var OutputFormat;
(function (OutputFormat) {
    OutputFormat["ApplicationJson"] = "application/json";
    OutputFormat["TextCsv"] = "text/csv";
})(OutputFormat || (exports.OutputFormat = OutputFormat = {}));
/**
 * The strategy to use for partitioning PDF/image. Options are fast, hi_res, auto. Default: hi_res
 */
var Strategy;
(function (Strategy) {
    Strategy["Fast"] = "fast";
    Strategy["HiRes"] = "hi_res";
    Strategy["Auto"] = "auto";
    Strategy["OcrOnly"] = "ocr_only";
})(Strategy || (exports.Strategy = Strategy = {}));
/** @internal */
exports.ChunkingStrategy$inboundSchema = z.union([z.nativeEnum(ChunkingStrategy), z.string().transform(enums_js_1.catchUnrecognizedEnum)]);
/** @internal */
exports.ChunkingStrategy$outboundSchema = z.union([z.nativeEnum(ChunkingStrategy), z.string().and(z.custom())]);
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var ChunkingStrategy$;
(function (ChunkingStrategy$) {
    /** @deprecated use `ChunkingStrategy$inboundSchema` instead. */
    ChunkingStrategy$.inboundSchema = exports.ChunkingStrategy$inboundSchema;
    /** @deprecated use `ChunkingStrategy$outboundSchema` instead. */
    ChunkingStrategy$.outboundSchema = exports.ChunkingStrategy$outboundSchema;
})(ChunkingStrategy$ || (exports.ChunkingStrategy$ = ChunkingStrategy$ = {}));
/** @internal */
exports.Files$inboundSchema = z.object({
    content: z.union([
        z.instanceof((ReadableStream)),
        z.instanceof(Blob),
        z.instanceof(ArrayBuffer),
        z.instanceof(Buffer),
    ]),
    fileName: z.string(),
});
/** @internal */
exports.Files$outboundSchema = z.object({
    content: z.union([
        z.instanceof((ReadableStream)),
        z.instanceof(Blob),
        z.instanceof(ArrayBuffer),
        z.instanceof(Buffer),
    ]),
    fileName: z.string(),
});
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var Files$;
(function (Files$) {
    /** @deprecated use `Files$inboundSchema` instead. */
    Files$.inboundSchema = exports.Files$inboundSchema;
    /** @deprecated use `Files$outboundSchema` instead. */
    Files$.outboundSchema = exports.Files$outboundSchema;
})(Files$ || (exports.Files$ = Files$ = {}));
/** @internal */
exports.OutputFormat$inboundSchema = z.union([z.nativeEnum(OutputFormat), z.string().transform(enums_js_1.catchUnrecognizedEnum)]);
/** @internal */
exports.OutputFormat$outboundSchema = z.union([z.nativeEnum(OutputFormat), z.string().and(z.custom())]);
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var OutputFormat$;
(function (OutputFormat$) {
    /** @deprecated use `OutputFormat$inboundSchema` instead. */
    OutputFormat$.inboundSchema = exports.OutputFormat$inboundSchema;
    /** @deprecated use `OutputFormat$outboundSchema` instead. */
    OutputFormat$.outboundSchema = exports.OutputFormat$outboundSchema;
})(OutputFormat$ || (exports.OutputFormat$ = OutputFormat$ = {}));
/** @internal */
exports.Strategy$inboundSchema = z.union([
    z.nativeEnum(Strategy),
    z.string().transform(enums_js_1.catchUnrecognizedEnum),
]);
/** @internal */
exports.Strategy$outboundSchema = z.union([z.nativeEnum(Strategy), z.string().and(z.custom())]);
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var Strategy$;
(function (Strategy$) {
    /** @deprecated use `Strategy$inboundSchema` instead. */
    Strategy$.inboundSchema = exports.Strategy$inboundSchema;
    /** @deprecated use `Strategy$outboundSchema` instead. */
    Strategy$.outboundSchema = exports.Strategy$outboundSchema;
})(Strategy$ || (exports.Strategy$ = Strategy$ = {}));
/** @internal */
exports.PartitionParameters$inboundSchema = z
    .object({
    files: z.lazy(() => exports.Files$inboundSchema),
    chunking_strategy: z.nullable(exports.ChunkingStrategy$inboundSchema).optional(),
    combine_under_n_chars: z.nullable(z.number().int()).optional(),
    content_type: z.nullable(z.string()).optional(),
    coordinates: z.boolean().default(false),
    encoding: z.nullable(z.string()).optional(),
    extract_image_block_types: z.array(z.string()).optional(),
    gz_uncompressed_content_type: z.nullable(z.string()).optional(),
    hi_res_model_name: z.nullable(z.string()).optional(),
    include_orig_elements: z.nullable(z.boolean()).optional(),
    include_page_breaks: z.boolean().default(false),
    include_slide_notes: z.boolean().default(true),
    languages: z.array(z.string()).optional(),
    max_characters: z.nullable(z.number().int()).optional(),
    multipage_sections: z.boolean().default(true),
    new_after_n_chars: z.nullable(z.number().int()).optional(),
    ocr_languages: z.array(z.string()).optional(),
    output_format: exports.OutputFormat$inboundSchema.default(OutputFormat.ApplicationJson),
    overlap: z.number().int().default(0),
    overlap_all: z.boolean().default(false),
    pdf_infer_table_structure: z.boolean().default(true),
    similarity_threshold: z.nullable(z.number()).optional(),
    skip_infer_table_types: z.array(z.string()).optional(),
    split_pdf_allow_failed: z.boolean().default(false),
    split_pdf_concurrency_level: z.number().int().default(5),
    split_pdf_page: z.boolean().default(true),
    split_pdf_page_range: z.array(z.number().int()).optional(),
    starting_page_number: z.nullable(z.number().int()).optional(),
    strategy: exports.Strategy$inboundSchema.default(Strategy.HiRes),
    unique_element_ids: z.boolean().default(false),
    xml_keep_tags: z.boolean().default(false),
})
    .transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        chunking_strategy: "chunkingStrategy",
        combine_under_n_chars: "combineUnderNChars",
        content_type: "contentType",
        extract_image_block_types: "extractImageBlockTypes",
        gz_uncompressed_content_type: "gzUncompressedContentType",
        hi_res_model_name: "hiResModelName",
        include_orig_elements: "includeOrigElements",
        include_page_breaks: "includePageBreaks",
        include_slide_notes: "includeSlideNotes",
        max_characters: "maxCharacters",
        multipage_sections: "multipageSections",
        new_after_n_chars: "newAfterNChars",
        ocr_languages: "ocrLanguages",
        output_format: "outputFormat",
        overlap_all: "overlapAll",
        pdf_infer_table_structure: "pdfInferTableStructure",
        similarity_threshold: "similarityThreshold",
        skip_infer_table_types: "skipInferTableTypes",
        split_pdf_allow_failed: "splitPdfAllowFailed",
        split_pdf_concurrency_level: "splitPdfConcurrencyLevel",
        split_pdf_page: "splitPdfPage",
        split_pdf_page_range: "splitPdfPageRange",
        starting_page_number: "startingPageNumber",
        unique_element_ids: "uniqueElementIds",
        xml_keep_tags: "xmlKeepTags",
    });
});
/** @internal */
exports.PartitionParameters$outboundSchema = z
    .object({
    files: z.lazy(() => exports.Files$outboundSchema).or(blobs_js_1.blobLikeSchema),
    chunkingStrategy: z.nullable(exports.ChunkingStrategy$outboundSchema).optional(),
    combineUnderNChars: z.nullable(z.number().int()).optional(),
    contentType: z.nullable(z.string()).optional(),
    coordinates: z.boolean().default(false),
    encoding: z.nullable(z.string()).optional(),
    extractImageBlockTypes: z.array(z.string()).optional(),
    gzUncompressedContentType: z.nullable(z.string()).optional(),
    hiResModelName: z.nullable(z.string()).optional(),
    includeOrigElements: z.nullable(z.boolean()).optional(),
    includePageBreaks: z.boolean().default(false),
    includeSlideNotes: z.boolean().default(true),
    languages: z.array(z.string()).optional(),
    maxCharacters: z.nullable(z.number().int()).optional(),
    multipageSections: z.boolean().default(true),
    newAfterNChars: z.nullable(z.number().int()).optional(),
    ocrLanguages: z.array(z.string()).optional(),
    outputFormat: exports.OutputFormat$outboundSchema.default(OutputFormat.ApplicationJson),
    overlap: z.number().int().default(0),
    overlapAll: z.boolean().default(false),
    pdfInferTableStructure: z.boolean().default(true),
    similarityThreshold: z.nullable(z.number()).optional(),
    skipInferTableTypes: z.array(z.string()).optional(),
    splitPdfAllowFailed: z.boolean().default(false),
    splitPdfConcurrencyLevel: z.number().int().default(5),
    splitPdfPage: z.boolean().default(true),
    splitPdfPageRange: z.array(z.number().int()).optional(),
    startingPageNumber: z.nullable(z.number().int()).optional(),
    strategy: exports.Strategy$outboundSchema.default(Strategy.HiRes),
    uniqueElementIds: z.boolean().default(false),
    xmlKeepTags: z.boolean().default(false),
})
    .transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        chunkingStrategy: "chunking_strategy",
        combineUnderNChars: "combine_under_n_chars",
        contentType: "content_type",
        extractImageBlockTypes: "extract_image_block_types",
        gzUncompressedContentType: "gz_uncompressed_content_type",
        hiResModelName: "hi_res_model_name",
        includeOrigElements: "include_orig_elements",
        includePageBreaks: "include_page_breaks",
        includeSlideNotes: "include_slide_notes",
        maxCharacters: "max_characters",
        multipageSections: "multipage_sections",
        newAfterNChars: "new_after_n_chars",
        ocrLanguages: "ocr_languages",
        outputFormat: "output_format",
        overlapAll: "overlap_all",
        pdfInferTableStructure: "pdf_infer_table_structure",
        similarityThreshold: "similarity_threshold",
        skipInferTableTypes: "skip_infer_table_types",
        splitPdfAllowFailed: "split_pdf_allow_failed",
        splitPdfConcurrencyLevel: "split_pdf_concurrency_level",
        splitPdfPage: "split_pdf_page",
        splitPdfPageRange: "split_pdf_page_range",
        startingPageNumber: "starting_page_number",
        uniqueElementIds: "unique_element_ids",
        xmlKeepTags: "xml_keep_tags",
    });
});
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var PartitionParameters$;
(function (PartitionParameters$) {
    /** @deprecated use `PartitionParameters$inboundSchema` instead. */
    PartitionParameters$.inboundSchema = exports.PartitionParameters$inboundSchema;
    /** @deprecated use `PartitionParameters$outboundSchema` instead. */
    PartitionParameters$.outboundSchema = exports.PartitionParameters$outboundSchema;
})(PartitionParameters$ || (exports.PartitionParameters$ = PartitionParameters$ = {}));
//# sourceMappingURL=partitionparameters.js.map