/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as shared from "../shared/index.js";
import * as z from "zod";

export type Detail = Array<shared.ValidationError> | string;

export type HTTPValidationErrorData = {
    detail?: Array<shared.ValidationError> | string | undefined;
};

export class HTTPValidationError extends Error {
    detail?: Array<shared.ValidationError> | string | undefined;

    /** The original data that was passed to this error instance. */
    data$: HTTPValidationErrorData;

    constructor(err: HTTPValidationErrorData) {
        const message =
            "message" in err && typeof err.message === "string"
                ? err.message
                : `API error occurred: ${JSON.stringify(err)}`;
        super(message);
        this.data$ = err;

        if (err.detail != null) {
            this.detail = err.detail;
        }

        this.name = "HTTPValidationError";
    }
}

/** @internal */
export const Detail$inboundSchema: z.ZodType<Detail, z.ZodTypeDef, unknown> = z.union([
    z.array(shared.ValidationError$inboundSchema),
    z.string(),
]);

/** @internal */
export type Detail$Outbound = Array<shared.ValidationError$Outbound> | string;

/** @internal */
export const Detail$outboundSchema: z.ZodType<Detail$Outbound, z.ZodTypeDef, Detail> = z.union([
    z.array(shared.ValidationError$outboundSchema),
    z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Detail$ {
    /** @deprecated use `Detail$inboundSchema` instead. */
    export const inboundSchema = Detail$inboundSchema;
    /** @deprecated use `Detail$outboundSchema` instead. */
    export const outboundSchema = Detail$outboundSchema;
    /** @deprecated use `Detail$Outbound` instead. */
    export type Outbound = Detail$Outbound;
}

/** @internal */
export const HTTPValidationError$inboundSchema: z.ZodType<
    HTTPValidationError,
    z.ZodTypeDef,
    unknown
> = z
    .object({
        detail: z.union([z.array(shared.ValidationError$inboundSchema), z.string()]).optional(),
    })
    .transform((v) => {
        return new HTTPValidationError(v);
    });

/** @internal */
export type HTTPValidationError$Outbound = {
    detail?: Array<shared.ValidationError$Outbound> | string | undefined;
};

/** @internal */
export const HTTPValidationError$outboundSchema: z.ZodType<
    HTTPValidationError$Outbound,
    z.ZodTypeDef,
    HTTPValidationError
> = z
    .instanceof(HTTPValidationError)
    .transform((v) => v.data$)
    .pipe(
        z.object({
            detail: z
                .union([z.array(shared.ValidationError$outboundSchema), z.string()])
                .optional(),
        })
    );

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace HTTPValidationError$ {
    /** @deprecated use `HTTPValidationError$inboundSchema` instead. */
    export const inboundSchema = HTTPValidationError$inboundSchema;
    /** @deprecated use `HTTPValidationError$outboundSchema` instead. */
    export const outboundSchema = HTTPValidationError$outboundSchema;
    /** @deprecated use `HTTPValidationError$Outbound` instead. */
    export type Outbound = HTTPValidationError$Outbound;
}
