/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { remap as remap$ } from "../../../lib/primitives.js";
import * as shared from "../shared/index.js";
import * as z from "zod";

export type PartitionRequest = {
    partitionParameters: shared.PartitionParameters;
    unstructuredApiKey?: string | null | undefined;
};

export type PartitionResponse = {
    /**
     * HTTP response content type for this operation
     */
    contentType: string;
    /**
     * Successful Response
     */
    elements?: Array<{ [k: string]: any }> | undefined;
    /**
     * HTTP response status code for this operation
     */
    statusCode: number;
    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    rawResponse: Response;
};

/** @internal */
export const PartitionRequest$inboundSchema: z.ZodType<PartitionRequest, z.ZodTypeDef, unknown> = z
    .object({
        partition_parameters: shared.PartitionParameters$inboundSchema,
        "unstructured-api-key": z.nullable(z.string()).optional(),
    })
    .transform((v) => {
        return remap$(v, {
            partition_parameters: "partitionParameters",
            "unstructured-api-key": "unstructuredApiKey",
        });
    });

/** @internal */
export type PartitionRequest$Outbound = {
    partition_parameters: shared.PartitionParameters$Outbound;
    "unstructured-api-key"?: string | null | undefined;
};

/** @internal */
export const PartitionRequest$outboundSchema: z.ZodType<
    PartitionRequest$Outbound,
    z.ZodTypeDef,
    PartitionRequest
> = z
    .object({
        partitionParameters: shared.PartitionParameters$outboundSchema,
        unstructuredApiKey: z.nullable(z.string()).optional(),
    })
    .transform((v) => {
        return remap$(v, {
            partitionParameters: "partition_parameters",
            unstructuredApiKey: "unstructured-api-key",
        });
    });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PartitionRequest$ {
    /** @deprecated use `PartitionRequest$inboundSchema` instead. */
    export const inboundSchema = PartitionRequest$inboundSchema;
    /** @deprecated use `PartitionRequest$outboundSchema` instead. */
    export const outboundSchema = PartitionRequest$outboundSchema;
    /** @deprecated use `PartitionRequest$Outbound` instead. */
    export type Outbound = PartitionRequest$Outbound;
}

/** @internal */
export const PartitionResponse$inboundSchema: z.ZodType<PartitionResponse, z.ZodTypeDef, unknown> =
    z
        .object({
            ContentType: z.string(),
            Elements: z.array(z.record(z.any())).optional(),
            StatusCode: z.number().int(),
            RawResponse: z.instanceof(Response),
        })
        .transform((v) => {
            return remap$(v, {
                ContentType: "contentType",
                Elements: "elements",
                StatusCode: "statusCode",
                RawResponse: "rawResponse",
            });
        });

/** @internal */
export type PartitionResponse$Outbound = {
    ContentType: string;
    Elements?: Array<{ [k: string]: any }> | undefined;
    StatusCode: number;
    RawResponse: never;
};

/** @internal */
export const PartitionResponse$outboundSchema: z.ZodType<
    PartitionResponse$Outbound,
    z.ZodTypeDef,
    PartitionResponse
> = z
    .object({
        contentType: z.string(),
        elements: z.array(z.record(z.any())).optional(),
        statusCode: z.number().int(),
        rawResponse: z.instanceof(Response).transform(() => {
            throw new Error("Response cannot be serialized");
        }),
    })
    .transform((v) => {
        return remap$(v, {
            contentType: "ContentType",
            elements: "Elements",
            statusCode: "StatusCode",
            rawResponse: "RawResponse",
        });
    });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PartitionResponse$ {
    /** @deprecated use `PartitionResponse$inboundSchema` instead. */
    export const inboundSchema = PartitionResponse$inboundSchema;
    /** @deprecated use `PartitionResponse$outboundSchema` instead. */
    export const outboundSchema = PartitionResponse$outboundSchema;
    /** @deprecated use `PartitionResponse$Outbound` instead. */
    export type Outbound = PartitionResponse$Outbound;
}
