"use strict";
/* eslint-disable */
/* tslint:disable */
/*
 * ---------------------------------------------------------------
 * ## THIS FILE WAS GENERATED VIA SWAGGER-TYPESCRIPT-API        ##
 * ##                                                           ##
 * ## AUTHOR: acacode                                           ##
 * ## SOURCE: https://github.com/acacode/swagger-typescript-api ##
 * ---------------------------------------------------------------
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = exports.HttpClient = exports.ContentType = exports.ButtonActionsType = exports.IntegrationsType = exports.ViewAggregationEnumV3Type = exports.BaseRolesV3Type = exports.WorkspaceRolesV3Type = void 0;
/**
 * Workspace roles for the user.
 */
var WorkspaceRolesV3Type;
(function (WorkspaceRolesV3Type) {
    WorkspaceRolesV3Type["WorkspaceLevelOwner"] = "workspace-level-owner";
    WorkspaceRolesV3Type["WorkspaceLevelCreator"] = "workspace-level-creator";
    WorkspaceRolesV3Type["WorkspaceLevelEditor"] = "workspace-level-editor";
    WorkspaceRolesV3Type["WorkspaceLevelViewer"] = "workspace-level-viewer";
    WorkspaceRolesV3Type["WorkspaceLevelCommenter"] = "workspace-level-commenter";
    WorkspaceRolesV3Type["WorkspaceLevelNoAccess"] = "workspace-level-no-access";
})(WorkspaceRolesV3Type || (exports.WorkspaceRolesV3Type = WorkspaceRolesV3Type = {}));
/**
 * Base roles for the user.
 */
var BaseRolesV3Type;
(function (BaseRolesV3Type) {
    BaseRolesV3Type["Owner"] = "owner";
    BaseRolesV3Type["Creator"] = "creator";
    BaseRolesV3Type["Editor"] = "editor";
    BaseRolesV3Type["Viewer"] = "viewer";
    BaseRolesV3Type["Commenter"] = "commenter";
    BaseRolesV3Type["NoAccess"] = "no-access";
})(BaseRolesV3Type || (exports.BaseRolesV3Type = BaseRolesV3Type = {}));
var ViewAggregationEnumV3Type;
(function (ViewAggregationEnumV3Type) {
    ViewAggregationEnumV3Type["Sum"] = "sum";
    ViewAggregationEnumV3Type["Min"] = "min";
    ViewAggregationEnumV3Type["Max"] = "max";
    ViewAggregationEnumV3Type["Avg"] = "avg";
    ViewAggregationEnumV3Type["Median"] = "median";
    ViewAggregationEnumV3Type["StdDev"] = "std_dev";
    ViewAggregationEnumV3Type["Range"] = "range";
    ViewAggregationEnumV3Type["Count"] = "count";
    ViewAggregationEnumV3Type["CountEmpty"] = "count_empty";
    ViewAggregationEnumV3Type["CountFilled"] = "count_filled";
    ViewAggregationEnumV3Type["CountUnique"] = "count_unique";
    ViewAggregationEnumV3Type["PercentEmpty"] = "percent_empty";
    ViewAggregationEnumV3Type["PercentFilled"] = "percent_filled";
    ViewAggregationEnumV3Type["PercentUnique"] = "percent_unique";
    ViewAggregationEnumV3Type["None"] = "none";
    ViewAggregationEnumV3Type["AttachmentSize"] = "attachment_size";
    ViewAggregationEnumV3Type["Checked"] = "checked";
    ViewAggregationEnumV3Type["Unchecked"] = "unchecked";
    ViewAggregationEnumV3Type["PercentChecked"] = "percent_checked";
    ViewAggregationEnumV3Type["PercentUnchecked"] = "percent_unchecked";
    ViewAggregationEnumV3Type["EarliestDate"] = "earliest_date";
    ViewAggregationEnumV3Type["LatestDate"] = "latest_date";
    ViewAggregationEnumV3Type["DateRange"] = "date_range";
    ViewAggregationEnumV3Type["MonthRange"] = "month_range";
})(ViewAggregationEnumV3Type || (exports.ViewAggregationEnumV3Type = ViewAggregationEnumV3Type = {}));
/**
 * Integration Type
 */
var IntegrationsType;
(function (IntegrationsType) {
    IntegrationsType["Database"] = "database";
    IntegrationsType["Ai"] = "ai";
    IntegrationsType["Auth"] = "auth";
    IntegrationsType["Sync"] = "sync";
    IntegrationsType["Communication"] = "communication";
    IntegrationsType["SpreadSheet"] = "spread-sheet";
    IntegrationsType["ProjectManagement"] = "project-management";
    IntegrationsType["Crm"] = "crm";
    IntegrationsType["Marketing"] = "marketing";
    IntegrationsType["Ats"] = "ats";
    IntegrationsType["Development"] = "development";
    IntegrationsType["Finance"] = "finance";
    IntegrationsType["Ticketing"] = "ticketing";
    IntegrationsType["Storage"] = "storage";
    IntegrationsType["Others"] = "others";
    IntegrationsType["WorkflowNode"] = "workflow-node";
})(IntegrationsType || (exports.IntegrationsType = IntegrationsType = {}));
var ButtonActionsType;
(function (ButtonActionsType) {
    ButtonActionsType["Webhook"] = "webhook";
    ButtonActionsType["Url"] = "url";
    ButtonActionsType["Ai"] = "ai";
    ButtonActionsType["Script"] = "script";
})(ButtonActionsType || (exports.ButtonActionsType = ButtonActionsType = {}));
const axios_1 = __importDefault(require("axios"));
var ContentType;
(function (ContentType) {
    ContentType["Json"] = "application/json";
    ContentType["FormData"] = "multipart/form-data";
    ContentType["UrlEncoded"] = "application/x-www-form-urlencoded";
    ContentType["Text"] = "text/plain";
})(ContentType || (exports.ContentType = ContentType = {}));
class HttpClient {
    constructor(_a = {}) {
        var { securityWorker, secure, format } = _a, axiosConfig = __rest(_a, ["securityWorker", "secure", "format"]);
        this.securityData = null;
        this.setSecurityData = (data) => {
            this.securityData = data;
        };
        this.request = async (_a) => {
            var { secure, path, type, query, format, wrapped, body } = _a, params = __rest(_a, ["secure", "path", "type", "query", "format", "wrapped", "body"]);
            const secureParams = ((typeof secure === 'boolean' ? secure : this.secure) &&
                this.securityWorker &&
                (await this.securityWorker(this.securityData))) ||
                {};
            const requestParams = this.mergeRequestParams(params, secureParams);
            const responseFormat = format || this.format || undefined;
            if (type === ContentType.FormData &&
                body &&
                body !== null &&
                typeof body === 'object') {
                body = this.createFormData(body);
            }
            if (type === ContentType.Text &&
                body &&
                body !== null &&
                typeof body !== 'string') {
                body = JSON.stringify(body);
            }
            return this.instance
                .request(Object.assign(Object.assign({}, requestParams), { headers: Object.assign(Object.assign({}, (requestParams.headers || {})), (type && type !== ContentType.FormData
                    ? { 'Content-Type': type }
                    : {})), params: query, responseType: responseFormat, data: body, url: path }))
                .then((response) => {
                if (wrapped)
                    return response;
                return response.data;
            });
        };
        this.instance = axios_1.default.create(Object.assign(Object.assign({}, axiosConfig), { baseURL: axiosConfig.baseURL || 'https://app.nocodb.com' }));
        this.secure = secure;
        this.format = format;
        this.securityWorker = securityWorker;
    }
    mergeRequestParams(params1, params2) {
        const method = params1.method || (params2 && params2.method);
        return Object.assign(Object.assign(Object.assign(Object.assign({}, this.instance.defaults), params1), (params2 || {})), { headers: Object.assign(Object.assign(Object.assign({}, ((method &&
                this.instance.defaults.headers[method.toLowerCase()]) ||
                {})), (params1.headers || {})), ((params2 && params2.headers) || {})) });
    }
    stringifyFormItem(formItem) {
        if (typeof formItem === 'object' && formItem !== null) {
            return JSON.stringify(formItem);
        }
        else {
            return `${formItem}`;
        }
    }
    createFormData(input) {
        return Object.keys(input || {}).reduce((formData, key) => {
            const property = input[key];
            const propertyContent = property instanceof Array ? property : [property];
            for (const formItem of propertyContent) {
                const isFileType = formItem instanceof Blob || formItem instanceof File;
                formData.append(key, isFileType ? formItem : this.stringifyFormItem(formItem));
            }
            return formData;
        }, new FormData());
    }
}
exports.HttpClient = HttpClient;
/**
 * @title nocodb
 * @version 1.0
 * @baseUrl https://app.nocodb.com
 *
 * NocoDB API Documentation
 */
class Api extends HttpClient {
    constructor() {
        super(...arguments);
        this.userProfile = {
            /**
             * @description Update User Profile
             *
             * @tags User profile
             * @name Update
             * @summary Update User Profile
             * @request PATCH:/api/v1/user/profile
             * @response `200` `UserType`
             */
            update: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/user/profile`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
        };
        this.auth = {
            /**
         * @description Create a new user with provided email and password and first user is marked as super admin.
         *
         * @tags Auth
         * @name Signup
         * @summary Signup
         * @request POST:/api/v1/auth/user/signup
         * @response `200` `{
          \**
           * The signed JWT token for information exchange
           * @example eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6IndAbm9jb2RiLmNvbSIsImZpcnN0bmFtZSI6bnVsbCwibGFzdG5hbWUiOm51bGwsImlkIjoidXNfYjN4bzJpNDRueDV5OWwiLCJyb2xlcyI6Im9yZy1sZXZlbC1jcmVhdG9yLHN1cGVyIiwidG9rZW5fdmVyc2lvbiI6ImJmMTc3ZGUzYjk3YjAzMjY4YjU0NGZmMjMzNGU5YjFhMGUzYzgxM2NiYzliOTJkYWMwYmM5NTRiNmUzN2ZjMTJjYmFkNDM2NmIwYzExZTdjIiwiaWF0IjoxNjc4MDc4NDMyLCJleHAiOjE2NzgxMTQ0MzJ9.gzwp_svZlbA5PV_eawYV-9UFjZVjniy-tCDce16xrkI
           *\
          token?: string,
        
        }` OK
         * @response `400` `{
          msg?: string,
        
        }` Bad Request
         */
            signup: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/user/signup`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Clear refresh token from the database and cookie.
         *
         * @tags Auth
         * @name Signout
         * @summary Signout
         * @request POST:/api/v1/auth/user/signout
         * @response `200` `{
          \**
           * Success Message
           * @example Signed out successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            signout: (params = {}) => this.request(Object.assign({ path: `/api/v1/auth/user/signout`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Authenticate existing user with their email and password. Successful login will return a JWT access-token.
         *
         * @tags Auth
         * @name Signin
         * @summary Signin
         * @request POST:/api/v1/auth/user/signin
         * @response `200` `{
          \**
           * The signed JWT token for information exchange
           * @example eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6IndAbm9jb2RiLmNvbSIsImZpcnN0bmFtZSI6bnVsbCwibGFzdG5hbWUiOm51bGwsImlkIjoidXNfYjN4bzJpNDRueDV5OWwiLCJyb2xlcyI6Im9yZy1sZXZlbC1jcmVhdG9yLHN1cGVyIiwidG9rZW5fdmVyc2lvbiI6ImJmMTc3ZGUzYjk3YjAzMjY4YjU0NGZmMjMzNGU5YjFhMGUzYzgxM2NiYzliOTJkYWMwYmM5NTRiNmUzN2ZjMTJjYmFkNDM2NmIwYzExZTdjIiwiaWF0IjoxNjc4MDc4NDMyLCJleHAiOjE2NzgxMTQ0MzJ9.gzwp_svZlbA5PV_eawYV-9UFjZVjniy-tCDce16xrkI
           *\
          token?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            signin: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/user/signin`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Returns authenticated user info
         *
         * @tags Auth
         * @name Me
         * @summary Get User Info
         * @request GET:/api/v1/auth/user/me
         * @response `200` `UserInfoType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            me: (query, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/user/me`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Emails user with a reset url.
         *
         * @tags Auth
         * @name PasswordForgot
         * @summary Forget Password
         * @request POST:/api/v1/auth/password/forgot
         * @response `200` `{
          \**
           * Success Message
           * @example Please check your email to reset the password
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            passwordForgot: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/password/forgot`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Change password of authenticated user with a new one.
         *
         * @tags Auth
         * @name PasswordChange
         * @summary Change Password
         * @request POST:/api/v1/auth/password/change
         * @response `200` `{
          \** Success Message *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            passwordChange: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/password/change`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Validate password reset url token.
         *
         * @tags Auth
         * @name PasswordResetTokenValidate
         * @summary Verify Reset Token
         * @request POST:/api/v1/auth/token/validate/{token}
         * @response `200` `{
          \**
           * Success Message
           * @example Token has been validated successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            passwordResetTokenValidate: (token, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/token/validate/${token}`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Api for verifying email where token need to be passed which is shared to user email.
         *
         * @tags Auth
         * @name EmailValidate
         * @summary Verify Email
         * @request POST:/api/v1/auth/email/validate/{token}
         * @response `200` `{
          \**
           * Success Message
           * @example Email has been verified successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            emailValidate: (token, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/email/validate/${token}`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Update user password to new by using reset token.
         *
         * @tags Auth
         * @name PasswordReset
         * @summary Reset Password
         * @request POST:/api/v1/auth/password/reset/{token}
         * @response `200` `{
          \**
           * Success Message
           * @example Password has been reset successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            passwordReset: (token, data, params = {}) => this.request(Object.assign({ path: `/api/v1/auth/password/reset/${token}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Creates a new refresh token and JWT auth token for the user. The refresh token is sent as a cookie, while the JWT auth token is included in the response body.
         *
         * @tags Auth
         * @name TokenRefresh
         * @summary Refresh Token
         * @request POST:/api/v1/auth/token/refresh
         * @response `200` `{
          \**
           * New JWT auth token for user
           * @example 96751db2d53fb834382b682268874a2ea9ee610e4d904e688d1513f11d3c30d62d36d9e05dec0d63
           *\
          token?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            tokenRefresh: (params = {}) => this.request(Object.assign({ path: `/api/v1/auth/token/refresh`, method: 'POST', format: 'json' }, params)),
            /**
         * @description List all users in the given base.
         *
         * @tags Auth
         * @name BaseUserList
         * @summary List Base Users
         * @request GET:/api/v1/db/meta/projects/{baseId}/users
         * @response `200` `{
          users?: {
          list: (UserType)[],
          \** Model for Paginated *\
          pageInfo: PaginatedType,
        
        },
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            baseUserList: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/users`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a user and add it to the given base
         *
         * @tags Auth
         * @name BaseUserAdd
         * @summary Create Base User
         * @request POST:/api/v1/db/meta/projects/{baseId}/users
         * @response `200` `{
          \**
           * Success Message for inviting single email
           * @example The user has been invited successfully
           *\
          msg?: string,
          \** @example 8354ddba-a769-4d64-8397-eccb2e2b3c06 *\
          invite_token?: string,
          error?: ({
          \** @example w@nocodb.com *\
          email?: string,
          \** @example <ERROR_MESSAGE> *\
          error?: string,
        
        })[],
          \** @example w@nocodb.com *\
          email?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            baseUserAdd: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/users`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update a given user in a given base. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Auth
         * @name BaseUserUpdate
         * @summary Update Base User
         * @request PATCH:/api/v1/db/meta/projects/{baseId}/users/{userId}
         * @response `200` `{
          \**
           * Success Message
           * @example The user has been updated successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            baseUserUpdate: (baseId, userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/users/${userId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete a given user in a given base. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Auth
         * @name BaseUserRemove
         * @summary Delete Base User
         * @request DELETE:/api/v1/db/meta/projects/{baseId}/users/{userId}
         * @response `200` `{
          \**
           * Success Message
           * @example The user has been updated successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            baseUserRemove: (baseId, userId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/users/${userId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Resend Invitation to a specific user
         *
         * @tags Auth
         * @name BaseUserResendInvite
         * @summary Resend User Invitation
         * @request POST:/api/v1/db/meta/projects/{baseId}/users/{userId}/resend-invite
         * @response `200` `{
          \**
           * Success Message
           * @example The invitation has been sent to the user
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            baseUserResendInvite: (baseId, userId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/users/${userId}/resend-invite`, method: 'POST', format: 'json' }, params)),
        };
        this.orgTokens = {
            /**
         * @description List all organisation API tokens.  Access with API tokens will be blocked.
         *
         * @tags Org Tokens
         * @name List
         * @summary List Organisation API Tokens
         * @request GET:/api/v1/tokens
         * @response `200` `ApiTokenListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (params = {}) => this.request(Object.assign({ path: `/api/v1/tokens`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Creat an organisation API token. Access with API tokens will be blocked.
         *
         * @tags Org Tokens
         * @name Create
         * @summary Create Organisation API Token
         * @request POST:/api/v1/tokens
         * @response `200` `ApiTokenType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/tokens`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete an organisation API token. Access with API tokens will be blocked.
         *
         * @tags Org Tokens
         * @name Delete
         * @summary Delete Organisation API Tokens
         * @request DELETE:/api/v1/tokens/{tokenId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (tokenId, params = {}) => this.request(Object.assign({ path: `/api/v1/tokens/${tokenId}`, method: 'DELETE', format: 'json' }, params)),
        };
        this.orgLicense = {
            /**
         * @description Get the application license key. Exclusive for super admin.
         *
         * @tags Org License
         * @name Get
         * @summary Get App License
         * @request GET:/api/v1/license
         * @response `200` `{
          \** Application license key *\
          key?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            get: (params = {}) => this.request(Object.assign({ path: `/api/v1/license`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Set the application license key. Exclusive for super admin.
         *
         * @tags Org License
         * @name Set
         * @summary Create App License
         * @request POST:/api/v1/license
         * @response `200` `{
          \** @example The license key has been saved *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            set: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/license`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.orgAppSettings = {
            /**
         * @description Get the application settings. Exclusive for super admin.
         *
         * @tags Org App Settings
         * @name Get
         * @summary Get App Settings
         * @request GET:/api/v1/app-settings
         * @response `200` `{
          \**
           * Status of invite only signup
           * @example true
           *\
          invite_only_signup?: boolean,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            get: (params = {}) => this.request(Object.assign({ path: `/api/v1/app-settings`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the application settings. Exclusive for super admin.
         *
         * @tags Org App Settings
         * @name Set
         * @summary Create App Settings
         * @request POST:/api/v1/app-settings
         * @response `200` `{
          \** @example The app settings have been saved *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            set: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/app-settings`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.orgUsers = {
            /**
         * @description List all organisation users. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name List
         * @summary List Organisation Users
         * @request GET:/api/v1/users
         * @response `200` `UserListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (params = {}) => this.request(Object.assign({ path: `/api/v1/users`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create an organisation user. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name Add
         * @summary Create Organisation User
         * @request POST:/api/v1/users
         * @response `200` `{
          \** Invite Token *\
          invite_token?: string,
          \**
           * User email
           * @example user@example.com
           *\
          email?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            add: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/users`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update an organisation user by User ID. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name Update
         * @summary Update Organisation User
         * @request PATCH:/api/v1/users/{userId}
         * @response `200` `{
          \** @example The user has been updated successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete an organisation user by User ID. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name Delete
         * @summary Delete Organisation User
         * @request DELETE:/api/v1/users/{userId}
         * @response `200` `{
          \**
           * Sucess Message
           * @example The user has been deleted successfully
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (userId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}`, method: 'DELETE', format: 'json' }, params)),
            /**
             * @description Organisation User GetByUsername
             *
             * @tags Org users
             * @name GetByUsername
             * @summary Organisation User GetByUsername
             * @request GET:/api/v1/users/{username}
             * @response `200` `UserType` OK
             */
            getByUsername: (username, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${username}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Resend Invitation to a specific user. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name ResendInvite
         * @summary Invite Organisation User
         * @request POST:/api/v1/users/{userId}/resend-invite
         * @response `200` `{
          \**
           * Success Message
           * @example The invitation has been sent to the target user
           *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            resendInvite: (userId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/resend-invite`, method: 'POST', format: 'json' }, params)),
            /**
             * @description Create Organisation User Profile
             *
             * @tags Org users
             * @name ProfileCreate
             * @summary Organisation User Profile - Create
             * @request POST:/api/v1/users/{userId}/profile
             * @response `200` `void` OK
             */
            profileCreate: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/profile`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
             * @description Get Organisation User Profile
             *
             * @tags Org users
             * @name ProfileGet
             * @summary Organisation User Profile - Get
             * @request GET:/api/v1/users/{userId}/profile
             * @response `200` `void` OK
             */
            profileGet: (userId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/profile`, method: 'GET' }, params)),
            /**
             * @description Update Organisation User Profile
             *
             * @tags Org users
             * @name ProfileUpdate
             * @request PATCH:/api/v1/users/{userId}/profile
             * @response `200` `void` OK
             */
            profileUpdate: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/profile`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
            /**
             * @description Create Organisation User Follower Relationship (Follow)
             *
             * @tags Org users
             * @name FollowerCreate
             * @summary Organisation User Follower - Create
             * @request POST:/api/v1/users/{userId}/follower
             * @response `200` `void` OK
             */
            followerCreate: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/follower`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
             * @description List Organisation User Followers
             *
             * @tags Org users
             * @name FollowerList
             * @summary Organisation User Follower - List
             * @request GET:/api/v1/users/{userId}/follower
             * @response `200` `void` OK
             */
            followerList: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/follower`, method: 'GET', body: data, type: ContentType.Json }, params)),
            /**
             * @description Delete Organisation User Follower Relationship (Unfollow)
             *
             * @tags Org users
             * @name FollowerDelete
             * @summary Organisation User Follower - Delete
             * @request DELETE:/api/v1/users/{userId}/follower
             * @response `200` `void` OK
             */
            followerDelete: (userId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/follower`, method: 'DELETE', body: data, type: ContentType.Json }, params)),
            /**
             * @description List Organisation User Following
             *
             * @tags Org users
             * @name FollowingList
             * @summary Organisation User Following - List
             * @request GET:/api/v1/users/{userId}/following
             * @response `200` `void` OK
             */
            followingList: (userId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/following`, method: 'GET' }, params)),
            /**
             * @description Check if Organisation User is following someone
             *
             * @tags Org users
             * @name IsFollowing
             * @summary Organisation User IsFollowing
             * @request GET:/api/v1/users/{userId}/isFollowing/{followerId}
             * @response `200` `void` OK
             */
            isFollowing: (userId, followerId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/isFollowing/${followerId}`, method: 'GET' }, params)),
            /**
         * @description Generate Password Reset Token for Organisation User. Exclusive for Super Admin. Access with API Tokens will be blocked.
         *
         * @tags Org Users
         * @name GeneratePasswordResetToken
         * @summary Generate Organisation User Password Reset Token
         * @request POST:/api/v1/users/{userId}/generate-reset-url
         * @response `200` `{
          \** Password Reset Token for the user *\
          reset_password_token?: string,
          \** Password Reset URL for the user *\
          reset_password_url?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            generatePasswordResetToken: (userId, params = {}) => this.request(Object.assign({ path: `/api/v1/users/${userId}/generate-reset-url`, method: 'POST', format: 'json' }, params)),
        };
        this.base = {
            /**
         * @description Get info such as node version, arch, platform, is docker, rootdb and package version of a given base
         *
         * @tags Base
         * @name MetaGet
         * @summary Get Base info
         * @request GET:/api/v1/db/meta/projects/{baseId}/info
         * @response `200` `{
          \**
           * Node version
           * @example v12.16.1
           *\
          Node?: string,
          \**
           * Architecture type
           * @example x64
           *\
          Arch?: string,
          \**
           * Platform type
           * @example linux
           *\
          Platform?: string,
          \**
           * Is docker
           * @example false
           *\
          Docker?: boolean,
          \**
           * Database type
           * @example postgres
           *\
          Database?: string,
          \**
           * Is base on rootdb
           * @example false
           *\
          ProjectOnRootDB?: boolean,
          \**
           * Root database type
           * @example postgres
           *\
          RootDB?: string,
          \**
           * Package version
           * @example 1.0.0
           *\
          PackageVersion?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            metaGet: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/info`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Hide / show views based on user role
         *
         * @tags Base
         * @name ModelVisibilityList
         * @summary Get UI ACL
         * @request GET:/api/v1/db/meta/projects/{baseId}/visibility-rules
         * @response `200` `(any)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            modelVisibilityList: (baseId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/visibility-rules`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Hide / show views based on user role
         *
         * @tags Base
         * @name ModelVisibilitySet
         * @summary Create UI ACL
         * @request POST:/api/v1/db/meta/projects/{baseId}/visibility-rules
         * @response `200` `{
          \** @example UI ACL has been created successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            modelVisibilitySet: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/visibility-rules`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description List all base meta data
         *
         * @tags Base
         * @name List
         * @summary List Projects
         * @request GET:/api/v1/db/meta/projects/
         * @response `200` `ProjectListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new base
         *
         * @tags Base
         * @name Create
         * @summary Create Base
         * @request POST:/api/v1/db/meta/projects/
         * @response `200` `BaseType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Duplicate a base
         *
         * @tags Base
         * @name SourceDuplicate
         * @summary Duplicate Base Source
         * @request POST:/api/v1/db/meta/duplicate/{baseId}/{sourceId}
         * @response `200` `{
          name?: string,
          id?: string,
          base_id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sourceDuplicate: (baseId, data, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/duplicate/${baseId}/${sourceId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Duplicate a base
         *
         * @tags Base
         * @name Duplicate
         * @summary Duplicate Base
         * @request POST:/api/v1/db/meta/duplicate/{baseId}
         * @response `200` `{
          name?: string,
          id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            duplicate: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/duplicate/${baseId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the info of a given base
         *
         * @tags Base
         * @name Read
         * @summary Get Base
         * @request GET:/api/v1/db/meta/projects/{baseId}
         * @response `200` `BaseType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Delete the given base
         *
         * @tags Base
         * @name Delete
         * @summary Delete Base
         * @request DELETE:/api/v1/db/meta/projects/{baseId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Update the given base
         *
         * @tags Base
         * @name Update
         * @summary Update Base
         * @request PATCH:/api/v1/db/meta/projects/{baseId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * No description
             *
             * @tags Base
             * @name UserMetaUpdate
             * @summary Base user meta update
             * @request PATCH:/api/v1/db/meta/projects/{baseId}/user
             * @response `200` `void` OK
             */
            userMetaUpdate: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/user`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
            /**
         * @description Get Base Shared Base
         *
         * @tags Base
         * @name SharedBaseGet
         * @summary Get Base Shared Base
         * @request GET:/api/v1/db/meta/projects/{baseId}/shared
         * @response `200` `{
          \**
           * @format uuid
           * @example a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11
           *\
          uuid?: string,
          \** @format uri *\
          url?: string,
          \** @example viewer *\
          roles?: string,
          \** ID of custom url *\
          fk_custom_url_id?: StringOrNullType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedBaseGet: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/shared`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Delete Base Shared Base
         *
         * @tags Base
         * @name SharedBaseDisable
         * @summary Delete Base Shared Base
         * @request DELETE:/api/v1/db/meta/projects/{baseId}/shared
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedBaseDisable: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/shared`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Create Base Shared Base
         *
         * @tags Base
         * @name SharedBaseCreate
         * @summary Create Base Shared Base
         * @request POST:/api/v1/db/meta/projects/{baseId}/shared
         * @response `200` `{
          \** Model for StringOrNull *\
          uuid?: StringOrNullType,
          \** Model for StringOrNull *\
          roles?: StringOrNullType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedBaseCreate: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/shared`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update Base Shared Base
         *
         * @tags Base
         * @name SharedBaseUpdate
         * @summary Update Base Shared Base
         * @request PATCH:/api/v1/db/meta/projects/{baseId}/shared
         * @response `200` `{
          \**
           * @format uuid
           * @example a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11
           *\
          uuid?: string,
          \** @format uri *\
          url?: string,
          \** @example viewer *\
          roles?: string,
          \** ID of custom url *\
          fk_custom_url_id?: StringOrNullType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedBaseUpdate: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/shared`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Calculate the Base Cost
         *
         * @tags Base
         * @name Cost
         * @summary Base Cost
         * @request GET:/api/v1/db/meta/projects/{baseId}/cost
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            cost: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/cost`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Duplicate a shared base
         *
         * @tags Base
         * @name DuplicateShared
         * @summary Duplicate Shared Base
         * @request POST:/api/v2/meta/duplicate/{workspaceId}/shared/{sharedBaseId}
         * @response `200` `{
          name?: string,
          id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            duplicateShared: (workspaceId, sharedBaseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/duplicate/${workspaceId}/shared/${sharedBaseId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Synchronise the meta data difference between NC_DB and external data sources
         *
         * @tags Base
         * @name MetaDiffSync
         * @summary Sync Meta
         * @request POST:/api/v1/db/meta/projects/{baseId}/meta-diff
         * @response `200` `{
          \** @example The meta has been synchronized successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            metaDiffSync: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/meta-diff`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Get the meta data difference between NC_DB and external data sources
         *
         * @tags Base
         * @name MetaDiffGet
         * @summary Meta Diff
         * @request GET:/api/v1/db/meta/projects/{baseId}/meta-diff
         * @response `200` `({
          \**
           * Table Name
           * @example Table 1
           *\
          table_name?: string,
          \**
           * Source ID
           * @example ds_rrplkgy0pq1f3c
           *\
          source_id?: string,
          \**
           * Change Type
           * @example table
           *\
          type?: string,
          \** Detected Changes *\
          detectedChanges?: (object)[],
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            metaDiffGet: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/meta-diff`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Check if a base contains empty and null filters. Used in `Show NULL and EMPTY in Filter` in Base Setting.
         *
         * @tags Base
         * @name HasEmptyOrNullFilters
         * @summary List Empty & Null Filter
         * @request GET:/api/v1/db/meta/projects/{baseId}/has-empty-or-null-filters
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            hasEmptyOrNullFilters: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/has-empty-or-null-filters`, method: 'GET', format: 'json' }, params)),
        };
        this.source = {
            /**
         * @description Get the source details of a given base
         *
         * @tags Source
         * @name Read
         * @summary Get Source
         * @request GET:/api/v1/db/meta/projects/{baseId}/bases/{sourceId}
         * @response `200` `SourceType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/${sourceId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Delete the source details of a given base
         *
         * @tags Source
         * @name Delete
         * @summary Delete Source
         * @request DELETE:/api/v1/db/meta/projects/{baseId}/bases/{sourceId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/${sourceId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Update the source details of a given base
         *
         * @tags Source
         * @name Update
         * @summary Update Source
         * @request PATCH:/api/v1/db/meta/projects/{baseId}/bases/{sourceId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (baseId, sourceId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/${sourceId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get base source list
         *
         * @tags Source
         * @name List
         * @summary List Sources
         * @request GET:/api/v1/db/meta/projects/{baseId}/bases/
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new source on a given base
         *
         * @tags Source
         * @name Create
         * @summary Create Source
         * @request POST:/api/v1/db/meta/projects/{baseId}/bases/
         * @response `200` `SourceType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * No description
             *
             * @tags Source
             * @name ShareErd
             * @summary share ERD view
             * @request POST:/api/v1/db/meta/projects/{baseId}/bases/{sourceId}/share/erd
             * @response `200` `SourceType` OK
             */
            shareErd: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/${sourceId}/share/erd`, method: 'POST', format: 'json' }, params)),
            /**
             * No description
             *
             * @tags Source
             * @name DisableShareErd
             * @request DELETE:/api/v1/db/meta/projects/{baseId}/bases/{sourceId}/share/erd
             * @response `200` `void` OK
             */
            disableShareErd: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/bases/${sourceId}/share/erd`, method: 'DELETE' }, params)),
            /**
         * @description List all tables in a given Base and Source
         *
         * @tags Source
         * @name TableList
         * @summary List Tables
         * @request GET:/api/v1/db/meta/projects/{baseId}/{sourceId}/tables
         * @response `200` `TableListType`
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            tableList: (baseId, sourceId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/${sourceId}/tables`, method: 'GET', query: query }, params)),
            /**
         * @description Create a new table in a given Base and Source
         *
         * @tags Source
         * @name TableCreate
         * @summary Create Table
         * @request POST:/api/v1/db/meta/projects/{baseId}/{sourceId}/tables
         * @response `200` `TableType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            tableCreate: (baseId, sourceId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/${sourceId}/tables`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Synchronise the meta data difference between NC_DB and external data sources in a given Source
         *
         * @tags Source
         * @name MetaDiffSync
         * @summary Synchronise Source Meta
         * @request POST:/api/v1/db/meta/projects/{baseId}/meta-diff/{sourceId}
         * @response `200` `{
          \** @example The source meta has been synchronized successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            metaDiffSync: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/meta-diff/${sourceId}`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Get the meta data difference between NC_DB and external data sources in a given Source
         *
         * @tags Source
         * @name MetaDiffGet
         * @summary Source Meta Diff
         * @request GET:/api/v1/db/meta/projects/{baseId}/meta-diff/{sourceId}
         * @response `200` `({
          \**
           * Table Name
           * @example Table 1
           *\
          table_name?: string,
          \**
           * Source ID
           * @example ds_rrplkgy0pq1f3c
           *\
          source_id?: string,
          \**
           * Change Type
           * @example table
           *\
          type?: string,
          \** Detected Changes *\
          detectedChanges?: (object)[],
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            metaDiffGet: (baseId, sourceId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/meta-diff/${sourceId}`, method: 'GET', format: 'json' }, params)),
        };
        this.dbTable = {
            /**
         * @description Create a new table in a given base
         *
         * @tags DB Table
         * @name Create
         * @summary Create Table
         * @request POST:/api/v1/db/meta/projects/{baseId}/tables
         * @response `200` `TableType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/tables`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description List all tables in a given base
         *
         * @tags DB Table
         * @name List
         * @summary List Tables
         * @request GET:/api/v1/db/meta/projects/{baseId}/tables
         * @response `200` `TableListType`
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (baseId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/tables`, method: 'GET', query: query }, params)),
            /**
         * @description Read the table meta data by the given table ID
         *
         * @tags DB Table
         * @name Read
         * @summary Read Table
         * @request GET:/api/v1/db/meta/tables/{tableId}
         * @response `200` `TableType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the table meta data by the given table ID
         *
         * @tags DB Table
         * @name Update
         * @summary Update Table
         * @request PATCH:/api/v1/db/meta/tables/{tableId}
         * @response `200` `{
          \** @example The table has been updated successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the table meta data by the given table ID
         *
         * @tags DB Table
         * @name Delete
         * @summary Delete Table
         * @request DELETE:/api/v1/db/meta/tables/{tableId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Duplicate a table
         *
         * @tags DB Table
         * @name Duplicate
         * @summary Duplicate Table
         * @request POST:/api/v1/db/meta/duplicate/{baseId}/table/{tableId}
         * @response `200` `{
          name?: string,
          id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            duplicate: (baseId, tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/duplicate/${baseId}/table/${tableId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Duplicate a column
         *
         * @tags DB Table
         * @name DuplicateColumn
         * @summary Duplicate Column
         * @request POST:/api/v1/db/meta/duplicate/{baseId}/column/{columnId}
         * @response `200` `{
          name?: string,
          id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            duplicateColumn: (baseId, columnId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/duplicate/${baseId}/column/${columnId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the order of the given Table
         *
         * @tags DB Table
         * @name Reorder
         * @summary Reorder Table
         * @request POST:/api/v1/db/meta/tables/{tableId}/reorder
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            reorder: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/reorder`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbLinks = {
            /**
         * @description Read the table metadata by linked column ID and  table ID
         *
         * @tags DB Links
         * @name TableRead
         * @summary Read Partial Linked Table
         * @request GET:/api/v1/db/internal/links/{linkColumnId}/tables/{tableId}
         * @response `200` `TableType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            tableRead: (linkColumnId, tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/internal/links/${linkColumnId}/tables/${tableId}`, method: 'GET', format: 'json' }, params)),
        };
        this.dbTableColumn = {
            /**
         * @description Create a new column in a given Table
         *
         * @tags DB Table Column
         * @name Create
         * @summary Create Column
         * @request POST:/api/v1/db/meta/tables/{tableId}/columns
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/columns`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
         * @description Update the existing column by the given column ID
         *
         * @tags DB Table Column
         * @name Update
         * @summary Update Column
         * @request PATCH:/api/v1/db/meta/columns/{columnId}
         * @response `200` `ColumnType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (columnId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/columns/${columnId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the existing column by the given column ID
         *
         * @tags DB Table Column
         * @name Delete
         * @summary Delete Column
         * @request DELETE:/api/v1/db/meta/columns/{columnId}
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (columnId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/columns/${columnId}`, method: 'DELETE' }, params)),
            /**
         * @description Get the existing column by the given column ID
         *
         * @tags DB Table Column
         * @name Get
         * @summary Get Column
         * @request GET:/api/v1/db/meta/columns/{columnId}
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            get: (columnId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/columns/${columnId}`, method: 'GET' }, params)),
            /**
         * @description Set a primary value on a given column
         *
         * @tags DB Table Column
         * @name PrimaryColumnSet
         * @summary Create Primary Value
         * @request POST:/api/v1/db/meta/columns/{columnId}/primary
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            primaryColumnSet: (columnId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/columns/${columnId}/primary`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Get columns hash for table
         *
         * @tags DB Table Column
         * @name Hash
         * @summary Get columns hash for table
         * @request GET:/api/v1/db/meta/tables/{tableId}/columns/hash
         * @response `200` `{
          \** Columns hash *\
          hash?: string,
        
        }` OK
         */
            hash: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/columns/hash`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Bulk create-update-delete columns
         *
         * @tags DB Table Column
         * @name Bulk
         * @summary Bulk create-update-delete columns
         * @request POST:/api/v1/db/meta/tables/{tableId}/columns/bulk
         * @response `200` `{
          failedOps?: (any)[],
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulk: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/columns/bulk`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbView = {
            /**
         * @description List all views in a given Table.
         *
         * @tags DB View
         * @name List
         * @summary List Views
         * @request GET:/api/v1/db/meta/tables/{tableId}/views
         * @response `200` `ViewListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/views`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the view with the given view Id.
         *
         * @tags DB View
         * @name Update
         * @summary Update View
         * @request PATCH:/api/v1/db/meta/views/{viewId}
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the view with the given view Id.
         *
         * @tags DB View
         * @name Delete
         * @summary Delete View
         * @request DELETE:/api/v1/db/meta/views/{viewId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Get the row color info from view.
         *
         * @tags DB View
         * @name GetViewRowColor
         * @summary Get row color info
         * @request GET:/api/v1/db/meta/views/{viewId}/row-color
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            getViewRowColor: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Delete the row color info from view.
         *
         * @tags DB View
         * @name DeleteViewRowColor
         * @summary Delete row color info
         * @request DELETE:/api/v1/db/meta/views/{viewId}/row-color
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            deleteViewRowColor: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color`, method: 'DELETE' }, params)),
            /**
             * No description
             *
             * @tags DB View
             * @name ViewRowColorSelectAdd
             * @summary Set view row color select
             * @request POST:/api/v1/db/meta/views/{viewId}/row-color-select
             * @response `200` `void` OK
             */
            viewRowColorSelectAdd: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color-select`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
             * No description
             *
             * @tags DB View
             * @name ViewRowColorConditionAdd
             * @summary Add view row color condition
             * @request POST:/api/v1/db/meta/views/{viewId}/row-color-conditions
             * @response `200` `void` OK
             */
            viewRowColorConditionAdd: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color-conditions`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
             * No description
             *
             * @tags DB View
             * @name ViewRowColorConditionUpdate
             * @summary Update view row color condition
             * @request PATCH:/api/v1/db/meta/views/{viewId}/row-color-conditions/{id}
             * @response `200` `void` OK
             */
            viewRowColorConditionUpdate: (viewId, id, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color-conditions/${id}`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
            /**
             * No description
             *
             * @tags DB View
             * @name ViewRowColorConditionDelete
             * @summary Delete view row color condition
             * @request DELETE:/api/v1/db/meta/views/{viewId}/row-color-conditions/{id}
             * @response `200` `void` OK
             */
            viewRowColorConditionDelete: (viewId, id, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/row-color-conditions/${id}`, method: 'DELETE' }, params)),
            /**
         * @description Show All Columns in a given View
         *
         * @tags DB View
         * @name ShowAllColumn
         * @summary Show All Columns In View
         * @request POST:/api/v1/db/meta/views/{viewId}/show-all
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            showAllColumn: (viewId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/show-all`, method: 'POST', query: query, format: 'json' }, params)),
            /**
         * @description Hide All Columns in a given View
         *
         * @tags DB View
         * @name HideAllColumn
         * @summary Hide All Columns In View
         * @request POST:/api/v1/db/meta/views/{viewId}/hide-all
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            hideAllColumn: (viewId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/hide-all`, method: 'POST', query: query, format: 'json' }, params)),
            /**
         * @description Create a new grid view in a given Table
         *
         * @tags DB View
         * @name GridCreate
         * @summary Create Grid View
         * @request POST:/api/v1/db/meta/tables/{tableId}/grids
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            gridCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/grids`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Create a new form view in a given Table
         *
         * @tags DB View
         * @name FormCreate
         * @summary Create Form View
         * @request POST:/api/v1/db/meta/tables/{tableId}/forms
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            formCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/forms`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the form data by Form ID
         *
         * @tags DB View
         * @name FormUpdate
         * @summary Update Form View
         * @request PATCH:/api/v1/db/meta/forms/{formViewId}
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            formUpdate: (formViewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/forms/${formViewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the form data by Form ID
         *
         * @tags DB View
         * @name FormRead
         * @summary Get Form
         * @request GET:/api/v1/db/meta/forms/{formViewId}
         * @response `200` `FormType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            formRead: (formViewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/forms/${formViewId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the form column(s) by Form View Column ID
         *
         * @tags DB View
         * @name FormColumnUpdate
         * @summary Update Form Column
         * @request PATCH:/api/v1/db/meta/form-columns/{formViewColumnId}
         * @response `200` `FormColumnReqType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            formColumnUpdate: (formViewColumnId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/form-columns/${formViewColumnId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update Grid View
         *
         * @tags DB View
         * @name GridUpdate
         * @summary Update Grid View
         * @request PATCH:/api/v1/db/meta/grids/{viewId}
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            gridUpdate: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/grids/${viewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description List all columns in the given Grid
         *
         * @tags DB View
         * @name GridColumnsList
         * @summary List Grid Columns
         * @request GET:/api/v1/db/meta/grids/{gridId}/grid-columns
         * @response `200` `(GridColumnType)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            gridColumnsList: (gridId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/grids/${gridId}/grid-columns`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update grid column(s) in the given Grid
         *
         * @tags DB View
         * @name GridColumnUpdate
         * @summary Update Grid Column
         * @request PATCH:/api/v1/db/meta/grid-columns/{columnId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            gridColumnUpdate: (columnId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/grid-columns/${columnId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * No description
         *
         * @tags DB View
         * @name GalleryCreate
         * @summary Create Gallery View
         * @request POST:/api/v1/db/meta/tables/{tableId}/galleries
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            galleryCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/galleries`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the Gallery View data with Gallery ID
         *
         * @tags DB View
         * @name GalleryUpdate
         * @summary Update Gallery View
         * @request PATCH:/api/v1/db/meta/galleries/{galleryViewId}
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            galleryUpdate: (galleryViewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/galleries/${galleryViewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the Gallery View data with Gallery ID
         *
         * @tags DB View
         * @name GalleryRead
         * @summary Get Gallery View
         * @request GET:/api/v1/db/meta/galleries/{galleryViewId}
         * @response `200` `GalleryType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            galleryRead: (galleryViewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/galleries/${galleryViewId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new Kanban View
         *
         * @tags DB View
         * @name KanbanCreate
         * @summary Create Kanban View
         * @request POST:/api/v1/db/meta/tables/{tableId}/kanbans
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            kanbanCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/kanbans`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the Kanban View data with Kanban ID
         *
         * @tags DB View
         * @name KanbanUpdate
         * @summary Update Kanban View
         * @request PATCH:/api/v1/db/meta/kanbans/{kanbanViewId}
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            kanbanUpdate: (kanbanViewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/kanbans/${kanbanViewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the Kanban View data by Kanban ID
         *
         * @tags DB View
         * @name KanbanRead
         * @summary Get Kanban View
         * @request GET:/api/v1/db/meta/kanbans/{kanbanViewId}
         * @response `200` `KanbanType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            kanbanRead: (kanbanViewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/kanbans/${kanbanViewId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new Map View
         *
         * @tags DB View
         * @name MapCreate
         * @summary Create Map View
         * @request POST:/api/v1/db/meta/tables/{tableId}/maps
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            mapCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/maps`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the Map View data by Map ID
         *
         * @tags DB View
         * @name MapUpdate
         * @summary Update Map View
         * @request PATCH:/api/v1/db/meta/maps/{mapViewId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            mapUpdate: (mapViewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/maps/${mapViewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the Map View data by Map ID
         *
         * @tags DB View
         * @name MapRead
         * @summary Get Map View
         * @request GET:/api/v1/db/meta/maps/{mapViewId}
         * @response `200` `MapType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            mapRead: (mapViewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/maps/${mapViewId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new Calendar View
         *
         * @tags DB View
         * @name CalendarCreate
         * @summary Create Calendar View
         * @request POST:/api/v1/db/meta/tables/{tableId}/calendars
         * @response `200` `ViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            calendarCreate: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/calendars`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the Calendar View data with Calendar ID
         *
         * @tags DB View
         * @name CalendarUpdate
         * @summary Update Calendar View
         * @request PATCH:/api/v1/db/meta/calendars/{calendarViewId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            calendarUpdate: (calendarViewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/calendars/${calendarViewId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the Calendar View data by Calendar ID
         *
         * @tags DB View
         * @name CalendarRead
         * @summary Get Calendar View
         * @request GET:/api/v1/db/meta/calendars/{calendarViewId}
         * @response `200` `CalendarType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            calendarRead: (calendarViewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/calendars/${calendarViewId}`, method: 'GET', format: 'json' }, params)),
        };
        this.dbViewShare = {
            /**
         * @description List all shared views in a given Table
         *
         * @tags DB View Share
         * @name List
         * @summary List Shared Views
         * @request GET:/api/v1/db/meta/tables/{tableId}/share
         * @response `200` `SharedViewListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/share`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a shared view in a given View..
         *
         * @tags DB View Share
         * @name Create
         * @summary Create Shared View
         * @request POST:/api/v1/db/meta/views/{viewId}/share
         * @response `200` `SharedViewReqType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/share`, method: 'POST', format: 'json' }, params)),
            /**
         * @description Update a shared view in a given View..
         *
         * @tags DB View Share
         * @name Update
         * @summary Update Shared View
         * @request PATCH:/api/v1/db/meta/views/{viewId}/share
         * @response `200` `SharedViewType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/share`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete a shared view in a given View.
         *
         * @tags DB View Share
         * @name Delete
         * @summary Delete Shared View
         * @request DELETE:/api/v1/db/meta/views/{viewId}/share
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/share`, method: 'DELETE', format: 'json' }, params)),
        };
        this.dbViewColumn = {
            /**
         * @description List all columns by ViewID
         *
         * @tags DB View Column
         * @name List
         * @summary List Columns In View
         * @request GET:/api/v1/db/meta/views/{viewId}/columns
         * @response `200` `ColumnListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/columns`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a new column in a given View
         *
         * @tags DB View Column
         * @name Create
         * @summary Create Column in View
         * @request POST:/api/v1/db/meta/views/{viewId}/columns
         * @response `200` `ColumnType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/columns`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update a column in a View
         *
         * @tags DB View Column
         * @name Update
         * @summary Update View Column
         * @request PATCH:/api/v1/db/meta/views/{viewId}/columns/{columnId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (viewId, columnId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/columns/${columnId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbTableSort = {
            /**
         * @description List all the sort data in a given View
         *
         * @tags DB Table Sort
         * @name List
         * @summary List View Sorts
         * @request GET:/api/v1/db/meta/views/{viewId}/sorts
         * @response `200` `SortListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (viewId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/sorts`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the sort data in a given View
         *
         * @tags DB Table Sort
         * @name Create
         * @summary Update View Sort
         * @request POST:/api/v1/db/meta/views/{viewId}/sorts
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/sorts`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the sort data by Sort ID
         *
         * @tags DB Table Sort
         * @name Get
         * @summary Get Sort
         * @request GET:/api/v1/db/meta/sorts/{sortId}
         * @response `200` `SortType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            get: (sortId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/sorts/${sortId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the sort data by Sort ID
         *
         * @tags DB Table Sort
         * @name Update
         * @summary Update Sort
         * @request PATCH:/api/v1/db/meta/sorts/{sortId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (sortId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/sorts/${sortId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the sort data by Sort ID
         *
         * @tags DB Table Sort
         * @name Delete
         * @summary Delete Sort
         * @request DELETE:/api/v1/db/meta/sorts/{sortId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (sortId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/sorts/${sortId}`, method: 'DELETE', format: 'json' }, params)),
        };
        this.dbTableFilter = {
            /**
         * @description Get the filter data in a given View
         *
         * @tags DB Table Filter
         * @name Read
         * @summary Get View Filter
         * @request GET:/api/v1/db/meta/views/{viewId}/filters
         * @response `200` `FilterListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (viewId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/filters`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Update the filter data in a given View
         *
         * @tags DB Table Filter
         * @name Create
         * @summary Create View Filter
         * @request POST:/api/v1/db/meta/views/{viewId}/filters
         * @response `200` `FilterType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (viewId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/views/${viewId}/filters`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the filter data with a given Filter ID
         *
         * @tags DB Table Filter
         * @name Get
         * @summary Get Filter
         * @request GET:/api/v1/db/meta/filters/{filterId}
         * @response `200` `FilterType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            get: (filterId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/filters/${filterId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the filter data with a given Filter ID
         *
         * @tags DB Table Filter
         * @name Update
         * @summary Update Filter
         * @request PATCH:/api/v1/db/meta/filters/{filterId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (filterId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/filters/${filterId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the filter data with a given Filter ID
         *
         * @tags DB Table Filter
         * @name Delete
         * @summary Delete Filter
         * @request DELETE:/api/v1/db/meta/filters/{filterId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (filterId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/filters/${filterId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Get Filter Group Children of a given group ID
         *
         * @tags DB Table Filter
         * @name ChildrenRead
         * @summary Get Filter Group Children
         * @request GET:/api/v1/db/meta/filters/{filterGroupId}/children
         * @response `200` `FilterListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            childrenRead: (filterGroupId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/filters/${filterGroupId}/children`, method: 'GET', format: 'json' }, params)),
        };
        this.dbTableWebhookFilter = {
            /**
         * @description Get the filter data in a given Hook
         *
         * @tags DB Table Webhook Filter
         * @name Read
         * @summary Get Hook Filter
         * @request GET:/api/v1/db/meta/hooks/{hookId}/filters
         * @response `200` `FilterListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (hookId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/hooks/${hookId}/filters`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create filter(s) in a given Hook
         *
         * @tags DB Table Webhook Filter
         * @name Create
         * @summary Create Hook Filter
         * @request POST:/api/v1/db/meta/hooks/{hookId}/filters
         * @response `200` `FilterType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (hookId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/hooks/${hookId}/filters`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbTableWebhookLogs = {
            /**
         * @description List the log data in a given Hook
         *
         * @tags DB Table Webhook Logs
         * @name List
         * @summary List Hook Logs
         * @request GET:/api/v1/db/meta/hooks/{hookId}/logs
         * @response `200` `HookLogListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (hookId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/hooks/${hookId}/logs`, method: 'GET', query: query, format: 'json' }, params)),
        };
        this.dbTableRow = {
            /**
         * @description List all table rows in a given table and base
         *
         * @tags DB Table Row
         * @name List
         * @summary List Table Rows
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}
         * @response `200` `{
          \** List of data objects *\
          list: (object)[],
          \** Paginated Info *\
          pageInfo: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (orgs, baseName, tableName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new row in a given table and base.
         *
         * @tags DB Table Row
         * @name Create
         * @summary Create Table Row
         * @request POST:/api/v1/db/data/{orgs}/{baseName}/{tableName}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (orgs, baseName, tableName, data, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Return the first result of the target Table Row
         *
         * @tags DB Table Row
         * @name FindOne
         * @summary Find One Table Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/find-one
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            findOne: (orgs, baseName, tableName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/find-one`, method: 'GET', query: query, format: 'json' }, params)),
            /**
             * @description Get the result grouped by the given query
             *
             * @tags DB Table Row
             * @name GroupBy
             * @summary Group By Table Row
             * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/groupby
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            groupBy: (orgs, baseName, tableName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/groupby`, method: 'GET', query: query, format: 'json' }, params)),
            /**
             * @description Get the number of groups by the given query
             *
             * @tags DB Table Row
             * @name GroupByCount
             * @summary Group By Table Row Count
             * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/groupby/count
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            groupByCount: (orgs, baseName, tableName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/groupby/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the grouped data By Column ID. Used in Kanban View.
         *
         * @tags DB Table Row
         * @name GroupedDataList
         * @summary Table Group by Column
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/group/{columnId}
         * @response `200` `(any)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            groupedDataList: (orgs, baseName, tableName, columnId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/group/${columnId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the Table Row by Row ID
         *
         * @tags DB Table Row
         * @name Read
         * @summary Get Table Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (orgs, baseName, tableName, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Update the Table Row
         *
         * @tags DB Table Row
         * @name Update
         * @summary Update Table Row
         * @request PATCH:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (orgs, baseName, tableName, rowId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}`, method: 'PATCH', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the Table Row
         *
         * @tags DB Table Row
         * @name Delete
         * @summary Delete Table Row
         * @request DELETE:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (orgs, baseName, tableName, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}`, method: 'DELETE', query: query, format: 'json' }, params)),
            /**
         * @description check row with provided primary key exists or not
         *
         * @tags DB Table Row
         * @name Exist
         * @summary Does Table Row Exist
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}/exist
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            exist: (orgs, baseName, tableName, rowId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}/exist`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Bulk upsert table rows in one go.
         *
         * @tags DB Table Row
         * @name BulkUpsert
         * @summary Bulk Upsert Table Rows
         * @request POST:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}/upsert
         * @response `200` `(any)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkUpsert: (orgs, baseName, tableName, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}/upsert`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Bulk insert table rows in one go.
         *
         * @tags DB Table Row
         * @name BulkCreate
         * @summary Bulk Insert Table Rows
         * @request POST:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}
         * @response `200` `({
          id?: string,
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkCreate: (orgs, baseName, tableName, data, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Bulk Update Table Rows by given IDs
         *
         * @tags DB Table Row
         * @name BulkUpdate
         * @summary Bulk Update Table Rows by IDs
         * @request PATCH:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}
         * @response `200` `(number)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkUpdate: (orgs, baseName, tableName, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Bulk Delete Table Rows by given IDs
         *
         * @tags DB Table Row
         * @name BulkDelete
         * @summary Bulk Delete Table Rows by IDs
         * @request DELETE:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}
         * @response `200` `(number)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkDelete: (orgs, baseName, tableName, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}`, method: 'DELETE', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Bulk Update all Table Rows if the condition is true
         *
         * @tags DB Table Row
         * @name BulkUpdateAll
         * @summary Bulk Update Table Rows with Conditions
         * @request PATCH:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}/all
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkUpdateAll: (orgs, baseName, tableName, data, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}/all`, method: 'PATCH', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Bulk Delete all Table Rows if the condition is true
         *
         * @tags DB Table Row
         * @name BulkDeleteAll
         * @summary Bulk Delete Table Rows with Conditions
         * @request DELETE:/api/v1/db/data/bulk/{orgs}/{baseName}/{tableName}/all
         * @response `200` `(object)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            bulkDeleteAll: (orgs, baseName, tableName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/bulk/${orgs}/${baseName}/${tableName}/all`, method: 'DELETE', query: query, format: 'json' }, params)),
            /**
         * @description List all nested relations rows
         *
         * @tags DB Table Row
         * @name NestedList
         * @summary List Nested Relations Rows
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}/{relationType}/{columnName}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedList: (orgs, baseName, tableName, rowId, relationType, columnName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}/${relationType}/${columnName}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new nested relations row
         *
         * @tags DB Table Row
         * @name NestedAdd
         * @summary Create Nested Relations Row
         * @request POST:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}/{relationType}/{columnName}/{refRowId}
         * @response `200` `{
          \** @example The relation data has been created successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedAdd: (orgs, baseName, tableName, rowId, relationType, columnName, refRowId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}/${relationType}/${columnName}/${refRowId}`, method: 'POST', query: query, format: 'json' }, params)),
            /**
         * @description Delete a new nested relations row
         *
         * @tags DB Table Row
         * @name NestedRemove
         * @summary Delete Nested Relations Row
         * @request DELETE:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}/{relationType}/{columnName}/{refRowId}
         * @response `200` `{
          \** @example The relation data has been deleted successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedRemove: (orgs, baseName, tableName, rowId, relationType, columnName, refRowId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}/${relationType}/${columnName}/${refRowId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Get the table rows but exculding the current record's children and parent
         *
         * @tags DB Table Row
         * @name NestedChildrenExcludedList
         * @summary Referenced Table Rows Excluding Current Record's Children / Parent
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/{rowId}/{relationType}/{columnName}/exclude
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedChildrenExcludedList: (orgs, baseName, tableName, rowId, relationType, columnName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/${rowId}/${relationType}/${columnName}/exclude`, method: 'GET', query: query, format: 'json' }, params)),
        };
        this.dbViewRow = {
            /**
         * @description Get the grouped data By Column ID. Used in Kanban View.
         *
         * @tags DB View Row
         * @name GroupedDataList
         * @summary Table Group by Column
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/group/{columnId}
         * @response `200` `(any)[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            groupedDataList: (orgs, baseName, tableName, viewName, columnId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/group/${columnId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description List all table view rows
         *
         * @tags DB View Row
         * @name List
         * @summary List Table View Rows
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}
         * @response `200` `{
          \** List of table view rows *\
          list: (object)[],
          \** Paginated Info *\
          pageInfo: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new row in the given Table View
         *
         * @tags DB View Row
         * @name Create
         * @summary Create Table View Row
         * @request POST:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (orgs, baseName, tableName, viewName, data, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Return the first result of table view rows with the given query
         *
         * @tags DB View Row
         * @name FindOne
         * @summary Find One Table View Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/find-one
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            findOne: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/find-one`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the table view rows grouped by the given query
         *
         * @tags DB View Row
         * @name GroupBy
         * @summary Group By Table View Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/groupby
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            groupBy: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/groupby`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the table view rows grouped by count the given query
         *
         * @tags DB View Row
         * @name GroupByCount
         * @summary Count of Group By Table View Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/groupby/count
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            groupByCount: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/groupby/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Count how many rows in the given Table View
         *
         * @tags DB View Row
         * @name Count
         * @summary Count Table View Rows
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/count
         * @response `200` `{
          count?: number,
        
        }` OK
         */
            count: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the target Table View Row
         *
         * @tags DB View Row
         * @name Read
         * @summary Get Table View Row
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/{rowId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (orgs, baseName, tableName, viewName, rowId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/${rowId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the target Table View Row
         *
         * @tags DB View Row
         * @name Update
         * @summary Update Table View Row
         * @request PATCH:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/{rowId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (orgs, baseName, tableName, viewName, rowId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/${rowId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the target Table View Row
         *
         * @tags DB View Row
         * @name Delete
         * @summary Delete Table View Row
         * @request DELETE:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/{rowId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (orgs, baseName, tableName, viewName, rowId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/${rowId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Check row with provided primary key exists or not
         *
         * @tags DB View Row
         * @name Exist
         * @summary Does Table View Row Exist
         * @request GET:/api/v1/db/data/{orgs}/{baseName}/{tableName}/views/{viewName}/{rowId}/exist
         * @response `201` `number` Created
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            exist: (orgs, baseName, tableName, viewName, rowId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/data/${orgs}/${baseName}/${tableName}/views/${viewName}/${rowId}/exist`, method: 'GET', format: 'json' }, params)),
        };
        this.dbCalendarViewRow = {
            /**
             * @description List all rows in Calendar View of a Table
             *
             * @tags DB Calendar View Row
             * @name List
             * @summary List rows in Calendar View of a Table
             * @request GET:/api/v1/db/calendar-data/{orgs}/{baseName}/{tableName}/views/{viewName}
             */
            list: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/calendar-data/${orgs}/${baseName}/${tableName}/views/${viewName}`, method: 'GET', query: query }, params)),
            /**
             * @description List all rows in Calendar View of a Table
             *
             * @tags DB Calendar View Row
             * @name PublicDataCalendarRowList
             * @summary List rows in Calendar View of a Table
             * @request GET:/api/v1/db/public/calendar-view/{sharedViewUuid}
             */
            publicDataCalendarRowList: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/calendar-view/${sharedViewUuid}`, method: 'GET', query: query }, params)),
        };
        this.api = {
            /**
             * No description
             *
             * @name ResponsesApi
             * @request RESPONSES:/api/v1/db/calendar-data/{orgs}/{baseName}/{tableName}/views/{viewName}
             */
            responsesApi: (orgs, baseName, tableName, viewName, params = {}) => this.request(Object.assign({ path: `/api/v1/db/calendar-data/${orgs}/${baseName}/${tableName}/views/${viewName}`, method: 'RESPONSES' }, params)),
            /**
             * No description
             *
             * @name ResponsesApi2
             * @request RESPONSES:/api/v1/db/public/calendar-view/{sharedViewUuid}
             * @originalName responsesApi
             * @duplicate
             */
            responsesApi2: (sharedViewUuid, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/calendar-view/${sharedViewUuid}`, method: 'RESPONSES' }, params)),
        };
        this.dbCalendarViewRowCount = {
            /**
         * @description Get the count of table view rows grouped by the dates
         *
         * @tags DB Calendar View Row Count
         * @name DbCalendarViewRowCount
         * @summary Count of Records in Dates in Calendar View
         * @request GET:/api/v1/db/calendar-data/{orgs}/{baseName}/{tableName}/views/{viewName}/countByDate/
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dbCalendarViewRowCount: (orgs, baseName, tableName, viewName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/calendar-data/${orgs}/${baseName}/${tableName}/views/${viewName}/countByDate/`, method: 'GET', query: query, format: 'json' }, params)),
        };
        this.public = {
            /**
         * No description
         *
         * @tags Public
         * @name DataCalendarRowCount
         * @summary Count of Records in Dates in Calendar View
         * @request GET:/api/v1/db/public/calendar-view/{sharedViewUuid}/countByDate
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataCalendarRowCount: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/calendar-view/${sharedViewUuid}/countByDate`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Count how many rows in the given Table View
         *
         * @tags Public
         * @name DbViewRowCount
         * @summary Count Table View Rows
         * @request GET:/api/v2/public/shared-view/{sharedViewUuid}/count
         * @response `200` `{
          count?: number,
        
        }` OK
         */
            dbViewRowCount: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Read bulk data from a given table with provided filters
         *
         * @tags Public
         * @name DataTableBulkDataList
         * @summary Read Shared View Bulk Data List
         * @request POST:/api/v2/public/shared-view/{sharedViewUuid}/bulk/dataList
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataTableBulkDataList: (sharedViewUuid, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/bulk/dataList`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Read bulk group data from a given table with provided filters
         *
         * @tags Public
         * @name DataTableBulkGroup
         * @summary Read Shared View Bulk Group Data
         * @request POST:/api/v2/public/shared-view/{sharedViewUuid}/bulk/group
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataTableBulkGroup: (sharedViewUuid, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/bulk/group`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Read aggregated data from a given table
         *
         * @tags Public
         * @name DataTableAggregate
         * @summary Read Shared View Aggregated Data
         * @request GET:/api/v2/public/shared-view/{sharedViewUuid}/aggregate
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataTableAggregate: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/aggregate`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Read bulk aggregated data from a given table with provided filters
         *
         * @tags Public
         * @name DataTableBulkAggregate
         * @summary Read Shared View Bulk Aggregated Data
         * @request POST:/api/v2/public/shared-view/{sharedViewUuid}/bulk/aggregate
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataTableBulkAggregate: (sharedViewUuid, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/bulk/aggregate`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Download attachment from a shared view
         *
         * @tags Public
         * @name DataAttachmentDownload
         * @summary Get Shared View Attachment
         * @request GET:/api/v2/public/shared-view/{sharedViewUuid}/downloadAttachment/{columnId}/{rowId}
         * @response `200` `{
          \** URL to download the attachment *\
          url?: string,
          \** Path to download the attachment *\
          path?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataAttachmentDownload: (sharedViewUuid, columnId, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/downloadAttachment/${columnId}/${rowId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description List Shared View Grouped Data
         *
         * @tags Public
         * @name GroupedDataList
         * @summary List Shared View Grouped Data
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/group/{columnId}
         * @response `200` `({
          \** The Grouped Key *\
          key: string,
          \** the paginated result of the given key *\
          value: {
          \** List of the target data *\
          list: (object)[],
          \** Paginated Info *\
          pageInfo: PaginatedType,
        
        },
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            groupedDataList: (sharedViewUuid, columnId, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/group/${columnId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description List all shared view rows
         *
         * @tags Public
         * @name DataList
         * @summary List Shared View Rows
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/rows
         * @response `200` `SharedViewListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataList: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/rows`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new row for the target shared view
         *
         * @tags Public
         * @name DataCreate
         * @summary Create Share View Row
         * @request POST:/api/v1/db/public/shared-view/{sharedViewUuid}/rows
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataCreate: (sharedViewUuid, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/rows`, method: 'POST', body: data, type: ContentType.FormData, format: 'json' }, params)),
            /**
         * @description List all shared view rows grouped by a column
         *
         * @tags Public
         * @name DataGroupBy
         * @summary List Shared View Rows
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/groupby
         * @response `200` `SharedViewListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataGroupBy: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/groupby`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get the number of groups by the given query
         *
         * @tags Public
         * @name DataGroupByCount
         * @summary Group By Table Row Count
         * @request GET:/api/v2/public/shared-view/{sharedViewUuid}/groupby/count
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataGroupByCount: (sharedViewUuid, query, params = {}) => this.request(Object.assign({ path: `/api/v2/public/shared-view/${sharedViewUuid}/groupby/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description List all nested list data in a given shared view
         *
         * @tags Public
         * @name DataNestedList
         * @summary List Nested List Data
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/rows/{rowId}/{relationType}/{columnName}
         * @response `200` `{
          \** List of data objects *\
          list: (object)[],
          \** Paginated info *\
          pageInfo: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataNestedList: (sharedViewUuid, rowId, relationType, columnName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/rows/${rowId}/${relationType}/${columnName}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description List Nested Data Relation
         *
         * @tags Public
         * @name DataRelationList
         * @summary List Nested Data Relation
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/nested/{columnName}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dataRelationList: (sharedViewUuid, columnName, query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/nested/${columnName}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Get Share Source Meta
         *
         * @tags Public
         * @name SharedBaseGet
         * @summary Get Share Source Meta
         * @request GET:/api/v1/db/public/shared-base/{sharedBaseUuid}/meta
         * @response `200` `{
          \** Base ID *\
          base_id?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedBaseGet: (sharedBaseUuid, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-base/${sharedBaseUuid}/meta`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Get Share View Meta
         *
         * @tags Public
         * @name SharedViewMetaGet
         * @summary Get Share View Meta
         * @request GET:/api/v1/db/public/shared-view/{sharedViewUuid}/meta
         * @response `200` `(ViewType & {
          relatedMetas?: any,
          client?: string,
          source_id?: string,
          columns?: ((GridColumnType | FormColumnType | GalleryColumnType | (GridColumnType & FormColumnType & GalleryColumnType)) & ColumnType),
          \** Model for Table *\
          model?: TableType,
        
        } & {
          view?: (FormType | GridType | GalleryType | (FormType & GridType & GalleryType)),
        
        })` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            sharedViewMetaGet: (sharedViewUuid, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-view/${sharedViewUuid}/meta`, method: 'GET', format: 'json' }, params)),
            /**
             * No description
             *
             * @tags Public
             * @name SharedErdMetaGet
             * @request GET:/api/v1/db/public/shared-erd/{sharedErdUuid}/meta
             */
            sharedErdMetaGet: (sharedErdUuid, params = {}) => this.request(Object.assign({ path: `/api/v1/db/public/shared-erd/${sharedErdUuid}/meta`, method: 'GET' }, params)),
            /**
             * @description Trigger export as job
             *
             * @tags Public
             * @name ExportData
             * @summary Trigger export as job
             * @request POST:/api/v2/public/export/{publicDataUuid}/{exportAs}
             */
            exportData: (publicDataUuid, exportAs, data, params = {}) => this.request(Object.assign({ path: `/api/v2/public/export/${publicDataUuid}/${exportAs}`, method: 'POST', body: data, type: ContentType.Json }, params)),
        };
        this.dbDataTableBulkList = {
            /**
         * @description Read bulk data from a given table with given filters
         *
         * @tags DB Data Table Bulk List
         * @name DbDataTableBulkList
         * @summary Read Bulk Data
         * @request POST:/api/v2/tables/{tableId}/bulk/dataList
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dbDataTableBulkList: (tableId, query, data, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/bulk/dataList`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbDataTableBulkGroupList = {
            /**
         * @description Read bulk group data from a given table with given filters
         *
         * @tags DB Data Table Bulk Group List
         * @name DbDataTableBulkGroupList
         * @summary Read Bulk Group Data
         * @request POST:/api/v2/tables/{tableId}/bulk/group
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dbDataTableBulkGroupList: (tableId, query, data, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/bulk/group`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.oAuth = {
            /**
         * @description Retrieve public information about an OAuth client for authorization display
         *
         * @tags OAuth
         * @name V2PublicOauthClientDetail
         * @summary Get OAuth Client Information
         * @request GET:/api/v2/public/oauth/client/{clientId}
         * @response `200` `{
          \** OAuth client identifier *\
          client_id: string,
          \** Application name *\
          client_name: string,
          \**
           * Application homepage URL
           * @format uri
           *\
          client_uri?: string,
          \** Application logo URL or file metadata *\
          logo_uri?: (string | {
          path?: string,
          title?: string,
          mimetype?: string,
          size?: number,
        
        }),
          \** Application description *\
          client_description?: string,
          \** Registered redirect URIs *\
          redirect_uris: (string)[],
          \** OAuth client type *\
          client_type: "public" | "confidential",
        
        }` OAuth client information
         * @response `400` `{
          \** @example invalid_client_id *\
          error?: string,
          \** @example The client ID format is invalid *\
          error_description?: string,
        
        }` Invalid client ID format
         * @response `404` `{
          \** @example client_not_found *\
          error?: string,
          \** @example The requested OAuth client does not exist *\
          error_description?: string,
        
        }` OAuth client not found
         */
            v2PublicOauthClientDetail: (clientId, params = {}) => this.request(Object.assign({ path: `/api/v2/public/oauth/client/${clientId}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Handle OAuth authorization request with user approval/denial
         *
         * @tags OAuth
         * @name Authorize
         * @summary OAuth Authorization
         * @request POST:/api/v2/oauth/authorize
         * @response `200` `{
          \**
           * URL to redirect the user to
           * @format uri
           *\
          redirect_url?: string,
        
        }` Authorization processed successfully
         * @response `400` `{
          \** @example Missing required parameters: client_id, redirect_uri *\
          message?: string,
        
        }` Missing required parameters
         */
            authorize: (data, params = {}) => this.request(Object.assign({ path: `/api/v2/oauth/authorize`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbDataTableBulkAggregate = {
            /**
         * @description Read bulk aggregated data from a given table with given filters
         *
         * @tags DB Data Table Bulk Aggregate
         * @name DbDataTableBulkAggregate
         * @summary Read Bulk Aggregated Data
         * @request POST:/api/v2/tables/{tableId}/bulk/aggregate
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dbDataTableBulkAggregate: (tableId, query, data, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/bulk/aggregate`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.utils = {
            /**
         * @description List all comments
         *
         * @tags Utils
         * @name CommentList
         * @summary List Comments
         * @request GET:/api/v1/db/meta/comments
         * @response `200` `{
          list: (CommentType)[],
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            commentList: (query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/comments`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new comment in a row.
         *
         * @tags Utils
         * @name CommentRow
         * @summary Comment Rows
         * @request POST:/api/v1/db/meta/comments
         * @response `200` `CommentType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            commentRow: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/comments`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Update comment
             *
             * @tags Utils
             * @name CommentUpdate
             * @summary Update Comment
             * @request PATCH:/api/v1/db/meta/comment/{commentId}/
             * @response `200` `number` OK
             */
            commentUpdate: (commentId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/comment/${commentId}/`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Delete comment
             *
             * @tags Utils
             * @name CommentDelete
             * @summary Delete Comment
             * @request DELETE:/api/v1/db/meta/comment/{commentId}/
             * @response `200` `number` OK
             */
            commentDelete: (commentId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/comment/${commentId}/`, method: 'DELETE', body: data, format: 'json' }, params)),
            /**
         * @description Return the number of comments in the given query.
         *
         * @tags Utils
         * @name CommentCount
         * @summary Count Comments
         * @request GET:/api/v1/db/meta/comments/count
         * @response `200` `({
          \**
           * The number of comments
           * @example 4
           *\
          count: string,
          \**
           * Row ID
           * @example 1
           *\
          row_id: string,
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            commentCount: (query, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/comments/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Test the DB Connection
         *
         * @tags Utils
         * @name TestConnection
         * @summary Test DB Connection
         * @request POST:/api/v1/db/meta/connection/test
         * @response `200` `{
          code?: number,
          message?: string,
          data?: object,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            testConnection: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/connection/test`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Extract XC URL From JDBC and parse to connection config
         *
         * @tags Utils
         * @name UrlToConfig
         * @summary Convert JDBC URL to Config
         * @request POST:/api/v1/url_to_config
         * @response `200` `{
          \**
           * DB Type
           * @example mysql2
           *\
          client?: "mysql" | "mysql2" | "oracledb" | "pg" | "snowflake" | "sqlite3" | "databricks",
          \** Connection Config *\
          connection?: {
          \** DB User *\
          user?: string,
          \** DB Password *\
          password?: string,
          \** DB Name *\
          database?: string,
          \** DB Host *\
          host?: string,
          \** DB Host *\
          port?: string,
        
        },
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            urlToConfig: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/url_to_config`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the application info such as authType, defaultLimit, version and etc.
         *
         * @tags Utils
         * @name AppInfo
         * @summary Get App Info
         * @request GET:/api/v1/db/meta/nocodb/info
         * @response `200` `{
          authType?: string,
          baseHasAdmin?: boolean,
          firstUser?: boolean,
          type?: string,
          googleAuthEnabled?: boolean,
          githubAuthEnabled?: boolean,
          oneClick?: boolean,
          connectToExternalDB?: boolean,
          version?: string,
          defaultLimit?: number,
          ncMin?: boolean,
          teleEnabled?: boolean,
          errorReportingEnabled?: boolean,
          auditEnabled?: boolean,
          ncSiteUrl?: string,
          ee?: boolean,
          ncAttachmentFieldSize?: number,
          ncMaxAttachmentsAllowed?: number,
          isCloud?: boolean,
          \** @example OFF *\
          automationLogLevel?: "OFF" | "ERROR" | "ALL",
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            appInfo: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/nocodb/info`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Error Reporting
             *
             * @tags Utils, Internal
             * @name ErrorReport
             * @summary Error Reporting
             * @request POST:/api/v1/error-reporting
             */
            errorReport: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/error-reporting`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
         * @description Generic Axios Call
         *
         * @tags Utils
         * @name AxiosRequestMake
         * @summary Axios Request
         * @request POST:/api/v1/db/meta/axiosRequestMake
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            axiosRequestMake: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/axiosRequestMake`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the application version
         *
         * @tags Utils
         * @name AppVersion
         * @summary Get App Version
         * @request GET:/api/v1/version
         * @response `200` `{
          \**
           * Current NocoDB Version
           * @example 0.104.0
           *\
          currentVersion?: string,
          \**
           * Latest Release Version
           * @example 0.105.3
           *\
          releaseVersion?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            appVersion: (params = {}) => this.request(Object.assign({ path: `/api/v1/version`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Get Application Health Status
         *
         * @tags Utils
         * @name AppHealth
         * @summary Get Application Health Status
         * @request GET:/api/v1/health
         * @response `200` `{
          \** @example OK *\
          message?: string,
          \** @example 1678702175755 *\
          timestamp?: string,
          \** @example 1618.996877834 *\
          uptime?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            appHealth: (params = {}) => this.request(Object.assign({ path: `/api/v1/health`, method: 'GET', format: 'json' }, params)),
            /**
         * No description
         *
         * @tags Utils
         * @name Feed
         * @summary Get Feed
         * @request GET:/api/v2/feed
         * @response `200` `({
          Id?: string,
          Description?: string,
          Tags?: string,
          Images?: (object)[],
          Url?: string,
          "Published Time"?: string,
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            feed: (query, params = {}) => this.request(Object.assign({ path: `/api/v2/feed`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * No description
         *
         * @tags Utils
         * @name CloudFeatures
         * @summary Get Cloud Features
         * @request GET:/api/v2/cloud-features
         * @response `200` `({
          Id?: number,
          Title?: string,
          Highlight?: boolean,
          "Coming Soon"?: boolean,
        
        })[]` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            cloudFeatures: (params = {}) => this.request(Object.assign({ path: `/api/v2/cloud-features`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Get Aggregated Meta Info such as tableCount, dbViewCount, viewCount and etc.
         *
         * @tags Utils
         * @name AggregatedMetaInfo
         * @summary Get Aggregated Meta Info
         * @request GET:/api/v1/aggregated-meta-info
         * @response `200` `{
          baseCount?: number,
          bases?: ({
          tableCount?: {
          \** Table Count *\
          table?: number,
          \** View Count *\
          view?: number,
        
        },
          \** External Base *\
          external?: boolean,
          viewCount?: {
          \** Form Count *\
          formCount?: number,
          \** Grid Count *\
          gridCount?: number,
          \** Gallery Count *\
          galleryCount?: number,
          \** Kanban Count *\
          kanbanCount?: number,
          \** Calendar Count *\
          calendarCount?: number,
          \** Total View Count *\
          total?: number,
          \** Shared Form Count *\
          sharedFormCount?: number,
          \** Shared Grid Count *\
          sharedGridCount?: number,
          \** Shared Gallery Count *\
          sharedGalleryCount?: number,
          \** Shared Kanban Count *\
          sharedKanbanCount?: number,
          \** Shared Calendar Count *\
          sharedCalendarCount?: number,
          \** Shared Total View Count *\
          sharedTotal?: number,
          \** Shared Locked View Count *\
          sharedLockedCount?: number,
        
        },
          \** Webhook Count *\
          webhookCount?: number,
          \** Filter Count *\
          filterCount?: number,
          \** Sort Count *\
          sortCount?: number,
          \** Row Count *\
          rowCount?: ({
          TotalRecords?: string,
        
        })[],
          \** Total base user Count *\
          userCount?: number,
        
        })[],
          \** Total user Count *\
          userCount?: number,
          \** Total shared base Count *\
          sharedBaseCount?: number,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            aggregatedMetaInfo: (params = {}) => this.request(Object.assign({ path: `/api/v1/aggregated-meta-info`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Get All K/V pairs in NocoCache
             *
             * @tags Utils
             * @name CacheGet
             * @summary Get Cache
             * @request GET:/api/v1/db/meta/cache
             */
            cacheGet: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/cache`, method: 'GET' }, params)),
            /**
         * @description Delete All K/V pairs in NocoCache
         *
         * @tags Utils
         * @name CacheDelete
         * @summary Delete Cache
         * @request DELETE:/api/v1/db/meta/cache
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            cacheDelete: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/cache`, method: 'DELETE', format: 'json' }, params)),
            /**
             * @description Get dynamic command palette suggestions based on scope
             *
             * @tags Utils
             * @name CommandPalette
             * @summary Get command palette suggestions
             * @request POST:/api/v1/command_palette
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            commandPalette: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/command_palette`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.dbTableWebhook = {
            /**
         * @description List all hook records in the given Table
         *
         * @tags DB Table Webhook
         * @name List
         * @summary List Table Hooks
         * @request GET:/api/v1/db/meta/tables/{tableId}/hooks
         * @response `200` `HookListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (tableId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/hooks`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create a hook in the given table
         *
         * @tags DB Table Webhook
         * @name Create
         * @summary Create Table Hook
         * @request POST:/api/v1/db/meta/tables/{tableId}/hooks
         * @response `200` `HookType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/hooks`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Test the hook in the given Table
         *
         * @tags DB Table Webhook
         * @name Test
         * @summary Test Hook
         * @request POST:/api/v1/db/meta/tables/{tableId}/hooks/test
         * @response `200` `{
          \** @example The hook has been tested successfully *\
          msg?: string,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            test: (tableId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/hooks/test`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the sample hook payload
         *
         * @tags DB Table Webhook
         * @name SamplePayloadGet
         * @summary Get Sample Hook Payload
         * @request GET:/api/v1/db/meta/tables/{tableId}/hooks/samplePayload/{event}/{operation}/{version}
         * @response `200` `{
          \** Sample Payload Data *\
          data?: object,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            samplePayloadGet: (tableId, event, operation, version, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/tables/${tableId}/hooks/samplePayload/${event}/${operation}/${version}`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Update the exsiting hook by its ID
         *
         * @tags DB Table Webhook
         * @name Update
         * @summary Update Hook
         * @request PATCH:/api/v1/db/meta/hooks/{hookId}
         * @response `200` `HookType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (hookId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/hooks/${hookId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the exsiting hook by its ID
         *
         * @tags DB Table Webhook
         * @name Delete
         * @summary Delete Hook
         * @request DELETE:/api/v1/db/meta/hooks/{hookId}
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (hookId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/hooks/${hookId}`, method: 'DELETE', format: 'json' }, params)),
            /**
         * @description Trigger the manual WebHook
         *
         * @tags DB Table Webhook
         * @name Trigger
         * @summary Trigger Manual Hook
         * @request POST:/api/v2/meta/hooks/{hookId}/trigger/{rowId}
         * @response `200` `void` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            trigger: (hookId, rowId, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/hooks/${hookId}/trigger/${rowId}`, method: 'POST' }, params)),
        };
        this.plugin = {
            /**
         * @description List all plugins
         *
         * @tags Plugin
         * @name List
         * @summary List Plugins
         * @request GET:/api/v1/db/meta/plugins
         * @response `200` `{
          list?: (PluginType)[],
          \** Model for Paginated *\
          pageInfo?: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins`, method: 'GET', format: 'json' }, params)),
            /**
         * @description List all webhook plugins
         *
         * @tags Plugin
         * @name WebhookList
         * @summary Webhook List Plugins
         * @request GET:/api/v1/db/meta/plugins/webhook
         * @response `200` `{
          list?: (PluginType)[],
          \** Model for Paginated *\
          pageInfo?: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            webhookList: (params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins/webhook`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Check plugin is active or not
         *
         * @tags Plugin
         * @name Status
         * @summary Get Plugin Status
         * @request GET:/api/v1/db/meta/plugins/{pluginId}/status
         * @response `200` `boolean` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            status: (pluginId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins/${pluginId}/status`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Test if the plugin is working with the given configurations
         *
         * @tags Plugin
         * @name Test
         * @summary Test Plugin
         * @request POST:/api/v1/db/meta/plugins/test
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            test: (data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins/test`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Update the plugin data by ID
         *
         * @tags Plugin
         * @name Update
         * @summary Update Plugin
         * @request PATCH:/api/v1/db/meta/plugins/{pluginId}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (pluginId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins/${pluginId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get the plugin data by ID
         *
         * @tags Plugin
         * @name Read
         * @summary Get Plugin
         * @request GET:/api/v1/db/meta/plugins/{pluginId}
         * @response `200` `PluginType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (pluginId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/plugins/${pluginId}`, method: 'GET', format: 'json' }, params)),
        };
        this.apiToken = {
            /**
         * @description List API Tokens in the given base
         *
         * @tags API Token
         * @name List
         * @summary List API Tokens in Base
         * @request GET:/api/v1/db/meta/projects/{baseId}/api-tokens
         * @response `200` `ApiTokenListType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/api-tokens`, method: 'GET', format: 'json' }, params)),
            /**
         * @description Create API Token in a base
         *
         * @tags API Token
         * @name Create
         * @summary Create API Token
         * @request POST:/api/v1/db/meta/projects/{baseId}/api-tokens
         * @response `200` `ApiTokenType` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/api-tokens`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Delete the given API Token in base
         *
         * @tags API Token
         * @name Delete
         * @summary Delete API Token
         * @request DELETE:/api/v1/db/meta/projects/{baseId}/api-tokens/{tokenId}
         * @response `200` `number` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (baseId, tokenId, params = {}) => this.request(Object.assign({ path: `/api/v1/db/meta/projects/${baseId}/api-tokens/${tokenId}`, method: 'DELETE', format: 'json' }, params)),
        };
        this.storage = {
            /**
             * @description Upload attachment
             *
             * @tags Storage
             * @name Upload
             * @summary Attachment Upload
             * @request POST:/api/v1/db/storage/upload
             */
            upload: (query, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/storage/upload`, method: 'POST', query: query, body: data, type: ContentType.FormData }, params)),
            /**
             * @description Upload attachment by URL. Used in Airtable Migration.
             *
             * @tags Storage
             * @name UploadByUrl
             * @summary Attachment Upload by URL
             * @request POST:/api/v1/db/storage/upload-by-url
             */
            uploadByUrl: (query, data, params = {}) => this.request(Object.assign({ path: `/api/v1/db/storage/upload-by-url`, method: 'POST', query: query, body: data, type: ContentType.Json }, params)),
        };
        this.notification = {
            /**
             * @description Poll notifications
             *
             * @tags Notification
             * @name Poll
             * @summary Notification Poll
             * @request GET:/api/v1/notifications/poll
             * @response `200` `object` OK
             */
            poll: (params = {}) => this.request(Object.assign({ path: `/api/v1/notifications/poll`, method: 'GET', format: 'json' }, params)),
            /**
             * @description List notifications
             *
             * @tags Notification
             * @name List
             * @summary Notification list
             * @request GET:/api/v1/notifications
             * @response `200` `NotificationListType` OK
             */
            list: (query, params = {}) => this.request(Object.assign({ path: `/api/v1/notifications`, method: 'GET', query: query, format: 'json' }, params)),
            /**
             * @description Notificattion update
             *
             * @tags Notification
             * @name Update
             * @summary Notification update
             * @request PATCH:/api/v1/notifications/{notificationId}
             * @response `200` `void` OK
             */
            update: (notificationId, data, params = {}) => this.request(Object.assign({ path: `/api/v1/notifications/${notificationId}`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
            /**
             * @description Delete notification
             *
             * @tags Notification
             * @name Delete
             * @summary Delete notification
             * @request DELETE:/api/v1/notifications/{notificationId}
             * @response `200` `void` OK
             */
            delete: (notificationId, params = {}) => this.request(Object.assign({ path: `/api/v1/notifications/${notificationId}`, method: 'DELETE' }, params)),
            /**
             * @description Mark all notifications as read
             *
             * @tags Notification
             * @name MarkAllAsRead
             * @summary Mark all notifications as read
             * @request POST:/api/v1/notifications/mark-all-read
             * @response `200` `void` OK
             */
            markAllAsRead: (params = {}) => this.request(Object.assign({ path: `/api/v1/notifications/mark-all-read`, method: 'POST' }, params)),
        };
        this.dbDataTableAggregate = {
            /**
         * @description Read aggregated data from a given table
         *
         * @tags DB Data Table Aggregate
         * @name DbDataTableAggregate
         * @summary Read Aggregated Data
         * @request GET:/api/v2/tables/{tableId}/aggregate
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            dbDataTableAggregate: (tableId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/aggregate`, method: 'GET', query: query, format: 'json' }, params)),
        };
        this.dbDataTableRow = {
            /**
         * @description List all table rows in a given table
         *
         * @tags DB Data Table Row
         * @name List
         * @summary List Table Rows
         * @request GET:/api/v2/tables/{tableId}/records
         * @response `200` `{
          \** List of data objects *\
          list: (object)[],
          \** Paginated Info *\
          pageInfo: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            list: (tableId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a new row in a given table and base.
         *
         * @tags DB Data Table Row
         * @name Create
         * @summary Create Table Rows
         * @request POST:/api/v2/tables/{tableId}/records
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            create: (tableId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Create a new row in a given table and base.
         *
         * @tags DB Data Table Row
         * @name Update
         * @summary Update Table Rows
         * @request PATCH:/api/v2/tables/{tableId}/records
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            update: (tableId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records`, method: 'PATCH', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Create a new row in a given table and base.
         *
         * @tags DB Data Table Row
         * @name Delete
         * @summary Delete Table Rows
         * @request DELETE:/api/v2/tables/{tableId}/records
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            delete: (tableId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records`, method: 'DELETE', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Get table row in a given table
         *
         * @tags DB Data Table Row
         * @name Read
         * @summary Read Table Row
         * @request GET:/api/v2/tables/{tableId}/records/{rowId}
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            read: (tableId, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records/${rowId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Move the table row to new position
         *
         * @tags DB Data Table Row
         * @name Move
         * @summary Move Table Row
         * @request POST:/api/v2/tables/{tableId}/records/{rowId}/move
         * @response `200` `object` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            move: (tableId, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records/${rowId}/move`, method: 'POST', query: query, format: 'json' }, params)),
            /**
         * @description Count of rows in a given table
         *
         * @tags DB Data Table Row
         * @name Count
         * @summary Table Rows Count
         * @request GET:/api/v2/tables/{tableId}/records/count
         * @response `200` `{
          count?: number,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            count: (tableId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/records/count`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Linked rows in a given Links/LinkToAnotherRecord column
         *
         * @tags DB Data Table Row
         * @name NestedList
         * @summary Get Nested Relations Rows
         * @request GET:/api/v2/tables/{tableId}/links/{columnId}/records/{rowId}
         * @response `200` `{
          \** List of data objects *\
          list: (object)[],
          \** Paginated Info *\
          pageInfo: PaginatedType,
        
        }` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedList: (tableId, columnId, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/links/${columnId}/records/${rowId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Create a link with the row.
         *
         * @tags DB Data Table Row
         * @name NestedLink
         * @summary Create Nested Relations Rows
         * @request POST:/api/v2/tables/{tableId}/links/{columnId}/records/{rowId}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedLink: (tableId, columnId, rowId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/links/${columnId}/records/${rowId}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Create a new row in a given table and base.
         *
         * @tags DB Data Table Row
         * @name NestedUnlink
         * @summary Delete Nested Relations Rows
         * @request DELETE:/api/v2/tables/{tableId}/links/{columnId}/records/{rowId}
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedUnlink: (tableId, columnId, rowId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/links/${columnId}/records/${rowId}`, method: 'DELETE', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
         * @description Download attachment from a given row
         *
         * @tags DB Data Table Row
         * @name AttachmentDownload
         * @summary Download Attachment
         * @request GET:/api/v2/downloadAttachment/{modelId}/{columnId}/{rowId}
         * @response `200` `{
          \** URL to download attachment *\
          url?: string,
          \** Path to download attachment *\
          path?: string,
        
        }` OK
         */
            attachmentDownload: (modelId, columnId, rowId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/downloadAttachment/${modelId}/${columnId}/${rowId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
         * @description Copy links from the one cell and paste them into another cell or delete all records from cell
         *
         * @tags DB Data Table Row
         * @name NestedListCopyPasteOrDeleteAll
         * @summary Copy paste or deleteAll nested link
         * @request POST:/api/v2/tables/{tableId}/links/{columnId}/records
         * @response `200` `BaseUserDeleteRequestV3Type` OK
         * @response `400` `{
          \** @example BadRequest [Error]: <ERROR MESSAGE> *\
          msg: string,
        
        }`
         */
            nestedListCopyPasteOrDeleteAll: (tableId, columnId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/links/${columnId}/records`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.extensions = {
            /**
         * @description Get all extensions for a given base
         *
         * @tags Extensions
         * @name List
         * @summary Get Extensions
         * @request GET:/api/v2/extensions/{baseId}
         * @response `200` `{
          list?: (object)[],
        
        }` OK
         */
            list: (baseId, params = {}) => this.request(Object.assign({ path: `/api/v2/extensions/${baseId}`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Create a new extension for a given base
             *
             * @tags Extensions
             * @name Create
             * @summary Create Extension
             * @request POST:/api/v2/extensions/{baseId}
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            create: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/extensions/${baseId}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Get extension details
             *
             * @tags Extensions
             * @name Read
             * @summary Get Extension
             * @request GET:/api/v2/extensions/{extensionId}
             * @response `200` `object` OK
             */
            read: (extensionId, params = {}) => this.request(Object.assign({ path: `/api/v2/extensions/${extensionId}`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Update extension details
             *
             * @tags Extensions
             * @name Update
             * @summary Update Extension
             * @request PATCH:/api/v2/extensions/{extensionId}
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            update: (extensionId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/extensions/${extensionId}`, method: 'PATCH', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Delete extension
             *
             * @tags Extensions
             * @name Delete
             * @summary Delete Extension
             * @request DELETE:/api/v2/extensions/{extensionId}
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            delete: (extensionId, params = {}) => this.request(Object.assign({ path: `/api/v2/extensions/${extensionId}`, method: 'DELETE', format: 'json' }, params)),
        };
        this.jobs = {
            /**
             * @description Listen for job events
             *
             * @tags Jobs
             * @name Listen
             * @summary Jobs Listen
             * @request POST:/jobs/listen
             */
            listen: (data, params = {}) => this.request(Object.assign({ path: `/jobs/listen`, method: 'POST', body: data, type: ContentType.Json }, params)),
            /**
             * @description Get list of jobs for a given base for the user
             *
             * @tags Jobs
             * @name List
             * @summary Get Jobs
             * @request POST:/api/v2/jobs/{baseId}
             */
            list: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/jobs/${baseId}`, method: 'POST', body: data, type: ContentType.Json }, params)),
        };
        this.export = {
            /**
             * @description Trigger export as job
             *
             * @tags Export
             * @name Data
             * @summary Trigger export as job
             * @request POST:/api/v2/export/{viewId}/{exportAs}
             */
            data: (viewId, exportAs, data, params = {}) => this.request(Object.assign({ path: `/api/v2/export/${viewId}/${exportAs}`, method: 'POST', body: data, type: ContentType.Json }, params)),
        };
        this.ai = {
            /**
             * @description AI Utils
             *
             * @tags Ai
             * @name Utils
             * @summary AI Utils
             * @request POST:/api/v2/ai/bases/{baseId}/utils
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            utils: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/bases/${baseId}/utils`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description AI Completion
             *
             * @tags Ai
             * @name Completion
             * @summary AI Completion
             * @request POST:/api/v2/ai/bases/{baseId}/completion
             * @response `200` `object` OK
             */
            completion: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/bases/${baseId}/completion`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description AI Schema
             *
             * @tags Ai
             * @name Schema
             * @summary AI Schema
             * @request POST:/api/v2/ai/bases/{baseId}/schema
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            schema: (baseId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/bases/${baseId}/schema`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description AI Schema
             *
             * @tags Ai
             * @name SchemaCreate
             * @summary AI Schema
             * @request POST:/api/v2/ai/workspaces/{workspaceId}/bases
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            schemaCreate: (workspaceId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/workspaces/${workspaceId}/bases`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Generate AI data for specified rows
             *
             * @tags Ai
             * @name DataGenerate
             * @summary Generate AI Data
             * @request POST:/api/v2/ai/tables/{modelId}/rows/generate
             * @response `200` `(any)[]` OK
             */
            dataGenerate: (modelId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/tables/${modelId}/rows/generate`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Fill AI data for specified rows
             *
             * @tags Ai
             * @name DataFill
             * @summary Fill AI Data
             * @request POST:/api/v2/ai/tables/{modelId}/rows/fill
             * @response `200` `(any)[]` OK
             */
            dataFill: (modelId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/tables/${modelId}/rows/fill`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Extract AI data from the input
             *
             * @tags Ai
             * @name DataExtract
             * @summary Extract Data using AI
             * @request POST:/api/v2/ai/tables/{modelId}/extract
             * @response `200` `(any)[]` OK
             */
            dataExtract: (modelId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/ai/tables/${modelId}/extract`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.integration = {
            /**
             * @description List integrations
             *
             * @tags Integration
             * @name List
             * @summary List integrations
             * @request GET:/api/v2/meta/integrations
             * @response `200` `BaseUserDeleteRequestV3Type` OK
             */
            list: (query, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations`, method: 'GET', query: query, format: 'json' }, params)),
            /**
             * @description Create integration
             *
             * @tags Integration
             * @name Create
             * @summary Create integration
             * @request POST:/api/v2/meta/integrations
             * @response `200` `IntegrationType` OK
             */
            create: (data, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Read integration
             *
             * @tags Integration
             * @name Read
             * @summary Read integration
             * @request GET:/api/v2/meta/integrations/{integrationId}
             * @response `200` `IntegrationType` OK
             */
            read: (integrationId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations/${integrationId}`, method: 'GET', query: query, format: 'json' }, params)),
            /**
             * @description Update integration
             *
             * @tags Integration
             * @name Update
             * @summary Update integration
             * @request PATCH:/api/v2/meta/integrations/{integrationId}
             * @response `200` `void` OK
             */
            update: (integrationId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations/${integrationId}`, method: 'PATCH', body: data, type: ContentType.Json }, params)),
            /**
             * @description Delete integration
             *
             * @tags Integration
             * @name Delete
             * @summary Delete integration
             * @request DELETE:/api/v2/meta/integrations/{integrationId}
             * @response `200` `void` OK
             */
            delete: (integrationId, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations/${integrationId}`, method: 'DELETE' }, params)),
            /**
             * @description Set integration as category default
             *
             * @tags Integration
             * @name SetDefault
             * @summary Set integration as category default
             * @request PATCH:/api/v2/meta/integrations/{integrationId}/default
             * @response `200` `void` OK
             */
            setDefault: (integrationId, params = {}) => this.request(Object.assign({ path: `/api/v2/meta/integrations/${integrationId}/default`, method: 'PATCH' }, params)),
            /**
             * @description Store integration
             *
             * @tags Integration
             * @name Store
             * @summary Store integration
             * @request POST:/api/v2/integrations/:integrationId/store
             * @response `200` `void` OK
             */
            store: (integrationId, data, params = {}) => this.request(Object.assign({ path: `/api/v2/integrations/${integrationId}/store`, method: 'POST', body: data, type: ContentType.Json }, params)),
        };
        this.integrations = {
            /**
             * @description List available integrations
             *
             * @tags Integrations
             * @name List
             * @summary Integration List
             * @request GET:/api/v2/integrations
             * @response `200` `object` OK
             */
            list: (params = {}) => this.request(Object.assign({ path: `/api/v2/integrations`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Get info for integration
             *
             * @tags Integrations
             * @name Info
             * @summary Get Integration Info
             * @request GET:/api/v2/integrations/:type/:subType
             * @response `200` `object` OK
             */
            info: (type, subType, params = {}) => this.request(Object.assign({ path: `/api/v2/integrations/${type}/${subType}`, method: 'GET', format: 'json' }, params)),
            /**
             * @description Call exposed integration endpoint
             *
             * @tags Integrations
             * @name Endpoint
             * @summary Call exposed integration endpoint
             * @request POST:/api/v2/integrations/:integrationId/:endpoint
             * @response `200` `object` OK
             */
            endpoint: (integrationId, endpoint, data, params = {}) => this.request(Object.assign({ path: `/api/v2/integrations/${integrationId}/${endpoint}`, method: 'POST', body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.action = {
            /**
             * @description Trigger a button action
             *
             * @tags Action
             * @name TriggerButton
             * @summary Trigger a button action
             * @request POST:/api/v2/tables/:tableId/button/:fieldId
             * @response `200` `object` OK
             */
            triggerButton: (tableId, fieldId, data, query, params = {}) => this.request(Object.assign({ path: `/api/v2/tables/${tableId}/button/${fieldId}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
        };
        this.internal = {
            /**
             * @description Trigger an internal operation
             *
             * @tags Internal
             * @name PostOperation
             * @summary Trigger an internal operation
             * @request POST:/api/v2/internal/:workspaceId/:baseId
             * @response `200` `Record<string, any>` OK
             */
            postOperation: (workspaceId, baseId, query, data, params = {}) => this.request(Object.assign({ path: `/api/v2/internal/${workspaceId}/${baseId}`, method: 'POST', query: query, body: data, type: ContentType.Json, format: 'json' }, params)),
            /**
             * @description Trigger an internal operation
             *
             * @tags Internal
             * @name GetOperation
             * @summary Trigger an internal operation
             * @request GET:/api/v2/internal/:workspaceId/:baseId
             * @response `200` `Record<string, any>` OK
             */
            getOperation: (workspaceId, baseId, query, params = {}) => this.request(Object.assign({ path: `/api/v2/internal/${workspaceId}/${baseId}`, method: 'GET', query: query, format: 'json' }, params)),
        };
    }
}
exports.Api = Api;
//# sourceMappingURL=data:application/json;base64,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