"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CircularRefContext = void 0;
const arrayHelpers_1 = require("./arrayHelpers");
const error_handler_1 = require("./error-handler");
class CircularRefContext {
    constructor(existing) {
        this.refs = new Map();
        if ((existing === null || existing === void 0 ? void 0 : existing.size) > 0) {
            this.refs = new Map(existing);
        }
    }
    static make(...existingArr) {
        const existingRefs = [];
        for (const existing of existingArr) {
            if (existing &&
                !(existing instanceof CircularRefContext) &&
                !(existing instanceof Map)) {
                continue;
            }
            existingRefs.push(existing instanceof CircularRefContext ? existing.refs : existing);
        }
        // make immutable
        const result = new CircularRefContext(new Map((0, arrayHelpers_1.arrFlatMap)(existingRefs.map((k) => [...k]))));
        return result;
    }
    add(ref) {
        if (!ref) {
            return;
        }
        if (this.refs.has(ref.id)) {
            const [_root_id, root] = this.refs.entries().next().value;
            new error_handler_1.NcErrorBase().formulaCircularRefError(`Detected circular ref for column '${this.formatRef(ref)}', when evaluate column '${this.formatRef(root)}'`);
        }
        this.refs.set(ref.id, ref);
    }
    cloneAndAdd(ref) {
        const result = CircularRefContext.make(this);
        result.add(ref);
        return result;
    }
    formatRef(ref) {
        return `${ref.table ? ref.table + '.' : ''}${ref.title}`;
    }
}
exports.CircularRefContext = CircularRefContext;
//# sourceMappingURL=data:application/json;base64,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