"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.substituteColumnIdWithAliasInPrompt = substituteColumnIdWithAliasInPrompt;
const stringHelpers_1 = require("../stringHelpers");
function substituteColumnIdWithAliasInPrompt(prompt, columns, rawPrompt) {
    const columnIdMap = columns.reduce((acc, col) => {
        acc[col.id] = col;
        return acc;
    }, {});
    // Keep flexible regex: matches anything inside {}
    const regex = /{(.*?)}/g;
    const rawMatches = rawPrompt ? [...(0, stringHelpers_1.stringAllMatches)(rawPrompt, regex)] : [];
    let matchIndex = 0;
    const missingIds = [];
    const substituted = (prompt || '').replace(regex, (fullMatch, key) => {
        var _a;
        const idx = matchIndex++; // always advance
        const column = columnIdMap[key];
        if (column) {
            return `{${column.title}}`;
        }
        const oldName = (_a = rawMatches[idx]) === null || _a === void 0 ? void 0 : _a[1];
        if (oldName) {
            // Nothing found → keep original and log it
            missingIds.push({
                id: key,
                title: oldName,
            });
            return `{${oldName}}`;
        }
        // Nothing found → keep original and log it
        missingIds.push({
            id: key,
            title: key,
        });
        return fullMatch;
    });
    return { substituted, missingIds };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2FpL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBMkRBLGtGQStDQztBQXpHRCxvREFBb0Q7QUEwRHBELFNBQWdCLG1DQUFtQyxDQUNqRCxNQUFjLEVBQ2QsT0FBcUIsRUFDckIsU0FBa0I7SUFFbEIsTUFBTSxXQUFXLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRTtRQUM5QyxHQUFHLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEdBQUcsQ0FBQztRQUNsQixPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUMsRUFBRSxFQUFnQyxDQUFDLENBQUM7SUFFckMsa0RBQWtEO0lBQ2xELE1BQU0sS0FBSyxHQUFHLFVBQVUsQ0FBQztJQUV6QixNQUFNLFVBQVUsR0FBRyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFBLGdDQUFnQixFQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFFNUUsSUFBSSxVQUFVLEdBQUcsQ0FBQyxDQUFDO0lBQ25CLE1BQU0sVUFBVSxHQUFvQyxFQUFFLENBQUM7SUFFdkQsTUFBTSxXQUFXLEdBQUcsQ0FBQyxNQUFNLElBQUksRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFDLFNBQVMsRUFBRSxHQUFHLEVBQUUsRUFBRTs7UUFDbkUsTUFBTSxHQUFHLEdBQUcsVUFBVSxFQUFFLENBQUMsQ0FBQyxpQkFBaUI7UUFFM0MsTUFBTSxNQUFNLEdBQUcsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2hDLElBQUksTUFBTSxFQUFFLENBQUM7WUFDWCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssR0FBRyxDQUFDO1FBQzdCLENBQUM7UUFFRCxNQUFNLE9BQU8sR0FBRyxNQUFBLFVBQVUsQ0FBQyxHQUFHLENBQUMsMENBQUcsQ0FBQyxDQUFDLENBQUM7UUFFckMsSUFBSSxPQUFPLEVBQUUsQ0FBQztZQUNaLDJDQUEyQztZQUMzQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNkLEVBQUUsRUFBRSxHQUFHO2dCQUNQLEtBQUssRUFBRSxPQUFPO2FBQ2YsQ0FBQyxDQUFDO1lBQ0gsT0FBTyxJQUFJLE9BQU8sR0FBRyxDQUFDO1FBQ3hCLENBQUM7UUFFRCwyQ0FBMkM7UUFDM0MsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLEVBQUUsRUFBRSxHQUFHO1lBQ1AsS0FBSyxFQUFFLEdBQUc7U0FDWCxDQUFDLENBQUM7UUFFSCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDLENBQUMsQ0FBQztJQUVILE9BQU8sRUFBRSxXQUFXLEVBQUUsVUFBVSxFQUFFLENBQUM7QUFDckMsQ0FBQyJ9