"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arrFlatMap = exports.arrFlattenChildren = exports.arrGetDuplicate = exports.arrDetailedDiff = exports.arrIntersection = exports.arrUniq = void 0;
const arrUniq = (array) => {
    return [...new Set(array)];
};
exports.arrUniq = arrUniq;
const arrIntersection = (...arrays) => {
    return arrays.reduce((a, b) => a.filter((c) => b.includes(c)));
};
exports.arrIntersection = arrIntersection;
const arrDetailedDiff = (a, b) => {
    const intersected = (0, exports.arrIntersection)(a, b);
    return {
        removed: a.filter((old) => !intersected.includes(old)),
        intersected,
        added: b.filter((n) => !intersected.includes(n)),
    };
};
exports.arrDetailedDiff = arrDetailedDiff;
const arrGetDuplicate = (data) => {
    const dataSet = new Set();
    for (const each of data) {
        if (dataSet.has(each)) {
            return each;
        }
        dataSet.add(each);
    }
    return undefined;
};
exports.arrGetDuplicate = arrGetDuplicate;
const arrFlattenChildren = (param, acc = []) => {
    for (const each of param.payload) {
        acc.push(each);
        const children = param.childHandle(each);
        if (children && children.length > 0) {
            (0, exports.arrFlattenChildren)({
                payload: children,
                childHandle: param.childHandle,
            }, acc);
        }
    }
    return acc;
};
exports.arrFlattenChildren = arrFlattenChildren;
// fallback due to target tsconfig not support flatMap
const arrFlatMap = (array) => {
    return array.reduce((a, b) => a.concat(b), []);
};
exports.arrFlatMap = arrFlatMap;
//# sourceMappingURL=data:application/json;base64,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