"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const arrayHelpers_1 = require("./arrayHelpers");
describe('arrayHelpers', () => {
    describe('arrIntersection', () => {
        it('will intersect 2 array', () => {
            const a = ['a', 'b', 'c'];
            const b = ['c', 'd', 'e'];
            const result = (0, arrayHelpers_1.arrIntersection)(a, b);
            expect(result).toEqual(['c']);
        });
    });
    describe('arrDetailedDiff', () => {
        it('will detailed diff 2 array', () => {
            const a = ['a', 'b', 'c'];
            const b = ['c', 'd', 'e'];
            const result = (0, arrayHelpers_1.arrDetailedDiff)(a, b);
            expect(result).toEqual({
                removed: ['a', 'b'],
                intersected: ['c'],
                added: ['d', 'e'],
            });
        });
    });
    describe('arrFlattenChildren', () => {
        it('will flatten children', () => {
            const payload = [
                {
                    name: 'foo',
                    children: [
                        {
                            name: 'bar',
                        },
                        {
                            name: 'baz',
                        },
                    ],
                },
                {
                    name: 'foo2',
                    children: [
                        {
                            name: 'bar2',
                        },
                        {
                            name: 'baz2',
                            children: [
                                {
                                    name: 'buz2',
                                },
                            ],
                        },
                    ],
                },
                {
                    name: 'foo3',
                },
            ];
            const result = (0, arrayHelpers_1.arrFlattenChildren)({
                payload,
                childHandle: (each) => {
                    return each.children;
                },
            });
            expect(result.map((k) => k.name).join(',')).toBe('foo,bar,baz,foo2,bar2,baz2,buz2,foo3');
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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