"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.auditOperationSubTypeLabels = exports.auditOperationTypeLabels = exports.AuditOperationSubTypes = exports.AuditOperationTypes = void 0;
var AuditOperationTypes;
(function (AuditOperationTypes) {
    AuditOperationTypes["COMMENT"] = "COMMENT";
    AuditOperationTypes["DATA"] = "DATA";
    AuditOperationTypes["PROJECT"] = "PROJECT";
    AuditOperationTypes["VIRTUAL_RELATION"] = "VIRTUAL_RELATION";
    AuditOperationTypes["RELATION"] = "RELATION";
    AuditOperationTypes["TABLE_VIEW"] = "TABLE_VIEW";
    AuditOperationTypes["TABLE"] = "TABLE";
    AuditOperationTypes["VIEW"] = "VIEW";
    AuditOperationTypes["META"] = "META";
    AuditOperationTypes["TABLE_COLUMN"] = "TABLE_COLUMN";
    AuditOperationTypes["WEBHOOKS"] = "WEBHOOKS";
    AuditOperationTypes["AUTHENTICATION"] = "AUTHENTICATION";
    AuditOperationTypes["ORG_USER"] = "ORG_USER";
})(AuditOperationTypes || (exports.AuditOperationTypes = AuditOperationTypes = {}));
var AuditOperationSubTypes;
(function (AuditOperationSubTypes) {
    AuditOperationSubTypes["INSERT"] = "INSERT";
    AuditOperationSubTypes["CREATE"] = "CREATE";
    AuditOperationSubTypes["UPDATE"] = "UPDATE";
    AuditOperationSubTypes["DELETE"] = "DELETE";
    AuditOperationSubTypes["BULK_INSERT"] = "BULK_INSERT";
    AuditOperationSubTypes["BULK_UPDATE"] = "BULK_UPDATE";
    AuditOperationSubTypes["BULK_DELETE"] = "BULK_DELETE";
    AuditOperationSubTypes["LINK_RECORD"] = "LINK_RECORD";
    AuditOperationSubTypes["UNLINK_RECORD"] = "UNLINK_RECORD";
    AuditOperationSubTypes["RENAME"] = "RENAME";
    AuditOperationSubTypes["IMPORT_FROM_ZIP"] = "IMPORT_FROM_ZIP";
    AuditOperationSubTypes["EXPORT_TO_FS"] = "EXPORT_TO_FS";
    AuditOperationSubTypes["EXPORT_TO_ZIP"] = "EXPORT_TO_ZIP";
    AuditOperationSubTypes["SIGNIN"] = "SIGNIN";
    AuditOperationSubTypes["SIGNUP"] = "SIGNUP";
    AuditOperationSubTypes["PASSWORD_RESET"] = "PASSWORD_RESET";
    AuditOperationSubTypes["PASSWORD_FORGOT"] = "PASSWORD_FORGOT";
    AuditOperationSubTypes["PASSWORD_CHANGE"] = "PASSWORD_CHANGE";
    AuditOperationSubTypes["EMAIL_VERIFICATION"] = "EMAIL_VERIFICATION";
    AuditOperationSubTypes["ROLES_MANAGEMENT"] = "ROLES_MANAGEMENT";
    AuditOperationSubTypes["INVITE"] = "INVITE";
    AuditOperationSubTypes["RESEND_INVITE"] = "RESEND_INVITE";
})(AuditOperationSubTypes || (exports.AuditOperationSubTypes = AuditOperationSubTypes = {}));
const auditOperationTypeLabels = {
    [AuditOperationTypes.COMMENT]: 'Comment',
    [AuditOperationTypes.DATA]: 'Data',
    [AuditOperationTypes.PROJECT]: 'Project',
    [AuditOperationTypes.VIRTUAL_RELATION]: 'Virtual Relation',
    [AuditOperationTypes.RELATION]: 'Relation',
    [AuditOperationTypes.TABLE_VIEW]: 'Table View',
    [AuditOperationTypes.TABLE]: 'Table',
    [AuditOperationTypes.VIEW]: 'View',
    [AuditOperationTypes.META]: 'Meta',
    [AuditOperationTypes.WEBHOOKS]: 'Webhooks',
    [AuditOperationTypes.AUTHENTICATION]: 'Authentication',
    [AuditOperationTypes.TABLE_COLUMN]: 'Table Column',
    [AuditOperationTypes.ORG_USER]: 'Org User',
};
exports.auditOperationTypeLabels = auditOperationTypeLabels;
const auditOperationSubTypeLabels = {
    [AuditOperationSubTypes.UPDATE]: 'Update',
    [AuditOperationSubTypes.INSERT]: 'Insert',
    [AuditOperationSubTypes.DELETE]: 'Delete',
    [AuditOperationSubTypes.BULK_INSERT]: 'Bulk Insert',
    [AuditOperationSubTypes.BULK_UPDATE]: 'Bulk Update',
    [AuditOperationSubTypes.BULK_DELETE]: 'Bulk Delete',
    [AuditOperationSubTypes.LINK_RECORD]: 'Link Record',
    [AuditOperationSubTypes.UNLINK_RECORD]: 'Unlink Record',
    [AuditOperationSubTypes.CREATE]: 'Create',
    [AuditOperationSubTypes.RENAME]: 'Rename',
    [AuditOperationSubTypes.IMPORT_FROM_ZIP]: 'Import From Zip',
    [AuditOperationSubTypes.EXPORT_TO_FS]: 'Export To FS',
    [AuditOperationSubTypes.EXPORT_TO_ZIP]: 'Export To Zip',
    [AuditOperationSubTypes.SIGNIN]: 'Signin',
    [AuditOperationSubTypes.SIGNUP]: 'Signup',
    [AuditOperationSubTypes.PASSWORD_RESET]: 'Password Reset',
    [AuditOperationSubTypes.PASSWORD_FORGOT]: 'Password Forgot',
    [AuditOperationSubTypes.PASSWORD_CHANGE]: 'Password Change',
    [AuditOperationSubTypes.EMAIL_VERIFICATION]: 'Email Verification',
    [AuditOperationSubTypes.ROLES_MANAGEMENT]: 'Roles Management',
    [AuditOperationSubTypes.INVITE]: 'Invite',
    [AuditOperationSubTypes.RESEND_INVITE]: 'Resend Invite',
};
exports.auditOperationSubTypeLabels = auditOperationSubTypeLabels;
//# sourceMappingURL=data:application/json;base64,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