"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuditV1OperationTypes = exports.auditV1OperationsCategory = exports.auditV1OperationTypesAlias = void 0;
exports.auditDescription = auditDescription;
var AuditV1OperationTypes;
(function (AuditV1OperationTypes) {
    AuditV1OperationTypes["USER_SIGNUP"] = "USER_SIGNUP";
    AuditV1OperationTypes["USER_SIGNIN"] = "USER_SIGNIN";
    AuditV1OperationTypes["USER_INVITE"] = "USER_INVITE";
    AuditV1OperationTypes["WORKSPACE_USER_INVITE"] = "WORKSPACE_USER_INVITE";
    AuditV1OperationTypes["WORKSPACE_USER_UPDATE"] = "WORKSPACE_USER_UPDATE";
    AuditV1OperationTypes["WORKSPACE_USER_DELETE"] = "WORKSPACE_USER_DELETE";
    AuditV1OperationTypes["WORKSPACE_TEAM_INVITE"] = "WORKSPACE_TEAM_INVITE";
    AuditV1OperationTypes["WORKSPACE_TEAM_UPDATE"] = "WORKSPACE_TEAM_UPDATE";
    AuditV1OperationTypes["WORKSPACE_TEAM_DELETE"] = "WORKSPACE_TEAM_DELETE";
    AuditV1OperationTypes["USER_PASSWORD_CHANGE"] = "USER_PASSWORD_CHANGE";
    AuditV1OperationTypes["USER_PASSWORD_RESET"] = "USER_PASSWORD_RESET";
    AuditV1OperationTypes["USER_PASSWORD_FORGOT"] = "USER_PASSWORD_FORGOT";
    AuditV1OperationTypes["USER_EMAIL_VERIFY"] = "USER_EMAIL_VERIFY";
    AuditV1OperationTypes["BASE_USER_INVITE"] = "BASE_USER_INVITE";
    AuditV1OperationTypes["BASE_USER_UPDATE"] = "BASE_USER_UPDATE";
    AuditV1OperationTypes["BASE_USER_INVITE_RESEND"] = "BASE_USER_INVITE_RESEND";
    AuditV1OperationTypes["BASE_TEAM_INVITE"] = "BASE_TEAM_INVITE";
    AuditV1OperationTypes["BASE_TEAM_UPDATE"] = "BASE_TEAM_UPDATE";
    AuditV1OperationTypes["BASE_TEAM_DELETE"] = "BASE_TEAM_DELETE";
    AuditV1OperationTypes["TABLE_CREATE"] = "TABLE_CREATE";
    AuditV1OperationTypes["TABLE_DELETE"] = "TABLE_DELETE";
    AuditV1OperationTypes["COLUMN_CREATE"] = "FIELD_CREATE";
    AuditV1OperationTypes["COLUMN_UPDATE"] = "FIELD_UPDATE";
    AuditV1OperationTypes["COLUMN_DELETE"] = "FIELD_DELETE";
    AuditV1OperationTypes["COLUMN_RENAME"] = "FIELD_RENAME";
    AuditV1OperationTypes["ORG_USER_INVITE"] = "ORG_USER_INVITE";
    AuditV1OperationTypes["ORG_USER_INVITE_RESEND"] = "ORG_USER_INVITE_RESEND";
    AuditV1OperationTypes["DATA_INSERT"] = "DATA_INSERT";
    AuditV1OperationTypes["DATA_UPDATE"] = "DATA_UPDATE";
    AuditV1OperationTypes["DATA_DELETE"] = "DATA_DELETE";
    AuditV1OperationTypes["DATA_BULK_INSERT"] = "DATA_BULK_INSERT";
    AuditV1OperationTypes["DATA_BULK_UPDATE"] = "DATA_BULK_UPDATE";
    AuditV1OperationTypes["DATA_BULK_DELETE"] = "DATA_BULK_DELETE";
    AuditV1OperationTypes["DATA_BULK_ALL_DELETE"] = "DATA_BULK_ALL_DELETE";
    AuditV1OperationTypes["DATA_BULK_ALL_UPDATE"] = "DATA_BULK_ALL_UPDATE";
    AuditV1OperationTypes["DATA_LINK"] = "DATA_LINK";
    AuditV1OperationTypes["DATA_UNLINK"] = "DATA_UNLINK";
    AuditV1OperationTypes["WORKSPACE_CREATE"] = "WORKSPACE_CREATE";
    AuditV1OperationTypes["WORKSPACE_UPDATE"] = "WORKSPACE_UPDATE";
    AuditV1OperationTypes["WORKSPACE_DELETE"] = "WORKSPACE_DELETE";
    AuditV1OperationTypes["WORKSPACE_RENAME"] = "WORKSPACE_RENAME";
    AuditV1OperationTypes["BASE_CREATE"] = "BASE_CREATE";
    AuditV1OperationTypes["BASE_UPDATE"] = "BASE_UPDATE";
    AuditV1OperationTypes["BASE_DELETE"] = "BASE_DELETE";
    AuditV1OperationTypes["BASE_RENAME"] = "BASE_RENAME";
    AuditV1OperationTypes["VIEW_CREATE"] = "VIEW_CREATE";
    AuditV1OperationTypes["VIEW_UPDATE"] = "VIEW_UPDATE";
    AuditV1OperationTypes["VIEW_DELETE"] = "VIEW_DELETE";
    AuditV1OperationTypes["VIEW_RENAME"] = "VIEW_RENAME";
    AuditV1OperationTypes["HOOK_CREATE"] = "HOOK_CREATE";
    AuditV1OperationTypes["HOOK_UPDATE"] = "HOOK_UPDATE";
    AuditV1OperationTypes["HOOK_DELETE"] = "HOOK_DELETE";
    AuditV1OperationTypes["HOOK_FILTER_CREATE"] = "HOOK_FILTER_CREATE";
    AuditV1OperationTypes["HOOK_FILTER_UPDATE"] = "HOOK_FILTER_UPDATE";
    AuditV1OperationTypes["HOOK_FILTER_DELETE"] = "HOOK_FILTER_DELETE";
    AuditV1OperationTypes["VIEW_FILTER_CREATE"] = "VIEW_FILTER_CREATE";
    AuditV1OperationTypes["VIEW_FILTER_UPDATE"] = "VIEW_FILTER_UPDATE";
    AuditV1OperationTypes["VIEW_FILTER_DELETE"] = "VIEW_FILTER_DELETE";
    AuditV1OperationTypes["LINK_FILTER_CREATE"] = "LINK_FILTER_CREATE";
    AuditV1OperationTypes["LINK_FILTER_UPDATE"] = "LINK_FILTER_UPDATE";
    AuditV1OperationTypes["LINK_FILTER_DELETE"] = "LINK_FILTER_DELETE";
    AuditV1OperationTypes["WIDGET_FILTER_CREATE"] = "WIDGET_FILTER_CREATE";
    AuditV1OperationTypes["WIDGET_FILTER_UPDATE"] = "WIDGET_FILTER_UPDATE";
    AuditV1OperationTypes["WIDGET_FILTER_DELETE"] = "WIDGET_FILTER_DELETE";
    AuditV1OperationTypes["VIEW_SORT_CREATE"] = "VIEW_SORT_CREATE";
    AuditV1OperationTypes["VIEW_SORT_UPDATE"] = "VIEW_SORT_UPDATE";
    AuditV1OperationTypes["VIEW_SORT_DELETE"] = "VIEW_SORT_DELETE";
    AuditV1OperationTypes["SHARED_BASE_CREATE"] = "SHARED_BASE_CREATE";
    AuditV1OperationTypes["SHARED_BASE_DELETE"] = "SHARED_BASE_DELETE";
    AuditV1OperationTypes["SOURCE_CREATE"] = "SOURCE_CREATE";
    AuditV1OperationTypes["SOURCE_UPDATE"] = "SOURCE_UPDATE";
    AuditV1OperationTypes["SOURCE_DELETE"] = "SOURCE_DELETE";
    AuditV1OperationTypes["SOURCE_RENAME"] = "SOURCE_RENAME";
    AuditV1OperationTypes["SHARED_VIEW_DELETE"] = "SHARED_VIEW_DELETE";
    AuditV1OperationTypes["SHARED_VIEW_CREATE"] = "SHARED_VIEW_CREATE";
    AuditV1OperationTypes["SHARED_VIEW_UPDATE"] = "SHARED_VIEW_UPDATE";
    AuditV1OperationTypes["API_TOKEN_DELETE"] = "API_TOKEN_DELETE";
    AuditV1OperationTypes["API_TOKEN_CREATE"] = "API_TOKEN_CREATE";
    AuditV1OperationTypes["BASE_DUPLICATE"] = "BASE_DUPLICATE";
    AuditV1OperationTypes["BASE_DUPLICATE_ERROR"] = "BASE_DUPLICATE_ERROR";
    AuditV1OperationTypes["TABLE_DUPLICATE"] = "TABLE_DUPLICATE";
    AuditV1OperationTypes["TABLE_DUPLICATE_ERROR"] = "TABLE_DUPLICATE_ERROR";
    AuditV1OperationTypes["COLUMN_DUPLICATE"] = "FIELD_DUPLICATE";
    AuditV1OperationTypes["COLUMN_DUPLICATE_ERROR"] = "FIELD_DUPLICATE_ERROR";
    AuditV1OperationTypes["VIEW_DUPLICATE"] = "VIEW_DUPLICATE";
    AuditV1OperationTypes["VIEW_DUPLICATE_ERROR"] = "VIEW_DUPLICATE_ERROR";
    AuditV1OperationTypes["FORM_COLUMN_UPDATE"] = "FORM_FIELD_UPDATE";
    AuditV1OperationTypes["USER_SIGNOUT"] = "USER_SIGNOUT";
    AuditV1OperationTypes["TABLE_UPDATE"] = "TABLE_UPDATE";
    AuditV1OperationTypes["TABLE_RENAME"] = "TABLE_RENAME";
    AuditV1OperationTypes["VIEW_COLUMN_UPDATE"] = "VIEW_FIELD_UPDATE";
    AuditV1OperationTypes["UI_ACL"] = "UI_ACL";
    AuditV1OperationTypes["AIRTABLE_IMPORT"] = "AIRTABLE_IMPORT";
    AuditV1OperationTypes["AIRTABLE_IMPORT_ERROR"] = "AIRTABLE_IMPORT_ERROR";
    AuditV1OperationTypes["INTEGRATION_CREATE"] = "INTEGRATION_CREATE";
    AuditV1OperationTypes["INTEGRATION_UPDATE"] = "INTEGRATION_UPDATE";
    AuditV1OperationTypes["INTEGRATION_DELETE"] = "INTEGRATION_DELETE";
    AuditV1OperationTypes["SNAPSHOT_DELETE"] = "SNAPSHOT_DELETE";
    AuditV1OperationTypes["SNAPSHOT_CREATE"] = "SNAPSHOT_CREATE";
    AuditV1OperationTypes["SNAPSHOT_RESTORE"] = "SNAPSHOT_RESTORE";
    AuditV1OperationTypes["DATA_IMPORT"] = "DATA_IMPORT";
    AuditV1OperationTypes["DATA_EXPORT"] = "DATA_EXPORT";
    AuditV1OperationTypes["USER_PROFILE_UPDATE"] = "USER_PROFILE_UPDATE";
    AuditV1OperationTypes["SCRIPT_CREATE"] = "SCRIPT_CREATE";
    AuditV1OperationTypes["SCRIPT_UPDATE"] = "SCRIPT_UPDATE";
    AuditV1OperationTypes["SCRIPT_DELETE"] = "SCRIPT_DELETE";
    AuditV1OperationTypes["SCRIPT_DUPLICATE"] = "SCRIPT_DUPLICATE";
    AuditV1OperationTypes["DASHBOARD_CREATE"] = "DASHBOARD_CREATE";
    AuditV1OperationTypes["DASHBOARD_UPDATE"] = "DASHBOARD_UPDATE";
    AuditV1OperationTypes["DASHBOARD_DELETE"] = "DASHBOARD_DELETE";
    AuditV1OperationTypes["DASHBOARD_DUPLICATE"] = "DASHBOARD_DUPLICATE";
    AuditV1OperationTypes["DASHBOARD_DUPLICATE_ERROR"] = "DASHBOARD_DUPLICATE_ERROR";
    AuditV1OperationTypes["SHARED_DASHBOARD_CREATE"] = "SHARED_DASHBOARD_CREATE";
    AuditV1OperationTypes["SHARED_DASHBOARD_DELETE"] = "SHARED_DASHBOARD_DELETE";
    AuditV1OperationTypes["SHARED_DASHBOARD_UPDATE"] = "SHARED_DASHBOARD_UPDATE";
    AuditV1OperationTypes["WIDGET_CREATE"] = "WIDGET_CREATE";
    AuditV1OperationTypes["WIDGET_UPDATE"] = "WIDGET_UPDATE";
    AuditV1OperationTypes["WIDGET_DELETE"] = "WIDGET_DELETE";
    AuditV1OperationTypes["WIDGET_DUPLICATE"] = "WIDGET_DUPLICATE";
    AuditV1OperationTypes["PERMISSION_CREATE"] = "PERMISSION_CREATE";
    AuditV1OperationTypes["PERMISSION_UPDATE"] = "PERMISSION_UPDATE";
    AuditV1OperationTypes["PERMISSION_DELETE"] = "PERMISSION_DELETE";
    AuditV1OperationTypes["TEAM_CREATE"] = "TEAM_CREATE";
    AuditV1OperationTypes["TEAM_UPDATE"] = "TEAM_UPDATE";
    AuditV1OperationTypes["TEAM_DELETE"] = "TEAM_DELETE";
    AuditV1OperationTypes["TEAM_MEMBER_ADD"] = "TEAM_MEMBER_ADD";
    AuditV1OperationTypes["TEAM_MEMBER_UPDATE"] = "TEAM_MEMBER_UPDATE";
    AuditV1OperationTypes["TEAM_MEMBER_DELETE"] = "TEAM_MEMBER_DELETE";
    AuditV1OperationTypes["WORKFLOW_CREATE"] = "WORKFLOW_CREATE";
    AuditV1OperationTypes["WORKFLOW_UPDATE"] = "WORKFLOW_UPDATE";
    AuditV1OperationTypes["WORKFLOW_DELETE"] = "WORKFLOW_DELETE";
    AuditV1OperationTypes["WORKFLOW_DUPLICATE"] = "WORKFLOW_DUPLICATE";
})(AuditV1OperationTypes || (exports.AuditV1OperationTypes = AuditV1OperationTypes = {}));
exports.auditV1OperationTypesAlias = Object.values(AuditV1OperationTypes).reduce((acc, key) => {
    // Convert snake_case or UPPER_SNAKE_CASE to readable format
    // Capitalize each word
    acc[key] = key
        .replace(/_/g, ' ') // Replace underscores with spaces
        .toLowerCase() // Convert to lowercase
        .replace(/\b[a-z]/g, (char) => char.toUpperCase());
    return acc;
}, {});
/**
 * For audit logs table filter usecase only
 */
exports.auditV1OperationsCategory = {
    DATA: {
        label: 'general.data',
        value: 'DATA',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('DATA_') || key.startsWith('AIRTABLE_')),
    },
    FIELD: {
        label: 'objects.column',
        value: 'FIELD',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('FIELD_') ||
            key.startsWith('FORM_COLUMN_') ||
            key.startsWith('VIEW_COLUMN_') ||
            key.startsWith('LINK_FILTER_')),
    },
    VIEW: {
        label: 'objects.view',
        value: 'VIEW',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('VIEW_') && !key.startsWith('VIEW_COLUMN_')),
    },
    TABLE: {
        label: 'objects.table',
        value: 'TABLE',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('TABLE_')),
    },
    BASE: {
        label: 'objects.project',
        value: 'BASE',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('BASE_') ||
            key.startsWith('SNAPSHOT_') ||
            key.startsWith('UI_ACL')),
    },
    SOURCE: {
        label: 'general.source',
        value: 'SOURCE',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('SOURCE_')),
    },
    SHARED: {
        label: 'general.shared',
        value: 'SHARED',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('SHARED_')),
    },
    USER: {
        label: 'objects.user',
        value: 'USER',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('USER_')),
    },
    WORKSPACE: {
        label: 'objects.workspace',
        value: 'WORKSPACE',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('WORKSPACE_')),
    },
    TEAM: {
        label: 'objects.team',
        value: 'TEAM',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('TEAM_')),
    },
    HOOK: {
        label: 'objects.webhook',
        value: 'HOOK',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('HOOK_')),
    },
    INTEGRATION: {
        label: 'general.integration',
        value: 'INTEGRATION',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('INTEGRATION_')),
    },
    API: {
        label: 'title.apiTokens',
        value: 'API',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('API_')),
    },
    ORG: {
        label: 'general.organization',
        value: 'ORG',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('ORG_')),
    },
    SCRIPT: {
        label: 'general.script',
        value: 'SCRIPT',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('SCRIPT_')),
    },
    DASHBOARD: {
        label: 'objects.dashboard',
        value: 'DASHBOARD',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('DASHBOARD_') || key.startsWith('WIDGET_')),
    },
    WORKFLOW: {
        label: 'objects.workflow',
        value: 'WORKFLOW',
        types: Object.values(AuditV1OperationTypes).filter((key) => key.startsWith('WORKFLOW_')),
    },
};
const descriptionTemplates = {
    [AuditV1OperationTypes.USER_SIGNUP]: (audit) => `User '${audit.user}' signed up`,
    [AuditV1OperationTypes.USER_SIGNIN]: (audit) => `User '${audit.user}' signed in`,
    [AuditV1OperationTypes.USER_INVITE]: (audit) => `User '${audit.user}' invited '${audit.details.user_email}'`,
    [AuditV1OperationTypes.USER_PASSWORD_CHANGE]: (audit) => `User '${audit.user}' changed password`,
    [AuditV1OperationTypes.USER_PASSWORD_RESET]: (audit) => `User '${audit.user}' reset password`,
    [AuditV1OperationTypes.USER_PASSWORD_FORGOT]: (audit) => `User '${audit.user}' forgot password`,
    [AuditV1OperationTypes.USER_EMAIL_VERIFY]: (audit) => `User '${audit.user}' verified email`,
    [AuditV1OperationTypes.BASE_USER_INVITE]: (audit) => `User '${audit.user}' invited '${audit.details.user_email}' to base`,
    [AuditV1OperationTypes.BASE_USER_INVITE_RESEND]: (audit) => `User '${audit.user}' resent invite to '${audit.details.user_email}'`,
    [AuditV1OperationTypes.BASE_USER_UPDATE]: (audit) => `User '${audit.user}' updated role of '${audit.details.user_email}'`,
    [AuditV1OperationTypes.TABLE_CREATE]: (audit) => `User '${audit.user}' created table '${audit.details.table_title}'`,
    [AuditV1OperationTypes.TABLE_DELETE]: (audit) => `User '${audit.user}' deleted table '${audit.details.table_title}'`,
    [AuditV1OperationTypes.ORG_USER_INVITE]: (audit) => `User '${audit.user}' invited '${audit.details.email}' to organization`,
    [AuditV1OperationTypes.ORG_USER_INVITE_RESEND]: (audit) => `User '${audit.user}' resent invite to '${audit.details.email}'`,
    [AuditV1OperationTypes.DATA_INSERT]: (audit) => `Record with ID [${audit.row_id}] has been inserted`,
    [AuditV1OperationTypes.DATA_UPDATE]: (audit) => `Record with ID [${audit.row_id}] has been updated`,
    [AuditV1OperationTypes.DATA_DELETE]: (audit) => `Record with ID [${audit.row_id}] has been deleted`,
    /*  [AuditV1OperationTypes.DATA_BULK_INSERT]: (
      audit: AuditV1<DataBulkInsertPayload>
    ) =>
      `${audit.details.data.length} ${
        audit.details.data.length > 1 ? 'records have been' : 'record has been'
      } inserted`,
    [AuditV1OperationTypes.DATA_BULK_UPDATE]: (
      audit: AuditV1<DataBulkUpdatePayload>
    ) =>
      `${audit.details.data.length} ${
        audit.details.data.length > 1 ? 'records have been' : 'record has been'
      } updated`,
    [AuditV1OperationTypes.DATA_BULK_DELETE]: (
      audit: AuditV1<DataBulkDeletePayload>
    ) =>
      `${audit.details.data.length} ${
        audit.details.data.length > 1 ? 'records have been' : 'record has been'
      } deleted`,*/
    [AuditV1OperationTypes.DATA_LINK]: (audit) => `Record [id:${audit.details.ref_row_id}] has been linked with record [id:${audit.details.row_id}] in ${audit.details.table_title}`,
    [AuditV1OperationTypes.DATA_UNLINK]: (audit) => `Record [id:${audit.details.ref_row_id}] has been unlinked from record [id:${audit.details.row_id}] in ${audit.details.table_title}`,
    [AuditV1OperationTypes.WORKSPACE_CREATE]: (audit) => `Workspace '${audit.details.workspace_title}' has been created`,
    [AuditV1OperationTypes.WORKSPACE_UPDATE]: (audit) => `Workspace '${audit.details.workspace_title}' has been updated`,
    [AuditV1OperationTypes.WORKSPACE_DELETE]: (audit) => `Workspace '${audit.details.workspace_title}' has been deleted`,
    [AuditV1OperationTypes.WORKSPACE_RENAME]: (audit) => `Workspace '${audit.details.old_workspace_title}' has been renamed to '${audit.details.new_workspace_title}'`,
    [AuditV1OperationTypes.BASE_CREATE]: (audit) => `Base '${audit.details.base_title}' has been created`,
    [AuditV1OperationTypes.BASE_UPDATE]: (audit) => `Base '${audit.details.base_title}' has been updated`,
    [AuditV1OperationTypes.BASE_DELETE]: (audit) => `Base '${audit.details.base_title}' has been deleted`,
    [AuditV1OperationTypes.BASE_RENAME]: (audit) => `Base '${audit.details.old_base_title}' has been renamed to '${audit.details.new_base_title}'`,
    [AuditV1OperationTypes.BASE_DUPLICATE]: (audit) => `Base '${audit.details.source_base_title}' has been duplicated`,
    [AuditV1OperationTypes.VIEW_CREATE]: (audit) => `${audit.details.view_type.replace(/^\w/, (m) => m.toUpperCase())} '${audit.details.view_title}' has been created`,
    [AuditV1OperationTypes.VIEW_UPDATE]: (audit) => `${audit.details.view_type.replace(/^\w/, (m) => m.toUpperCase())} '${audit.details.view_title}' has been updated`,
    [AuditV1OperationTypes.VIEW_DELETE]: (audit) => `${audit.details.view_type.replace(/^\w/, (m) => m.toUpperCase())} '${audit.details.view_title}' has been deleted`,
    [AuditV1OperationTypes.VIEW_RENAME]: (audit) => `${audit.details.view_type.replace(/^\w/, (m) => m.toUpperCase())} '${audit.details.old_view_title}' has been renamed to '${audit.details.new_view_title}'`,
    [AuditV1OperationTypes.VIEW_DUPLICATE]: (m) => `${m.details.view_type.replace(/^\w/, (m) => m.toUpperCase())} '${m.details.source_view_title}' has been duplicated`,
    [AuditV1OperationTypes.COLUMN_CREATE]: (audit) => `Field '${audit.details.view_title}' has been created`,
    [AuditV1OperationTypes.COLUMN_UPDATE]: (audit) => `Field '${audit.details.view_title}' has been updated`,
    [AuditV1OperationTypes.COLUMN_DELETE]: (audit) => `Field '${audit.details.view_title}' has been deleted`,
    [AuditV1OperationTypes.COLUMN_RENAME]: (audit) => `Field '${audit.details.old_view_title}' has been renamed to '${audit.details.new_view_title}'`,
    [AuditV1OperationTypes.COLUMN_DUPLICATE]: (audit) => `Field '${audit.details.source_field_title}' has been duplicated`,
    [AuditV1OperationTypes.HOOK_CREATE]: (audit) => `Hook '${audit.details.hook_title}' has been created`,
    [AuditV1OperationTypes.HOOK_UPDATE]: (audit) => `Hook '${audit.details.hook_title}' has been updated`,
    [AuditV1OperationTypes.HOOK_DELETE]: (audit) => `Hook '${audit.details.hook_title}' has been deleted`,
    [AuditV1OperationTypes.HOOK_FILTER_CREATE]: (audit) => `Filter with column '${audit.details.filter_field_id}' and operation '${audit.details.filter_comparison_op}' has been created`,
    [AuditV1OperationTypes.SCRIPT_CREATE]: (audit) => `Script '${audit.details.script_title}' has been created`,
    [AuditV1OperationTypes.SCRIPT_UPDATE]: (audit) => `Script '${audit.details.script_title}' has been updated`,
    [AuditV1OperationTypes.SCRIPT_DELETE]: (audit) => `Script '${audit.details.script_title}' has been deleted`,
    [AuditV1OperationTypes.SCRIPT_DUPLICATE]: (audit) => `Script '${audit.details.source_script_title}' has been duplicated`,
    [AuditV1OperationTypes.DASHBOARD_CREATE]: (audit) => `Dashboard '${audit.details.dashboard_title}' has been created`,
    [AuditV1OperationTypes.DASHBOARD_UPDATE]: (audit) => `Dashboard '${audit.details.dashboard_title}' has been updated`,
    [AuditV1OperationTypes.DASHBOARD_DELETE]: (audit) => `Dashboard '${audit.details.dashboard_title}' has been deleted`,
    [AuditV1OperationTypes.DASHBOARD_DUPLICATE]: (audit) => `Dashboard '${audit.details.source_dashboard_title}' has been duplicated`,
    [AuditV1OperationTypes.SHARED_DASHBOARD_CREATE]: (audit) => `Shared dashboard '${audit.details.dashboard_title}' has been created`,
    [AuditV1OperationTypes.SHARED_DASHBOARD_DELETE]: (audit) => `Shared dashboard '${audit.details.dashboard_title}' has been deleted`,
    [AuditV1OperationTypes.SHARED_DASHBOARD_UPDATE]: (audit) => `Shared dashboard '${audit.details.dashboard_title}' has been updated`,
    [AuditV1OperationTypes.WIDGET_CREATE]: (audit) => `Widget '${audit.details.widget_title}' has been created`,
    [AuditV1OperationTypes.WIDGET_UPDATE]: (audit) => `Widget '${audit.details.widget_title}' has been updated`,
    [AuditV1OperationTypes.WIDGET_DELETE]: (audit) => `Widget '${audit.details.widget_title}' has been deleted`,
    [AuditV1OperationTypes.WIDGET_DUPLICATE]: (audit) => `Widget '${audit.details.duplicated_widget_title}' has been duplicated`,
    [AuditV1OperationTypes.PERMISSION_CREATE]: (audit) => `Permission '${audit.details.permission}' has been created for entity '${audit.details.entity}' with ID '${audit.details.entity_id}'`,
    [AuditV1OperationTypes.PERMISSION_UPDATE]: (audit) => `Permission '${audit.details.permission}' has been updated for entity '${audit.details.entity}' with ID '${audit.details.entity_id}'`,
    [AuditV1OperationTypes.PERMISSION_DELETE]: (audit) => `Permission '${audit.details.permission}' has been deleted for entity '${audit.details.entity}' with ID '${audit.details.entity_id}'`,
    [AuditV1OperationTypes.WORKFLOW_CREATE]: (audit) => `Workflow '${audit.details.workflow_title}' has been created`,
    [AuditV1OperationTypes.WORKFLOW_UPDATE]: (audit) => `Workflow '${audit.details.workflow_title}' has been updated`,
    [AuditV1OperationTypes.WORKFLOW_DELETE]: (audit) => `Workflow '${audit.details.workflow_title}' has been deleted`,
    [AuditV1OperationTypes.WORKFLOW_DUPLICATE]: (audit) => `Workflow '${audit.details.duplicated_workflow_title}' has been duplicated`,
};
function auditDescription(audit) {
    return descriptionTemplates[audit.op_type](audit);
}
//# sourceMappingURL=data:application/json;base64,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