"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTrueCircularReplacer = exports.getCircularReplacer = void 0;
const getCircularReplacer = () => {
    const seen = new WeakSet();
    return (_, value) => {
        if (typeof value === 'object' && value !== null) {
            if (seen.has(value)) {
                return;
            }
            seen.add(value);
        }
        return value;
    };
};
exports.getCircularReplacer = getCircularReplacer;
// Replacer that only removes true circular references, not repeated references
const getTrueCircularReplacer = () => {
    const stack = []; // objects along the current traversal path
    return function replacer(_, value) {
        // Keep the stack aligned with the current traversal parent (`this`)
        const parentIndex = stack.indexOf(this);
        if (parentIndex === -1) {
            // entering a new branch
            stack.push(this);
        }
        else {
            // moving to a sibling; pop anything deeper than the current parent
            stack.length = parentIndex + 1;
        }
        if (value && typeof value === 'object') {
            // If the next value is already somewhere in the current path, it's a cycle
            if (stack.indexOf(value) !== -1) {
                // return undefined to avoid circular reference
                return undefined;
            }
            // push this value as we descend into it next
            stack.push(value);
        }
        return value;
    };
};
exports.getTrueCircularReplacer = getTrueCircularReplacer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2lyY3VsYXJSZXBsYWNlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9saWIvY2lyY3VsYXJSZXBsYWNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBTyxNQUFNLG1CQUFtQixHQUFHLEdBQUcsRUFBRTtJQUN0QyxNQUFNLElBQUksR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDO0lBQzNCLE9BQU8sQ0FBQyxDQUFDLEVBQUUsS0FBSyxFQUFFLEVBQUU7UUFDbEIsSUFBSSxPQUFPLEtBQUssS0FBSyxRQUFRLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ2hELElBQUksSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO2dCQUNwQixPQUFPO1lBQ1QsQ0FBQztZQUNELElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEIsQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQyxDQUFDO0FBQ0osQ0FBQyxDQUFDO0FBWFcsUUFBQSxtQkFBbUIsdUJBVzlCO0FBRUYsK0VBQStFO0FBQ3hFLE1BQU0sdUJBQXVCLEdBQUcsR0FBRyxFQUFFO0lBQzFDLE1BQU0sS0FBSyxHQUFHLEVBQUUsQ0FBQyxDQUFDLDJDQUEyQztJQUU3RCxPQUFPLFNBQVMsUUFBUSxDQUFDLENBQUMsRUFBRSxLQUFLO1FBQy9CLG9FQUFvRTtRQUNwRSxNQUFNLFdBQVcsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3hDLElBQUksV0FBVyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFDdkIsd0JBQXdCO1lBQ3hCLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDbkIsQ0FBQzthQUFNLENBQUM7WUFDTixtRUFBbUU7WUFDbkUsS0FBSyxDQUFDLE1BQU0sR0FBRyxXQUFXLEdBQUcsQ0FBQyxDQUFDO1FBQ2pDLENBQUM7UUFFRCxJQUFJLEtBQUssSUFBSSxPQUFPLEtBQUssS0FBSyxRQUFRLEVBQUUsQ0FBQztZQUN2QywyRUFBMkU7WUFDM0UsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7Z0JBQ2hDLCtDQUErQztnQkFDL0MsT0FBTyxTQUFTLENBQUM7WUFDbkIsQ0FBQztZQUNELDZDQUE2QztZQUM3QyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3BCLENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUMsQ0FBQztBQUNKLENBQUMsQ0FBQztBQTFCVyxRQUFBLHVCQUF1QiwyQkEwQmxDIn0=